#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"
#include "psf_exits.h"
#include "main.h"
#include "util.h"
#include "symtab.h"
#include "buildtil.h"
#include "lexyacc.h"

#define main_mod_ff "\"fc main\" <fc>\"generated by fc_lts\""
#define struct_ff   "<n>\"struct\" <o>1"
#define behav_ff    "<n>\"behav\" <o>1"
#define logic_ff    "<n>\"logic\" <o>1"
#define hook_ff     "<n>\"hook\" <o>1"
#define any_ff      "<n>\"any\" <o>1"
#define struct_index 1
#define behav_index  2
#define logic_index  3
#define hook_index   4
#define any_index    5

unsigned int max_entries[MTABLE];

/* initliatize the til-module structire */
void init_module(mod)
tilmodule *mod;
{
    int i;
    
    for (i = 0; i < MTABLE; i++) {
	mod->entries_table[i] = 0;
	max_entries[i] = 1;
    }
    mod->adm = PSF_MALLOC(adm_tuple);
    mod->sor = PSF_MALLOC(sor_tuple);
    mod->fun = PSF_MALLOC(fun_tuple);
    mod->atm = PSF_MALLOC(atm_tuple);
    mod->pro = PSF_MALLOC(pro_tuple);
    mod->set = PSF_MALLOC(set_tuple);
    mod->com = PSF_MALLOC(com_tuple);
    mod->var = PSF_MALLOC(var_tuple);
    mod->equ = PSF_MALLOC(equ_tuple);
    mod->def = PSF_MALLOC(def_tuple);

#ifdef	EXTTIL
    mod->dataed = PSF_MALLOC(dataed_tuple);
    mod->proced = PSF_MALLOC(proced_tuple);
#endif
}

/* what to do if a module entry grows and grows and grows.... */
void enlarge_entries(tnr, mod)
tabletype tnr;
tilmodule *mod;
{
    max_entries[tnr] *= 2;
    switch (tnr) {
    case ADM:
	mod->adm = PSF_REALLOC(mod->adm,adm_tuple, max_entries[tnr]);
	break;
    case SOR:
	mod->sor = PSF_REALLOC(mod->sor,sor_tuple, max_entries[tnr]);
	break;
    case FUN:
	mod->fun = PSF_REALLOC(mod->fun,fun_tuple, max_entries[tnr]);
	break;
    case ATM:
	mod->atm = PSF_REALLOC(mod->atm,atm_tuple, max_entries[tnr]);
	break;
    case PRO:
	mod->pro = PSF_REALLOC(mod->pro,pro_tuple, max_entries[tnr]);
	break;
    case SET:
	mod->set = PSF_REALLOC(mod->set,set_tuple, max_entries[tnr]);
	break;
    case COM:
	mod->com = PSF_REALLOC(mod->com,com_tuple, max_entries[tnr]);
	break;
    case VAR:
	mod->var = PSF_REALLOC(mod->var,var_tuple, max_entries[tnr]);
	break;
    case EQU:
	mod->equ = PSF_REALLOC(mod->equ,equ_tuple, max_entries[tnr]);
	break;
    case DEF:
	mod->def = PSF_REALLOC(mod->def,def_tuple, max_entries[tnr]);
	break;

#ifdef	EXTTIL
    case DATAED:
	mod->dataed = PSF_REALLOC(mod->dataed,dataed_tuple, max_entries[tnr]);
	break;
    case PROCED:
	mod->proced = PSF_REALLOC(mod->proced,proced_tuple, max_entries[tnr]);
	break;
#endif
    }
}

/* returns last written entry from table */
unsigned int current_entry(tnr,mod)
tabletype tnr;
tilmodule *mod;
{
    return (mod->entries_table[tnr]);
}

/* add an entry in the table */
unsigned int add_entry(tnr, mod)
tabletype tnr;
tilmodule *mod;
{
    if (++mod->entries_table[tnr] == max_entries[tnr])
	enlarge_entries(tnr, mod);
    return (current_entry(tnr,mod));
}

/* generate the module sorts */
void tilsor(mod)
tilmodule *mod;
{
    unsigned int i;

    i = add_entry(SOR,mod);
    mod->sor[i].ff = PSF_NMALLOC(char,strlen(struct_ff)+1);
    sprintf(mod->sor[i].ff,struct_ff);

    i = add_entry(SOR,mod);
    mod->sor[i].ff = PSF_NMALLOC(char,strlen(behav_ff)+1);
    sprintf(mod->sor[i].ff,behav_ff);

    i = add_entry(SOR,mod);
    mod->sor[i].ff = PSF_NMALLOC(char,strlen(logic_ff)+1);
    sprintf(mod->sor[i].ff,logic_ff);

    i = add_entry(SOR,mod);
    mod->sor[i].ff = PSF_NMALLOC(char,strlen(hook_ff)+1);
    sprintf(mod->sor[i].ff,hook_ff);

    i = add_entry(SOR,mod);
    mod->sor[i].ff = PSF_NMALLOC(char,strlen(any_ff)+1);
    sprintf(mod->sor[i].ff,any_ff);
}

char *netname(n)
netitem *n;
{
    labelitem *li;

    if (n->tl) {
	li = structlabel(n->tl->lab);
	if (li) {
	    if (li->exp->operator == STRING) {
		return (map[li->exp->value].text);
	    } 
	}
    }
    return (NULL);
}

/* generate the main module */
void tiladm(n,mod)
netstable *n;
tilmodule *mod;
{
    freeformat s = PSF_NMALLOC(char,255);
    unsigned int i;

    if (n) { /* do main net */
	i = add_entry(ADM,mod);
	sprintf(s,"<m>%d %s",i,main_mod_ff);
	mod->adm[i].ff = strfit(s);
	FORALL(n->nlst,i) {
	    netitem *ni = (netitem *)getitem(n->nlst,i);
	    i = add_entry(ADM,mod);
	    if (netname(ni)) {
		sprintf(s,"<m>%d %s",i,netname(ni));
	    } else {
		sprintf(s,"<m>%d %s",i,"\"no name\"");
	    }
	    mod->adm[i].ff = strfit(s);
	}
    PSF_FREE(s);
    }
}

/* sort indices are fixed, so here's what the order is */
int sortindex(t)
int t;
{
    switch(t) {
    case STRUCT:
	return(struct_index);
    case BEHAV:
	return(behav_index);
    case LOGIC:
	return(logic_index);
    case HOOK:
	return(hook_index);
    case ANY:
	return(any_index);
    default:
	return(-1);
    }
}

/* fill a functions definition entry using the definition in the
   symbol table
*/
void fill_fun_entry(i,j,e)
int i;
unsigned int j;
opentry *e;
{
    int k;

    mod->fun[j].sor_indlist.a = e->a; 
    mod->fun[j].sor_indlist.indlist = PSF_NMALLOC(struct indextype,e->a);
    for (k=0; k < e->a; k++) {
	mod->fun[j].sor_indlist.indlist[k].table = SOR;
	mod->fun[j].sor_indlist.indlist[k].key = sortindex(e->domain[k]);
    }
    mod->fun[j].return_list.a = 1; 
    mod->fun[j].return_list.indlist = PSF_NMALLOC(struct indextype,1);
    mod->fun[j].return_list.indlist[0].table = SOR;
    mod->fun[j].return_list.indlist[0].key = sortindex(e->codomain);
    mod->fun[j].ff = PSF_NMALLOC(char,strlen("<n> <>o1")+strlen(map[i].text));
    sprintf(mod->fun[j].ff,"<n>\"%s\" <o>1",map[i].text);
}

/* generate function definition entries in the module */
void tilfun(mod)
tilmodule *mod;
{
    int i;
    unsigned int j;

    for (i=1; i < mapindex; i++) {
	opentry *entry = (opentry *)map[i].info;
	switch (map[i].type) {
	case INFIX:
	case INFIX0:
	case INFIX1:
	case INFIX2:
	case INFIX3:
	case INFIX4:
	case INFIX5:
	case PREFIX:
	case UNARY:
	case CONSTANT:
	    j = add_entry(FUN,mod);
	    fill_fun_entry(i,j,entry);
	    break;
	}
    }
}

void tilatmadd(e,o,mod)
tableentry *e;
int o;
tilmodule *mod;
{
    int j;
    freeformat s = PSF_NMALLOC(char,255);

    j = add_entry(ATM,mod);
    e->tilindex = j; /* for later use ! */
    e->tiltype = ATM; /* for later use ! */
    mod->atm[j].sor_indlist.a = 0;
    mod->atm[j].sor_indlist.indlist = PSF_NMALLOC(struct indextype,1);
    mod->atm[j].sor_indlist.indlist[0].table = ATM;
    mod->atm[j].sor_indlist.indlist[0].key = j;
    if (e->id >= 0) {
	sprintf(s,"<n>%s <o>%d <fc>\"id=%d\"",qstrexpr(e->exp),o,e->id);
    } else {
	sprintf(s,"<n>%s <o>%d",qstrexpr(e->exp),o);
    }
    mod->atm[j].ff = strfit(s);

    PSF_FREE(s);
}

void tilatmpertable(t,o,mod)
tableitem *t;
int o;
tilmodule *mod;
{
    int i;

    if ((t->typ == BEHAV) && (t->ind != INDIRECT)) { 
	/* only "direct" "behav" tables */
	FORALL(t->ilst,i) {
	    tableentry *e = (tableentry *)getitem(t->ilst,i);
	    tilatmadd(e,o,mod);
	}
    }
}

/* retrieve all atom definitions from the fc spec */
/* atoms are in the "behav" tables */
void tilatm(n,mod)
netstable *n;
tilmodule *mod;
{
    int i, j;
    int org = 1;

    if (n) { /* do main net */
	if (n->tl) { /* tables present ? */
	    FORALL(n->tl->tab,i) { /* every table */
		tilatmpertable((tableitem *)getitem(n->tl->tab,i),org,mod);
	    }
	}

	FORALL(n->nlst,i) { /* do every subnet */
	    netitem *ni = (netitem *)getitem(n->nlst,i);
	    org++;
	    FORALL(ni->tl->tab,j) { /* every table */
		tilatmpertable((tableitem *)getitem(ni->tl->tab,j),org,mod);
	    }
	}
    }
}

int tilproadd(e,o,mod)
tableentry *e;
int o;
tilmodule *mod;
{
    int j;
    freeformat s = PSF_NMALLOC(char,255);

    j = add_entry(PRO,mod);
    e->tilindex = j; /* for later use ! */
    e->tiltype = PRO; /* for later use ! */
    mod->pro[j].sor_indlist.a = 0;
    mod->pro[j].sor_indlist.indlist = PSF_NMALLOC(struct indextype,1);
    mod->pro[j].sor_indlist.indlist[0].table = PRO;
    mod->pro[j].sor_indlist.indlist[0].key = j;
    if (e->id >= 0) {
	sprintf(s,"<n>%s <o>%d <fc>\"id=%d\"",qstrexpr(e->exp),o,e->id);
    } else {
	sprintf(s,"<n>%s <o>%d",qstrexpr(e->exp),o);
    }
    mod->pro[j].ff = strfit(s);

    PSF_FREE(s);
    return (j);
}

void tilpropertable(t,o,mod)
tableitem *t;
int o;
tilmodule *mod;
{
    int i;

    if ((t->typ == STRUCT) && (t->ind != INDIRECT)) { 
	/* only "direct" "struct" tables */
	FORALL(t->ilst,i) {
	    tableentry *e = (tableentry *)getitem(t->ilst,i);
	    (void)tilproadd(e,o,mod);
	}
    }
}

/* retrieve all process declarations from the fc spec */
/* processes declarations are in the "struct" tables */
void tilpro(n,mod)
netstable *n;
tilmodule *mod;
{
    int i, j;
    int org = 1;

    if (n) { /* do main net */
	if (n->tl) { /* tables present ? */
	    FORALL(n->tl->tab,i) { /* every table */
		tilpropertable((tableitem *)getitem(n->tl->tab,i),org,mod);
	    }
	}

	FORALL(n->nlst,i) { /* do every subnet */
	    netitem *ni = (netitem *)getitem(n->nlst,i);
	    org++;
	    FORALL(ni->tl->tab,j) { /* every table */
		tilpropertable((tableitem *)getitem(ni->tl->tab,j),org,mod);
	    }
	}
    }
}

/* find "v+ofs"-th index in the table of type "t" in "l"
   if not present NULL is returned.
*/
INDEXTYPE *localtableindex(l,e,t,ofs)
list *l;
expr *e;
int t;
int *ofs;
{
    INDEXTYPE *index = NULL;
    tableitem *ti = typedtable(l,t);
    int j;
    int k = -1;
    int val;

    if (ti) {
	if (ti->ind == INDIRECT) {
	    *ofs = ti->ofs;
	} else {
	    switch (e->operator) {
	    case REF:
	    case INDIRECT:
	    case INTEGER:
		val = eval(e) + *ofs;
		break;
            case STRING:
		val = -2;
		break;
	    case CONSTANT:
		val = -2;
		break;
	    default:
		fprintf(stderr,"Unknown expression operator type in localtableindex.\n");
		exit(EXIT_HELP); 
	    }
	    FORALL(ti->ilst,j) {
		tableentry *te = (tableentry *)getitem(ti->ilst,j);
		k++;
		if ((te->id == val) || ((te->id == -1) && (k == val)) ||
		    ((val == -2) && 
		     (strcmp(map[te->exp->value].text,map[e->value].text) == 0))) {
		    INDEXTYPE *index = PSF_MALLOC(INDEXTYPE);
		    index->table = te->tiltype;
		    index->key = te->tilindex;
		    return (index);
		}
	    }

	}
    }
    return (index);
}

/* find type "e"-th table item in type "t" table in "lt" or "gt" or "vlt".
   if not found add it in "vlt" 
*/
INDEXTYPE *tableindex(gt,lt,vlt,e,t)
list *gt;
list *lt;
list *vlt;
expr *e;
int t;
{
    INDEXTYPE *ind = NULL;
    int ofs = 0;

    switch (e->operator) {
    case REF:
    case INDIRECT:
	ind = localtableindex(gt,e,t,&ofs);
	if (ind == NULL) {
	    ind = localtableindex(vlt,e,t,&ofs);
	}
	break;
    case INTEGER:
	ind = localtableindex(lt,e,t,&ofs);
	if (ind == NULL) {
	    ind = localtableindex(gt,e,t,&ofs);
	    if (ind == NULL) {
		ind = localtableindex(vlt,e,t,&ofs);
	    }
	}
	break;
    case STRING:
	ind = localtableindex(lt,e,t,&ofs);
	if (ind == NULL) {
	    ind = localtableindex(gt,e,t,&ofs);
	    if (ind == NULL) {
		ind = localtableindex(vlt,e,t,&ofs);
	    }
	}
	break;
    case CONSTANT:
	ind = localtableindex(lt,e,t,&ofs);
	if (ind == NULL) {
	    ind = localtableindex(gt,e,t,&ofs);
	    if (ind == NULL) {
		ind = PSF_MALLOC(INDEXTYPE);
		ind->table = CONSTANT; /* just a large value that will not occurr */
		ind->key = e->value;
	    }
	}
	break;
    default:
	fprintf(stderr,"Unknown expression operator type in tableindex.\n");
	exit(EXIT_HELP);
    }
    return (ind);
}


/* find a type "t" label in "l" and use it's value as an index in the
   local "lt" table or "gt" or "vlt" table
*/
INDEXTYPE *labelindex(gt,lt,vlt,l,t)
list *gt; /* list of tableitem */
list *lt; /* list of tableitem */
list *vlt; /* list of tableitem */
list *l;  /* list of labelitem */
int t;    /* type */
{
    if (l) {
	labelitem *li = typedlabel(l,t);
	if (li) {
	    return (tableindex(gt,lt,vlt,li->exp,t));
	}
    }
    return (NULL);
}

/* returns the til index of the struct label value connected to the
   vertex indexed by e */
INDEXTYPE *vertexindex(n,gt,lt,vlt,e)
netitem *n;
list *gt;
list *lt;
list *vlt;
expr *e;
{
    vertexitem *vi = findvertex(n,e);
    if (vi) {
	return (labelindex(gt,lt,vlt,vi->lab,STRUCT));
    }
    return (NULL);
}

/* build an indexlist from the number of STRUCT type indices in the expression
   currently only '+', INTEGER, REF, INDIRECT, STRING are allowed as operator 
*/
INDEXLIST *vertexlist(n,gt,lt,vlt,e,l)
netitem *n;
list *gt;
list *lt;
list *vlt;
expr *e;
INDEXLIST *l;
{
    INDEXLIST *il = l;
    INDEXTYPE *ind;

    if (e) {
	switch (e->operator) {
	case INTEGER:
	case INDIRECT:
	case REF:
	case STRING:
	    ind = vertexindex(n,gt,lt,vlt,e); 
	    if (ind) {
		if (il == NULL) {
		    il = PSF_MALLOC(INDEXLIST);
		    il->a = 0;
		    il->indlist = PSF_MALLOC(INDEXTYPE);
		}
		il->a++;
		il->indlist = PSF_REALLOC(il->indlist,INDEXTYPE,il->a);
		il->indlist[il->a-1].table = ind->table;
		il->indlist[il->a-1].key = ind->key;
		PSF_FREE(ind);
	    }
	    break;
	case INFIX4:
	    il = vertexlist(n,gt,lt,vlt,e->left,il);
	    il = vertexlist(n,gt,lt,vlt,e->right,il);
	    break;
	default:
	    fprintf(stderr,"Illegal operator type in vertexlist.\n");
	    exit(EXIT_HELP);
	}
    }
    return (il);	
}

/* retrieve all process definitions from the fc spec */
/* process definitions are in the "vertice" tables */
void tildef(n,mod)
netstable *n;
tilmodule *mod;
{
    int i, j, k;
    int ind;
    int org = 1;
    char *s = PSF_NMALLOC(char,255);
    INDEXTYPE *trigger;
    INDEXTYPE *source;
    INDEXLIST *destination;

    if (n) {
	list *gt = n->tl ? n->tl->tab : NULL;
	FORALL(n->nlst,i) { /* every subnet */
	    netitem *ni = (netitem *)getitem(n->nlst,i);
	    list *lt = ni->tl ? ni->tl->tab : NULL;
	    org++;
	    FORALL(ni->vlst,j) { /* every vertex */
		vertexitem *vi = (vertexitem *)getitem(ni->vlst,j);
		source = labelindex(gt,lt,ni->vlt,vi->lab,STRUCT);
		if (source == NULL) {
		    /* add very local struct entry and til PRO entry */
		    labelitem *sli = typedlabel(vi->lab,STRUCT);
		    tableentry *ste = createtableentry(-1,sli->exp);
		    ni->vlt = addtypedtableentry(ni->vlt,STRUCT,ste);
		    tilproadd(ste,org,mod);
		    source = labelindex(NULL,NULL,ni->vlt,vi->lab,STRUCT);
		    if (source == NULL) {
			/* this cannot happen ! */
			fprintf(stderr,"Huh ?\n");
			exit(EXIT_HELP);
		    }
		}
	 	FORALL(vi->elst,k) { /* every edge */
		    edgeitem *ei = (edgeitem *)getitem(vi->elst,k);
		    /* trigger is of type BEHAV */
		    trigger = labelindex(gt,lt,ni->vlt,ei->lab,BEHAV);
		    if (trigger == NULL) {
			/* add very local behav entry and til ATM entry */
			labelitem *tli = typedlabel(vi->lab,BEHAV);
			tableentry *tte = createtableentry(-1,tli->exp);
			ni->vlt = addtypedtableentry(ni->vlt,BEHAV,tte);
			tilatmadd(tte,org,mod);
			trigger = labelindex(NULL,NULL,ni->vlt,ei->lab,BEHAV);
			if (trigger == NULL) {
			    /* this cannot happen ! */
			    fprintf(stderr,"Huh ?\n");
			    exit(EXIT_HELP);
			}
		    }
		    /* destination can be multiple of type STRUCT */
		    destination = vertexlist(ni,gt,lt,ni->vlt,ei->slst,NULL);
		    if (destination == NULL) {
			/* add very local struct entry's and til PRO entry's */
			/* for now just take the first one !! PP */
			tableentry *dte;
			labelitem *dli;
			vertexitem *dvi;
			switch (ei->slst->operator) {
			case INTEGER:
			case STRING:
			    dvi = findvertex(ni,ei->slst);
			    break;
			case INFIX4:
			    dvi = findvertex(ni,ei->slst->left);
			    break;
			}
			dli = structlabel(dvi->lab);
			dte = createtableentry(-1,dli->exp);
			ni->vlt = addtypedtableentry(ni->vlt,STRUCT,dte);
			tilproadd(dte,org,mod);
			destination = vertexlist(ni,gt,lt,ni->vlt,ei->slst,NULL);
			if (destination == NULL) {
			    /* this cannot happen ! */
			    fprintf(stderr,"Huh ?\n");
			    exit(EXIT_HELP);
			}
		    }
		    if (destination->a != 1) {
			fprintf(stderr,"multiple destinations not allowed (yet).\n");
			fprintf(stderr,"single destination used, rest discarded.\n");
		    }
		    ind = add_entry(DEF,mod);
		    /* fill ae_term, in our case an arity 0 process */
		    mod->def[ind].ae_t.t = TERM;
		    mod->def[ind].ae_t.ind.table = source->table;
		    mod->def[ind].ae_t.ind.key = source->key;
		    mod->def[ind].ae_t.a = 0;
		    mod->def[ind].ae_t.ae_list = NULL;

		    /* fill process expression */

		    mod->def[ind].p_expr.fun = SEQ;
		    mod->def[ind].p_expr.proc_expr.pe3.a = 2;
		    mod->def[ind].p_expr.proc_expr.pe3.pe = PSF_NMALLOC(PROCESS_EXPR,2);
		    if (trigger->table == CONSTANT) {
			switch (trigger->key) {
			case 0:
			    mod->def[ind].p_expr.proc_expr.pe3.pe[0].fun = SKP;
			    break;
			case 1:
			    mod->def[ind].p_expr.proc_expr.pe3.pe[0].fun = SKP;
			    break;
			case 2:
			    fprintf(stderr,"tildef: not yet allowed trigger constant.\n");
			    exit(EXIT_HELP);
			}
		    } else {
			mod->def[ind].p_expr.proc_expr.pe3.pe[0].fun = AET;
			mod->def[ind].p_expr.proc_expr.pe3.pe[0].proc_expr.pe2.t = TERM;
			mod->def[ind].p_expr.proc_expr.pe3.pe[0].proc_expr.pe2.a = 0;
			mod->def[ind].p_expr.proc_expr.pe3.pe[0].proc_expr.pe2.ind.table = trigger->table;
			mod->def[ind].p_expr.proc_expr.pe3.pe[0].proc_expr.pe2.ind.key = trigger->key;
			mod->def[ind].p_expr.proc_expr.pe3.pe[0].proc_expr.pe2.ae_list = NULL;
		    }
		    mod->def[ind].p_expr.proc_expr.pe3.pe[1].fun = AET;
		    mod->def[ind].p_expr.proc_expr.pe3.pe[1].proc_expr.pe2.t = TERM;
		    mod->def[ind].p_expr.proc_expr.pe3.pe[1].proc_expr.pe2.a = 0;
		    mod->def[ind].p_expr.proc_expr.pe3.pe[1].proc_expr.pe2.ind.table = destination->indlist[0].table;
		    mod->def[ind].p_expr.proc_expr.pe3.pe[1].proc_expr.pe2.ind.key = destination->indlist[0].key;
		    mod->def[ind].p_expr.proc_expr.pe3.pe[1].proc_expr.pe2.ae_list = NULL;

		    /* fill freeformat */
		    sprintf(s,"<o>%d",org);
		    mod->def[ind].ff = strfit(s);

		    /* free used indextype and indexlist */
		    PSF_FREE(trigger);
		    PSF_FREE(destination->indlist);
		    PSF_FREE(destination);
		}
		/* free used indextype */
		PSF_FREE(source);
	    }
	}
    }
    PSF_FREE(s);
}
