.TH "til.bnf" 5 "Sep 13, 1994" "PSF-Toolkit"
.SH NAME
til.bnf \- Backus Naur Form description of TIL
.SH DESCRIPTION
This manual page contains a description of the syntax of TIL (the Tool
Interface Language of the PSF-Toolkit) in Backus Naur Form.
.SH "BNF grammar of TIL"
Notation:
.B {
.I item sep
.B }+
means one or more occurrences of
.IR item ,
seperated by
.IR sep .
.in
.sp
.RS -5m
.nf
.\" <communication_index> is the longest non-terminal in troff;
.\" in nroff, <administration_index> is longer
.if t .nr o \w'communication_index'
.if n .nr o \w'administration_index'
.ta \nou+1n +1cm +1cm +2cm

specification	::=	entry* 

entry	::=	administration_entry |
		sort_entry |
		function_entry |
		atom_entry |
		process_dec_entry |
		set_entry |
		communication_entry |
		variable_entry |
		equation_entry |
		definition_entry 

administration_entry	::=	administration_index free_format

sort_entry	::=	sort_index free_format

function_entry	::=	function_index natural sort_index*
			natural sort_index free_format

atom_entry	::=	 atom_index natural
			sort_index* free_format 

process_dec_entry	::=	process_index natural
			sort_index* free_format

set_entry	::=	set_index sort_index
			set_expr free_format

communication_entry	::=	communication_index atom_term
			atom_term atom_term free_format

variable_entry	::=	variable_index variable_type
			free_format

equation_entry	::=	equation_index equation_expr
			free_format

definition_entry	::=	definition_index definition_expr
			free_format



administration_index	::=	'[' '0' '.' natural ']'

sort_index	::=	'[' '1' '.' natural ']'

function_index	::=	'[' '2' '.' natural ']'

atom_index	::=	'[' '3' '.' natural ']'

process_index	::=	'[' '4' '.' natural ']'

set_index	::=	'[' '5' '.' natural ']'

communication_index	::=	'[' '6' '.' natural ']'

variable_index	::=	'[' '7' '.' natural ']'

equation_index	::=	'[' '8' '.' natural ']'

definition_index	::=	'[' '9' '.' natural ']'

variable_type	::=	sort_index |
			set_index

atom_term	::=	atom_index [ '(' term + ')' ]


equation_expr	::=	equation [ '<=' natural {equation ','}+ ]

set_expr	::=	set_index |
		'<' '::=' ',' natural '>' '(' enumeration_item+ ')' |
		'<' '+' ',' natural '>' '(' set_expr+ ')' |
		'<' '.' ',' natural '>' '(' set_expr+ ')' |
		'<' '\e' ',' natural '>' '(' set_expr+ ')'

definition_expr	::=	process_head '=' process_expr

equation	::=	term '=' term 

enumeration_item	::=	term | atom_term

atom_term	::=	atom_index [ '(' term+ ')'

process_head	::=	process_index [ '(' term+ ')' ]

process_expr	::=	process_head |
		atom_term |
		'<' 'skip' '>' |
		'<' 'delta' '>' |
		'<' 'encaps' '>' '(' set_index process_expr ')' |
		'<' 'hide' '>' '(' set_index process_expr ')' |
		'<' 'sum' '>' '(' variable_index process_expr ')' |
		'<' 'merge' '>' '(' variable_index process_expr ')' |
		'<' 'alt' ',' natural '>' '(' process_expr+ ')' |
		'<' 'seq' ',' natural '>' '(' process_expr+ ')' |
		'<' 'par' ',' natural '>' '(' process_expr+ ')' |
		'<' 'if' '>' '(' term case_pair ')' |
		'<' 'case' ',' natural '>' '(' term case_pair+ ')' |
		'<' 'interrupt' ',' '2' '>' '(' process_pair) ')' |
		'<' 'disrupt' ',' '2' '>' '(' process_pair) ')' |
		'<' 'star' ',' '2' '>' '(' process_pair) ')' |
		'<' 'sharp' ',' '2' '>' '(' process_pair) ')' |
		'<' 'prio' '>' '(' natural set_expr+ process_expr ')'


case_pair	::=	term process_expr

process_pair	::=	process_expr process_expr


term	::=	variable_index |
		function_index [ '(' term+ ')' ]


free_format	::=	'{' (tag info)* '}'
 
tag	::=	'<' [ tag_ident ] '>' |
		'<' [ tag_ident ] | 
		empty
.\" the "empty" option introduces an ambiguity in the grammar.
.\" the definition of tag is so complicated because the original free format
.\" definition allowed freeformats to conatain all characters except '}'.
.\" this new definition describes the same language, but also allows parsing
.\" of tag/info combinations.

tag_ident	::=	-['<','>','}']
info	::=	-['<','}']
empty	::=
.\" if '}' is allowed as a valid tag character, it is not possible to
.\" read free formats which have a single < in their body.
.\" as it happens '}' was not a valid freeformat character originally,
.\" so this restriction should not cause problems.

.SS Comments:
Comments begin with two hyphens
.RB ( -- ),
and end with another
.B --
or at the end of the line.
Comments are only allowed outside a freeformat, because in a freeformat
.B --
is a valid symbol.
