.TH "PSF-Toolkit" 5  "23 Aug 1993" "PSF-Toolkit"
.SH NAME
psftoolkit \- introduction to the PSF-Toolkit
.SH SYNOPSIS
This section describes the tools that make up the PSF-Toolkit.
.SH DESCRIPTION
The PSF-Toolkit is a collection of tools for manipulating process and data
descriptions written in PSF (the Process Specification Formalism) or a similar
language.  The unifying element is the use of TIL, the Tool Interface Language.
.PP
The tools in the PSF-Toolkit can be categorized as follows:
.TP
PSF, the Process Specification Language
A program simply called
.B psf
translates specifications in the PSF language to TIL code.  It proceeds in
three passes.  The first pass translates PSF to an intermediate language
called MTIL.  The second pass translates MTIL to another intermediate
language called ITIL.  The final pass then translates ITIL to TIL.  The
three passes can be invoked separately, as
.BR psf_mtil ,
.B mtil_itil
and
.BR itil_til .
There is an inverse for the first step:
.B mtil_psf
translates MTIL code back to PSF.  ITIL and TIL cannot be faithfully
translated back, because the module structure is lost in the step from
MTIL to ITIL.  Nevertheless,
.B til_psf
provides an embedding from TIL to PSF.
.TP
LTS, Labelled Transition Systems.
Some of the tools can only deal with dataless Labelled Transition Systems.
So we defined LTS as the sublanguage of TIL consisting of descriptions of
dataless labelled transition systems only.  A tool called
.B trans
can unfold dataless regular process descriptions in TIL code to LTS code.
It also provides a possibility to single-step such processes interactively.
.TP
FC, the Common Format of the CONCUR2 project.
The PSF-Toolkit contains a program called
.B fc_lts
that translates the FC formalism to LTS code, and a program called
.B lts_fc
that translates LTS code back to FC.
.TP
MCRL, muCRL
CRL is the Common Representation Language of the
.B SPECS
project.  MuCRL is the core sublanguage of CRL.  The PSF-Toolkit
contains a program called
.B mcrl_til
that translates specifications in MCRL to TIL code.
.TP
TIL, the Tool Interface Language
A program called
.B til_til
translates TIL code to TIL code.  That is, it has no effect on legal TIL
code.  It can be used as a syntax checker on TIL code.  More importantly,
its source code provides a skeleton for writing non-trivial transformations
from TIL to TIL.
.TP
simulator
A program called
.B sim
can single-step or trace a process described in TIL.  The
.B sim
tool works best when the description is in a rather restricted subset of
TIL, but a separate tool called
.B simpp
.RI ( p re p rocessor
for the
.IR sim ulator)
can transform a much larger subset into the subset accepted by
.BR sim .
The
.B sim
tool can output a trace of the process being traced, in a TIL-like format.
The
.B ttrace
program translates the format to a more PSF-like form.  For a more creative
way to interpret traces, look at the scripts in the doc/animation subdirectory.
Currently,
.B sim
only works under the X Window System.
.TP
bisimulation equivalence
The
.B equiv
tool tests whether two processes described in LTS code are bisimular and,
if not, give a formula in HML-U (Hennessy-Milner Logic with Until operator)
distinguishing the two.  At least, that's what it should do; it has not been
tested very thoroughly and might not work in all cases.
.TP
initial algebra
The
.B initial
tool attempts to compute the initial algebra of a term rewrite system
described in TIL code.
.TP
term rewriting
The
.B
trs
tool normalizes terms in a term rewrite system described in TIL code.
.TP
checking TRSs
The
.B trs_check
tool checks term rewrite systems described in TIL code and warns about some
constructs that the
.B initial
and
.B trs
tools cannot deal with.
.TP pretty printing
The
.B ppp
tool
is a PSF formatter.  It reformats PSF code in one of the more popular styles.
.SH MORE INFORMATION
For sample sessions using the PSF-Toolkit, see the files in the doc/demos
directory.  Example specifications can be found in the subdirectories of the
doc/examples directory.  A description of PSF in Backus Naur Form can be
found in
.BR psf.bnf (5)
and a BNF description of TIL is available in
.BR til.bnf (5).
A proposal for a stadard layout for PSF specifications can be found in
.BR psf.style (5).
.SH SEE ALSO
.BR fc_lts (1L),
.BR initial (1L),
.BR lts_fc (1L),
.BR mtil_psf (1L),
.BR psf (1L),
.BR psf_mtil (1L),
.BR sim (1L),
.BR simpp (1L),
.BR til_psf (1L),
.BR trans (1L),
.BR trs (1L),
.BR trs_check (1L),
.BR psf.bnf (5),
.BR til.bnf (5)
.BR psf.style (5),
.BR trace_format (5).
.SH BUGS
Questions and bug-reports can be sent by e-mail to psfbugs@win.tue.nl .
