.TH "PSF Style" 5 "June 7, 1993" "PSF-Toolkit"
.SH NAME 
psf.style \- suggested layout for PSF specifications
.SH DESCRIPTION
.PP
This manual section contains an suggest a layout ofr PSF specifications
This is menat as a first proposal for the lay-out of PSF output 
to be generated by certain tools, for example the psf pretty printer
.BR ppp (1L).
.SH Layout
For readability it is convenient to have line lengths less then 80 characters.
Since indentation using tabs will quite soon result in longer lines we
restrict indentation to a size of 2. We do not alter the tab size but
use two spaces.
.PP
Also for readability the following symbols will be aligned underneath
each other: '=', ':', '->' and '[xx]'.
.PP
Before each keyword except begin and end we leave an empty line and
an exception is made for keywords preceded by a begin.
And after each keyword including begin and end we indent 2 spaces.
The begin,end couple which describe the module boundaries,
are not indented.
In the following examples the underscore means a single space.
.PP
.nf

keyword
__block
__block

nextkeyword
__block
__block

anotherkeyword
__begin
____block
____block
__end

data module a-module
begin
--imports

.fi 


.SH "-- and PSF" 
A pecularity of PSF is the meaning of --. It is only a comment starting symbol if preceded by space. Some examples are: 
.nf
x--y	the identifier "x--y"
x --y	an x followed by a comment opening -- and a comment y
x-- y	an x followed by an operator -- followed by y 
------	comment starting -- comment closing -- operator symbol --
.fi


.SH SKELETON
The order in which the different parts of a module appear is relevant
to the compiler. Objects between <,> denote symbols from the bnf,
which is accessible by \fBman psf.bnf\fR.
Several basic skeletons can be generated by the program: '*******'dm

.nf

data module <ident>
begin
  parameters
    <ident>
      begin
        sorts
	  S
        functions
	  F: S -> S
      end <ident>  

  exports
    begin
      sorts
      functions
    end

  imports
    <ident> { renamed by [ren.]
              <ident> bound by [ren.] to <ident> },
    <ident> { <ident> bound by [ren.] to ident
              renamed by [ren.] } 

  sorts
    <ident>, <ident>

  functions
    <ident>        : <input-type>                -> <sort-ident>
    <operator> _   : <sort-ident>                -> <sort-ident>
    _ <operator> _ : <sort-ident> # <sort-ident> -> <sort-ident>

  variables
    <ident> : -> <sort-ident> 

  equations
    [<ident>] equation
end <ident>
.fi
.nf
process module <ident>
begin
  parameters

  exports
    begin
    end

  imports
    ........
 
  atoms
    x a, b, c, d : <type>	--x is not parametrized with type.
				--Such notation is considered bad style.
			 	--Write such a line as follows:
    x
    a, b, c, d : <type>
    y z				-- is allowed since they have the same type 

  processes
    xx aa, bb, cc, dd : <type>	--xx is not parametrized with type. 
				--See the remark at atoms,
				--and write:
    xx
    aa, bb, cc, dd : <type> 
    yy zz

  sets
    of S
      <ident> = <set-exp>
    of T
      <ident> = <set-exp>
    of atoms
      <ident> = <set-exp>
 			--If only one set type is needed and defined then
			--it is allowed to write:
  sets of S 
    <ident> = <set-expr>
    <ident> = <set-expr>

  communications
    a | b = c
    a(t) | b(t) = c(t) for t in S 
  
  variables
    a : -> <sort-ident>

  definitions
    <ident>( <term-list> ) = <process>
end <ident>
.fi

.SH FILES

.SH SEE ALSO
psf(1L), style(5), psf.bnf(5)
