.TH "psf.bnf" 5 "May 27, 1994" "PSF-Toolkit"
.SH NAME psf.bnf \- Backus Naur Form description of PSF
.SH DESCRIPTION
This manual page contains a description of the syntax of PSF (the Process
Specification Formalism) in Backus Naur Form.
.\"
.\" We apologize for the occurrance of lines longer than 80 character in this
.\" file.  It is meant to be formattable by both troff's .ta directive and
.\" our won man_bnf script, and we were too lazy to develop a continuation
.\" convention compabible with both.  We apologize for the inconvenience.
.\"
.\" Note: line beginning with .\"BNF are used by the man_bnf script
.\"
.SH "BNF grammar of PSF"
.in 2c
Notation:
.B {
.I item sep
.B }+
means one or more occurrences of
.IR item ,
separated by
.IR sep .
.in
.sp
.RS -5m
.nf
.ta  5cm +1cm +1cm +1cm +1cm +1cm +1cm +1cm +1cm +1cm
.\"BNF grammar begin
<specification>	::=	<module>+

<module>	::=	<data-module> | <process-module>

<data-module>	::=	"\fBdata\fP" "\fBmodule\fP" <module-ident>
		"\fBbegin\fP"
			[ <d-parameters> ]
			[ <d-exports> ]
			[ <imports> ]
			[ <sorts> ]
			[ <functions> ]
			[ <d-variables> ]
			[ <equations> ]
		"\fBend\fP" <module-ident>

<d-parameters>	::=	"\fBparameters\fP" { <d-parameter> "\fB,\fP" }+

<d-parameter>	::=	<parameter-ident>
		"\fBbegin\fP"
			[ <sorts> ]
			[ <functions> ]
		"\fBend\fP" <parameter-ident>

<d-exports>	::=	"\fBexports\fP"
		"\fBbegin\fP"
			[ <sorts> ]
			[ <functions> ]
		"\fBend\fP"

<imports>	::=	"\fBimports\fP"
			{ <module-expression> "\fB,\fP" }+

<module-expression>	::=	<module-ident>
			[ "\fB{\fP" <modifier> "\fB}\fP" ]

<modifier>	::=	<renamed> [ <bindings> ] |
		<bindings> [ <renamed> ]

<renamed>	::=	"\fBrenamed\fP" "\fBby\fP" <renamings>

<renamings>	::=	"\fB[\fP" { <renaming> "\fB,\fP" }+ "\fB]\fP"

<renaming>	::=	<ident-or-operator> "\fB->\fP" <ident-or-operator>

<ident-or-operator>	::=	<ident> |
		"\fB_\fP" <operator> "\fB_\fP" |
		<operator> "\fB_\fP"

<bindings>	::=	( <parameter-ident>
			"\fBbound\fP" [ "\fBby\fP" <renamings> ]
				"\fBto\fP" <module-ident> )+

<sorts>	::=	"\fBsorts\fP" { <sort-ident> "\fB,\fP" }+

<functions>	::=	"\fBfunctions\fP" <function>+

<function>	::=	<fun-ident> "\fB:\fP" [ <input-type> ] "\fB->\fP" <sort-ident> |
		<operator> "\fB_\fP" "\fB:\fP" <sort-ident> "\fB->\fP" <sort-ident> |
		"\fB_\fP" <operator> "\fB_\fP" "\fB:\fP"
			<sort-ident> "\fB#\fP" <sort-ident> "\fB->\fP" <sort-ident>

<input-type>	::=	{ <sort-ident> "\fB#\fP" }+

<d-variables>	::=	"\fBvariables\fP" <d-variable-list>

<d-variable-list>	::=	( <var-ident-list> "\fB:\fP" "\fB->\fP" <sort-ident> )+

<var-ident-list>	::=	{ <var-ident> "\fB,\fP" }+

<equations>	::=	"\fBequations\fP" <cond-equation>+

<cond-equation>	::=	<tag> <equation> |
		<tag> <equation-list> <implies> <equation> |
		<tag> <equation> "\fBwhen\fP" <equation-list>

<tag>	::=	"\fB[\fP" <tag-ident> "\fB]\fP"

<equation-list>	::=	{ <equation> "\fB,\fP" }+

<equation>	::=	<term> "\fB=\fP" <term>

<term>	::=	<term-primary> |
		<term> <operator> <term-primary>

<term-primary>	::=	<fun-ident> [ "\fB(\fP" <term-list> "\fB)\fP" ] |
		<var-ident> |
		"\fB(\fP" <term> "\fB)\fP" |
		<operator> <term-primary>

<term-list>	::=	{ <term> "\fB,\fP" }+

<process-module>	::=	"\fBprocess\fP" "\fBmodule\fP" <module-ident>
		"\fBbegin\fP"
			[ <p-parameters> ]
			[ <p-exports> ]
			[ <imports> ]
			[ <atoms> ]
			[ <processes> ]
			[ <sets> ]
			[ <communications> ]
			[ <p-variables> ]
			[ <definitions> ]
		"\fBend\fP" <module-ident>

<p-parameters>	::=	"\fBparameters\fP" { <p-parameter> "\fB,\fP" }+

<p-parameter>	::=	<parameter-ident>
		"\fBbegin\fP"
			[ <sorts> ]
			[ <functions> ]
			[ <atoms> ]
			[ <processes> ]
			[ <sets-param> ]
		"\fBend\fP" <parameter-ident>

<p-exports>	::=	"\fBexports\fP"
		"\fBbegin\fP"
			[ <atoms> ]
			[ <processes> ]
			[ <sets> ]
		"\fBend\fP"

<atoms>	::=	"\fBatoms\fP" <atom-decl-list>+

<atom-decl-list>	::=	{ <atom-ident> "\fB,\fP" }+ [ "\fB:\fP" <input-type> ]

<processes>	::=	"\fBprocesses\fP" <process-decl-list>+

<process-decl-list>	::=	{ <process-ident> "\fB,\fP" }+ [ "\fB:\fP" <input-type> ]

<sets-param>	::=	"\fBsets\fP" ( <of-sort-or-atoms> <set-ident>+ )+

<sets>	::=	"\fBsets\fP" ( <of-sort-or-atoms> <set-decl>+ )+

<of-sort-or-atoms>	::=	"\fBof\fP" <sort-ident> | "\fBof\fP" "\fBatoms\fP"

<set-decl>	::=	<set-ident> "\fB=\fP" <set-exp>

<set-exp>	::=	<set-tertiary> |
		<set-exp> "\fB+\fP" <set-tertiary>

<set-tertiary>	::=	<set-secondary> |
		<set-primary> "\fB\\\fP" <set-secondary>

<set-secondary>	::=	<set-primary> |
		<set-secondary> "\fB.\fP" <set-primary>

<set-primary>	::=	<sort-or-set-ident> |
		"\fB(\fP" <set-exp> "\fB)\fP" |
		"\fB{\fP" [ <term-list> [ "\fB|\fP" <placeholders> ] ] "\fB}\fP"

<sort-or-set-ident>	::=	<sort-ident> | <set-ident>

<placeholders>	::=	{ <placeholder> "\fB,\fP" }+

<placeholder>	::=	<var-ident> "\fBin\fP" <sort-or-set-ident>

<p-variables>	::=	"\fBvariables\fP" <p-variable-list>

<p-variable-list>	::=	( <var-ident-list> "\fB:\fP"
			"\fB->\fP" <sort-or-set-ident> )+

<communications>	::=	"\fBcommunications\fP" <communication>+

<communication>	::=	<atom> "\fB|\fP" <atom> "\fB=\fP" <atom>
			[ "\fBfor\fP" <placeholders> ]

<atom> 	::=	<atom-ident> [ "\fB(\fP" <term-list> "\fB)\fP" ]

<chain>	::=	<set-ident> | <chain> "\fB>\fP" <set-ident>

<definitions>	::=	"\fBdefinitions\fP" <definition>+

<definition>	::=	<simple-process> "\fB=\fP" <process>

<simple-process>	::=	<process-ident> [ "\fB(\fP" <term-list> "\fB)\fP" ]

<process>	::=	<process-tertiary> |
		<process> "\fB+\fP" <process-tertiary>

<process-tertiary>	::=	<process-secondary> |
		<process-tertiary> "\fB||\fP" <process-secondary> |
		<process-tertiary> "\fB*\fP" <process-secondary> |
		<process-tertiary> "\fB#\fP" <process-secondary>

<process-secondary> 	::=	<process-primary> |
		<process-secondary> "\fB.\fP" <process-primary>

<process-primary>	::=	"\fBskip\fP" |
		"\fBdelta\fP" |
		<atom> |
		<simple-process> |
		"\fB(\fP" <process> "\fB)\fP" |
		"\fBsum\fP" "\fB(\fP" <placeholder> "\fB,\fP" <process> "\fB)\fP" |
		"\fBmerge\fP" "\fB(\fP" <placeholder> "\fB,\fP" <process> "\fB)\fP" |
		"\fBhide\fP" "\fB(\fP" <set-ident> "\fB,\fP" <process> "\fB)\fP" |
		"\fBencaps\fP" "\fB(\fP" <set-ident> "\fB,\fP" <process> "\fB)\fP" |
		"\fB[\fP" <equation> "\fB]\fP" "\fB->\fP" <process-primary> |
		"\fBinterrupt\fP" "\fB(\fP" <process> "\fB,\fP" <process> "\fB)\fP" |
		"\fBdisrupt\fP" "\fB(\fP" <process> "\fB,\fP" <process> "\fB)\fP" |
		"\fBprio\fP" "\fB(\fP" <chain> "\fB,\fP" <process> "\fB)\fP"

<module-ident> 	::=	<ident>
<parameter-ident>	::=	<ident>
<sort-ident>	::=	<ident>
<fun-ident> 	::=	<ident>
<var-ident> 	::=	<ident>
<tag-ident> 	::=	<ident>
<atom-ident>	::=	<ident>
<process-ident>	::=	<ident>
<set-ident> 	::=	<ident>
.\"BNF grammar end
.SH "Symbols and keywords"
.\"BNF lexicals begin
.SS Layout characters:
.nf
space
horizontal tabulation
carriage return
line feed
form feed
.fi
.SS Comments:
Comments begin with two hyphens, and end with either an end of line or another
pair of hyphens.  The character immediately preceding a comment (if any) must
be a layout character.  If such a layout character is omitted the double-hyphen
is interpreted as (part of) an operator or part of an identifier.
.SS Identifiers:
.\"BNF insert <ident>
Identifiers consist of a non-empty sequence of letters, digits or single-quote
characters, possibly with embedded hyphens.  However, the keywords listed below
are reserved, and cannot be used as identifiers.
.nf
\(bu examples: i, me, type-writer, prime', 'quotation', double--hyphen
\(bu non-examples: -x, -, x-
.fi
.SS Operators:
.\"BNF insert <operator>
Operators consist of a nonempty sequence of operator symbols or an
identifier surrounded by periods.  Operator symbols are
.B "! @ $ % ^ & + - * ; ? ~ / |" \\\\
.nf
\(bu examples: &&, -?-, .push., %^@$, .'id., .greater-than.
\(bu non-examples: >=, push, .@., @a
.fi
.SS Implication symbol:
.\"BNF insert <implies>
An implication symbol consists of two or more equal signs
.RB ( = ),
optionally followed by a greater-than sign
.RB ( > ).
.nf
\(bu examples: ==, ==>, ==================
.fi
.ne 14
.SS Reserved keywords:
The following words are keywords and can therefore not be used as identifiers:
.\"BNF lexicals end
.ta 4cm +4cm
.nf
.\"BNF keywords begin
atoms	begin	bound
by	communications	data
definitions	delta	disrupt
encaps	end	equations
exports	for	functions
hide	imports	in
interrupt	merge	module
of	parameters	prio
process	processes	renamed
sets	skip	sorts
sum	to	variables
when
.\"BNF keywords end
.fi
.SH HISTORY
.\"BNF history begin
Prior to version 1.2, "interrupt", "disrupt" and "prio" were not keywords,
and the alternatives of <primary-process> using them did not exist.
The "*" and "#" operators did not exist either.
.\" There was a mistake in the rule for <process-secondary>:
.\" instead of <process-tertiary> it used <process-primary> (three times)
.LP
Prior to version 1.1, the "[" <equation> "]" alternative of <primary-process>
did not exist.
.\"BNF history end
.SH SEE ALSO
.BR psf (1L),
.BR psf.style (5).
