# setup windows
set SIZEX 905
set SIZEY 298
set ORIGx 18
set ORIGy 66
Anim::Windows 925 370 -text 61 10

# init graphics

set STATspace 80
set STATsspace 54
set STATsw 16
set STATmw 20
set STATlw 50
set STATsh 16
set STATmh 20
set STATlh 50

# prints
set printw 10

# belts
set beltw [expr $printw * 2 + 1]
set beltBx1 [expr $ORIGx+110]
set beltBx2 [expr $beltBx1+3*$STATspace+8*$STATsspace+4*$STATmw+8]
set beltBy [expr $ORIGy+140]
Anim::CreateLine BB pos $beltBx1 $beltBy pos $beltBx2 $beltBy -width $beltw
set beltAx1 [expr $ORIGx+40 - $printw]
set beltAx2 [expr $beltBx1+3*$STATspace+8*$STATsspace+4*$STATmw+8]
set beltAy [expr $ORIGy+200]
Anim::CreateLine BA pos $beltAx1 $beltAy pos $beltAx2 $beltAy -width $beltw
set beltCx1 [expr $beltBx1+2*$STATspace]
set beltCx2 [expr $beltCx1+4*$STATsspace+2*$STATsw]
set beltCy [expr $ORIGy+260]
Anim::CreateLine BC pos $beltCx1 $beltCy pos $beltCx2 $beltCy -width $beltw
set beltDx [expr $beltBx1+0.5*($beltBx2-$beltBx1)]
set beltDy1 [expr $beltBy-$STATsspace]
set beltDy2 $beltBy
Anim::CreateLine BD pos $beltDx $beltDy1 pos $beltDx $beltDy2 -width $beltw

# stations
Anim::CreateItem TPC1 rect [expr $ORIGx+40] [expr $ORIGy+100] $STATsw $STATlh \
    "T\nP\nC\n \nA\n "
Anim::CreateItem TPC2 rect [expr [Anim::Dim TPC1 e,x]+$STATsw+4] \
    [Anim::Dim TPC1 y] [Anim::Dim TPC1 wid] [Anim::Dim TPC1 ht] \
    "T\nP\nC\n \nB\nC"
Anim::CreateItem SSB rect [expr $beltBx1+$STATsw] \
    [expr $beltBy+0.5*($beltAy-$beltBy)] $STATsw $STATlh "S\nS\nB"
Anim::CreateItem SCP rect [expr [Anim::Dim SSB x]+$STATspace] $beltAy $STATmw \
    $STATmh "SCP"
Anim::CreateItem MC1 rect [expr [Anim::Dim SSB x]+2*$STATspace] \
    [expr $beltAy+0.5*($beltCy-$beltAy)] $STATsw $STATlh "M\nC\n1"
Anim::CreateItem CP1 rect [expr [Anim::Dim MC1 x]+$STATsspace] $beltCy \
    $STATmw $STATmh "CP1"
Anim::CreateItem MC2 rect [expr [Anim::Dim MC1 x]+2*$STATsspace] \
    [expr $beltAy+0.5*($beltCy-$beltAy)] $STATsw $STATlh "M\nC\n2"
Anim::CreateItem CP2 rect [expr [Anim::Dim MC2 x]+$STATsspace] $beltCy \
    $STATmw $STATmh "CP2"
Anim::CreateItem BMR rect [expr [Anim::Dim MC2 x]+2*$STATsspace] \
    [expr $beltAy+0.5*($beltCy-$beltAy)] $STATsw $STATlh "B\nM\nR"
Anim::CreateItem RCL rect [expr [Anim::Dim BMR x]+$STATspace] $beltAy \
    $STATmw $STATmh "RCL"
Anim::CreateItem IPSA rect [expr [Anim::Dim RCL x]+$STATsspace] $beltCy \
    $STATmw $STATmh "IPS\nA"
Anim::InitVar nrA 0
Anim::CreateItem IPSB rect [expr [Anim::Dim IPSA x]+2*[Anim::Dim IPSA wid]+4] \
    $beltCy $STATmw $STATmh "IPS\nB"
Anim::InitVar nrB 0
Anim::CreateItem IPSC rect [expr [Anim::Dim IPSB x]+2*[Anim::Dim IPSB wid]+4] \
    $beltCy $STATmw $STATmh "IPS\nC"
Anim::InitVar nrC 0
Anim::CreateItem BMW rect [expr [Anim::Dim IPSC x]+$STATsspace] \
    [expr $beltBy+0.5*($beltAy-$beltBy)] $STATsw $STATlh "B\nM\nW"
Anim::CreateItem IET rect [expr [Anim::Dim BMW x]+$STATsspace] $beltAy \
    $STATmw $STATmh "IET"
Anim::CreateItem BTR rect [expr [Anim::Dim IET x]+$STATsspace] \
    [expr $beltBy+0.5*($beltAy-$beltBy)] $STATsw $STATlh "B\nT\nR"
Anim::CreateItem BRE rect [expr $beltDx+$STATlh-20] $beltDy2 $STATlh $STATsw \
    "BRE"
Anim::CreateItem WAR rect [expr $beltDx-$STATlh] [expr $beltDy1-$STATmh] \
    [expr $STATlh+20] $STATmh "WAR"
# TPC belts
Anim::CreateLine BTPC1 item TPC1 s pos [expr $beltAx1+$printw] $beltAy -width $beltw
Anim::CreateLine BTPC2 item TPC2 s pos [Anim::Dim TPC2 x] $beltAy -width $beltw
# IPS belts
Anim::CreateLine BIPSA pos [Anim::Dim IPSA x] $beltAy item IPSA n -width $beltw
Anim::CreateLine BIPSB pos [Anim::Dim IPSB x] $beltAy item IPSB n -width $beltw
Anim::CreateLine BIPSC pos [Anim::Dim IPSC x] $beltAy item IPSC n -width $beltw
# BRE belt
Anim::CreateLine BBRE pos [expr $beltBx1+0.5*($beltBx2-$beltBx1)] \
    [expr [Anim::Dim BRE y]-[Anim::Dim BRE ht]] \
    pos [expr $beltBx1+0.5*($beltBx2-$beltBx1)] \
    [expr [Anim::Dim WAR y]+[Anim::Dim WAR ht]] -width $beltw

# start point A
set STARTAx [Anim::Dim TPC1 x]
set STARTBCx [Anim::Dim TPC2 x]
set STARTy [Anim::Dim TPC1 s,y]

# scheduler
Anim::CreateItem SC rect [expr $ORIGx+37] [expr $ORIGy-45] $STATlw $STATsh \
    "Scheduler"
Anim::Textpos SCorder [Anim::Dim SC e,x] [Anim::Dim SC n,y] ne
Anim::InitVar permit 0
Anim::InitVar count 0
Anim::CreateLine SCTPC pos [expr [Anim::Dim SC x]+20] [Anim::Dim SC s,y] \
    pos [expr [Anim::Dim SC x]+20] [expr [Anim::Dim SC s,y]+60] -width 1
Anim::TextposLine SCTPC SCTPC w -d 0.5
#Anim::CreateLine SCTPCO pos [Anim::Dim TPC1 x] [Anim::Dim TPC1 n,y] \
#    pos [Anim::Dim TPC1 x] [expr [Anim::Dim SC s,y]+60] \
#    pos [Anim::Dim TPC2 x] [expr [Anim::Dim SC s,y]+60] \
#    pos [Anim::Dim TPC2 x] [Anim::Dim TPC2 n,y] -arrow both -width 1
Anim::CreateLine SCTPCA pos [Anim::DimL SCTPC end,x] [Anim::DimL SCTPC end,y] \
    pos [Anim::Dim TPC1 x] [expr [Anim::Dim SC s,y]+60] \
    pos [Anim::Dim TPC1 x] [Anim::Dim TPC1 n,y] \
    -arrow last -width 1
Anim::CreateLine SCTPCBC pos [Anim::DimL SCTPC end,x] [Anim::DimL SCTPC end,y] \
    pos [Anim::Dim TPC2 x] [expr [Anim::Dim SC s,y]+60] \
    pos [Anim::Dim TPC2 x] [Anim::Dim TPC2 n,y] \
    -arrow last -width 1
Anim::CreateLine SCIPS pos [expr [Anim::Dim SC x]-20] [Anim::Dim SC s,y] \
    pos [expr [Anim::Dim SC x]-20] [expr [Anim::Dim IPSA s,y]+15] \
    pos [expr [Anim::Dim IPSC x]+1] [expr [Anim::Dim IPSC s,y]+15] -width 1
Anim::CreateLine SCIPSA pos [Anim::Dim IPSA x] [expr [Anim::Dim IPSA s,y]+15] \
    item IPSA s -width 1 -arrow last
Anim::CreateLine SCIPSB pos [Anim::Dim IPSB x] [expr [Anim::Dim IPSB s,y]+15] \
    item IPSB s -width 1 -arrow last
Anim::CreateLine SCIPSC pos [Anim::Dim IPSC x] [expr [Anim::Dim IPSC s,y]+15] \
    item IPSC s -width 1 -arrow last
Anim::TextposLine SCIPS SCIPS e -d 0.1

Anim::CreateQueue OQ [expr [Anim::Dim SC x] + 2*$STATsspace] [Anim::Dim SC y] \
    20 1 -anchor w
Anim::CreateLine OQSC pos [Anim::DimQ OQ w,x] [Anim::DimQ OQ y] item SC e \
    -width 1 -arrow last
Anim::TextposLine OQSC OQSC n

Anim::CreateQueue SQ [expr [Anim::Dim WAR w,x] - $STATspace+5] \
    [expr [Anim::Dim WAR y] + 15] 2 7 -anchor se -orient vertical
Anim::CreateLine WARSQ item WAR w pos [Anim::DimQ SQ e,x] [Anim::Dim WAR y] \
    -width 1 -arrow last
Anim::TextposLine WARSQ WARSQ n

Anim::CreateItem VAL rect [expr [Anim::DimQ SQ x] + 2*$STATspace] \
    [expr [Anim::Dim SC y] + $STATmh-6] $STATlw [expr $STATmh+10] "Validation"
Anim::CreateLine VALOQ pos [Anim::Dim VAL w,x] [Anim::DimQ OQ y] \
    pos [Anim::DimQ OQ e,x] [Anim::DimQ OQ y] -width 1 -arrow last
Anim::TextposLine VALOQ VALOQ n
Anim::CreateLine SQVAL pos [Anim::DimQ SQ e,x] [Anim::DimQ SQ n,y] \
    pos [Anim::Dim VAL w,x] [Anim::DimQ SQ n,y] -width 1 -arrow last
Anim::TextposLine SQVAL SQVAL n
Anim::CreateLine VALin pos [expr [Anim::Dim VAL e,x] + 100] \
    [Anim::DimQ OQ y] pos [Anim::Dim VAL e,x] [Anim::DimQ OQ y] \
    -width 1 -arrow last
Anim::TextposLine VALin VALin n
Anim::CreateLine VALout pos [Anim::Dim VAL e,x] [Anim::DimQ SQ n,y] \
    pos [expr  [Anim::Dim VAL e,x] + 100] [Anim::DimQ SQ n,y] \
    -width 1 -arrow last
Anim::TextposLine VALout VALout n

#info

Anim::CreateBox info factory -side left -fill both -bw 0 -relief flat -expand 
Anim::CreateBox factory schedule -side left -ipadx 2 -ipady 1 -expand -bw 2 -relief groove
Anim::CreateLabel schedule name Scheduler -width 10 -anchor w
Anim::CreateLabel schedule permitt permit -width 7 -anchor e
Anim::CreateLabel schedule permitv permit -var -bw 1 -relief sunken -width 1
Anim::CreateLabel schedule countt count -width 6 -anchor e
Anim::CreateLabel schedule countv count -var -bw 1 -relief sunken -width 1

Anim::CreateBox factory ips -side left -ipadx 2 -ipady 1 -expand -bw 2 -relief groove
Anim::CreateLabel ips name IPS -width 4 -anchor w
Anim::CreateLabel ips At A -width 2 -anchor e
Anim::CreateLabel ips Av nrA -var -bw 1 -relief sunken -width 3
Anim::CreateLabel ips Bt B -width 2 -anchor e
Anim::CreateLabel ips Bv nrB -var -bw 1 -relief sunken -width 3
Anim::CreateLabel ips Ct C -width 2 -anchor e
Anim::CreateLabel ips Cv nrC -var -bw 1 -relief sunken -width 3

Anim::CreateBox info validation -side top -fill x -bw 2 -relief groove
Anim::CreateLabel validation name Validation -anchor w
Anim::CreateBox validation table -side top -fill x
Anim::CreateBox table head1 -side left
Anim::CreateLabel head1 c1 "" -width 6 -bw 1
Anim::CreateLabel head1 cA A -width 12 -bw 1 -padx 7
Anim::CreateLabel head1 cB B -width 12 -bw 1 -padx 7
Anim::CreateLabel head1 cC C -width 12 -bw 1 -padx 7
Anim::CreateBox table head2 -side left
Anim::CreateLabel head2 c1 "" -width 6 -bw 1
Anim::CreateLabel head2 cA1 1 -width 3 -bw 1
Anim::CreateLabel head2 cA2 2 -width 3 -bw 1
Anim::CreateLabel head2 cA3 3 -width 3 -bw 1
Anim::CreateLabel head2 cA4 4 -width 3 -bw 1
Anim::CreateLabel head2 cB1 1 -width 3 -bw 1
Anim::CreateLabel head2 cB2 2 -width 3 -bw 1
Anim::CreateLabel head2 cB3 3 -width 3 -bw 1
Anim::CreateLabel head2 cB4 4 -width 3 -bw 1
Anim::CreateLabel head2 cC1 1 -width 3 -bw 1
Anim::CreateLabel head2 cC2 2 -width 3 -bw 1
Anim::CreateLabel head2 cC3 3 -width 3 -bw 1
Anim::CreateLabel head2 cC4 4 -width 3 -bw 1
Anim::CreateBox table row1 -side left
Anim::CreateLabel row1 int input -width 6 -anchor w -bw 1
Anim::CreateLabel row1 inA1 input(A,1) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inA2 input(A,2) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inA3 input(A,3) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inA4 input(A,4) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inB1 input(B,1) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inB2 input(B,2) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inB3 input(B,3) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inB4 input(B,4) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inC1 input(C,1) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inC2 input(C,2) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inC3 input(C,3) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row1 inC4 input(C,4) -var -width 3 -bw 1 -relief sunken
Anim::CreateBox table row2 -side left
Anim::CreateLabel row2 out output -width 6 -anchor w -bw 1
Anim::CreateLabel row2 ouA1 output(A,1) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouA2 output(A,2) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouA3 output(A,3) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouA4 "" -width 3 -bw 1
Anim::CreateLabel row2 ouB1 output(B,1) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouB2 output(B,2) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouB3 output(B,3) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouB4 "" -width 3 -bw 1
Anim::CreateLabel row2 ouC1 output(C,1) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouC2 output(C,2) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouC3 output(C,3) -var -width 3 -bw 1 -relief sunken
Anim::CreateLabel row2 ouC4 "" -width 3 -bw 1

Anim::View 300 100

#array set input [list A,1 0 A,2 0 A,3 0 A,4 0 B,1 0 B,2 0 B,3 0 B,4 0 C,1 0 C,2 0 C,3 0 C,4 0]
#array set output [list A,1 0 A,2 0 A,3 0 A,4 0 B,1 0 B,2 0 B,3 0 B,4 0 C,1 0 C,2 0 C,3 0 C,4 0]
Anim::InitArray input [list A,1 0 A,2 0 A,3 0 A,4 0 B,1 0 B,2 0 B,3 0 B,4 0 C,1 0 C,2 0 C,3 0 C,4 0]
Anim::InitArray output [list A,1 0 A,2 0 A,3 0 A,4 0 B,1 0 B,2 0 B,3 0 B,4 0 C,1 0 C,2 0 C,3 0 C,4 0]

proc str_nr {s} {
    if {$s == "one"} {
	return 1
    } elseif {$s == "two"} {
	return 2
    } else {
	return 3
    }
}

proc ANIM_action {line} {
    global printw
    if {[regexp {^read-order-EO\((.*), nat\(\(\^ (.*)\)\)\)$} $line match arg1 arg2]} {
	Anim::AddQueue OQ "$arg1$arg2"
    } elseif {[regexp {^comm-order-EO\(order\((.*), nat\(\(\^ (.*)\)\)\)\)$} $line match arg1 arg2]} {
	Anim::DeactivateLine VALOQ
	Anim::DeleteText VALOQ
	Anim::AddQueue OQ "$arg1$arg2"
    } elseif {[regexp {^comm-order-OSC\(order\((.*), nat\(\(\^ (.*)\)\)\)\)$} $line match arg1 arg2]} {
	Anim::SubQueue OQ
	Anim::CreateText OQSC "$arg1$arg2"
	Anim::ActivateLine OQSC
	Anim::AddClear SC {line OQSC} {text OQSC}
	global order
	set order(type) $arg1
	set order(size) $arg2
    } elseif {[regexp {^comm-request-RS\(TPC, request\((.*), (.*),.*,.*\)\)$} $line match arg1 arg2]} {
	Anim::DeactivateLine SCTPC
	Anim::DeleteText SCTPC
	set nr [str_nr $arg2]
	if {$arg1 == "A"} {
	    Anim::DeactivateLine SCTPCA
	    Anim::CreateItem OTPCSCP rect [Anim::Dim TPC1 x] \
		[Anim::Dim TPC1 s,y] $printw $printw "$arg1$nr" -nolist -free -color 1
	} else {
	    Anim::DeactivateLine SCTPCBC
	    Anim::CreateItem OTPCSCP rect [Anim::Dim TPC2 x] \
		[Anim::Dim TPC2 s,y] $printw $printw "$arg1$nr" -nolist -free -color 1
	}
    } elseif {[regexp {^comm-belt\(TPC, SCP\)$} $line match]} {
	Anim::Move OTPCSCP downto [Anim::DimL BA start,y] \
	    rightto [Anim::Dim SCP w,x] -newid OSCP
    } elseif {[regexp {^comm-belt\(SSB, SCP\)$} $line match]} {
	Anim::Move OSSBSCP rightto [Anim::Dim SCP w,x] -newid OSCP
    } elseif {[regexp {^comm-request-RS\(SCP, request\((.*),.*,.*, MC1\)\)$} $line match arg1]} {
	Anim::Move OSCP rightto [Anim::Dim SCP e,x] -newid OSCPMC1
    } elseif {[regexp {^comm-belt\(.*, MC1\)$} $line match]} {
	Anim::Move OSCPMC1 rightto [Anim::Dim MC1 w,x] -newid OMC1
    } elseif {[regexp {^comm-request-RS\(MC1, request\((.*),.*,.*, CP1\)\)$} $line match arg1]} {
	Anim::Move OMC1 rightto [Anim::Dim MC1 x] \
	    downto [Anim::DimL BC start,y] \
	    rightto [Anim::Dim MC1 e,x] -newid OMC1CP1
    } elseif {[regexp {^comm-request-RS\(MC1, request\((.*),.*,.*, MC2\)\)$} $line match arg1]} {
	Anim::Move OMC1 rightto [Anim::Dim MC1 e,x] -newid OMC1MC2
    } elseif {[regexp {^comm-belt\(.*, CP1\)$} $line match]} {
	Anim::Move OMC1CP1 rightto [Anim::Dim CP1 w,x] -newid OCP1
    } elseif {[regexp {^comm-request-RS\(CP1, request\((.*),.*,.*, MC2\)\)$} $line match arg1]} {
	Anim::Move OCP1 rightto [Anim::Dim CP1 e,x] -newid OCP1MC2
    } elseif {[regexp {^comm-belt\(MC1, MC2\)$} $line match]} {
	Anim::Move OMC1MC2 rightto [Anim::Dim MC2 w,x] -newid OMC2
    } elseif {[regexp {^comm-belt\(CP1, MC2\)$} $line match]} {
	Anim::Move OCP1MC2 rightto [Anim::Dim MC2 w,x] -newid OMC2
    } elseif {[regexp {^comm-request-RS\(MC2, request\((.*),.*, (.*), CP2\)\)$} $line match arg1 arg2]} {
	if {$arg2 == "backward"} {
	    Anim::Move OMC2 rightto [Anim::Dim MC2 x] \
		downto [Anim::DimL BC start,y]
	}
	Anim::Move OMC2 rightto [Anim::Dim MC2 e,x] -newid OMC2CP2
    } elseif {[regexp {^comm-request-RS\(MC2, request\((.*),.*, (.*), BMR\)\)$} $line match arg1 arg2]} {
	Anim::Move OMC2 rightto [Anim::Dim MC2 x] upto [Anim::DimL BA start,y] \
	    rightto [Anim::Dim MC2 e,x] -newid OMC2BMR
    } elseif {[regexp {^comm-belt\(.*, CP2\)$} $line match]} {
	Anim::Move OMC2CP2 rightto [Anim::Dim CP2 w,x] -newid OCP2
    } elseif {[regexp {^comm-request-RS\(CP2, request\((.*),.*,.*, BMR\)\)$} $line match arg1]} {
	Anim::Move OCP2 rightto [Anim::Dim CP2 e,x] -newid OCP2BMR
    } elseif {[regexp {^comm-belt\(MC2, BMR\)$} $line match]} {
	Anim::Move OMC2BMR rightto [Anim::Dim BMR w,x] -newid OBMR
    } elseif {[regexp {^comm-belt\(CP2, BMR\)$} $line match]} {
	Anim::Move OCP2BMR rightto [Anim::Dim BMR w,x] -newid OBMR
    } elseif {[regexp {^comm-request-RS\(BMR, request\((.*),.*, (.*), RCL\)\)$} $line match arg1 arg2]} {
	if {! ($arg2 == "backward")} {
	    Anim::Move OBMR rightto [Anim::Dim BMR x] \
		upto [Anim::DimL BA start,y]
	}
	Anim::Move OBMR rightto [Anim::Dim BMR e,x] -newid OBMRRCL
    } elseif {[regexp {^comm-belt\(.*, RCL\)$} $line match]} {
	Anim::Move OBMRRCL rightto [Anim::Dim RCL w,x] -newid ORCL
    } elseif {[regexp {^comm-request-RS\(RCL, request\((.*),.*,.*, BMW\)\)$} $line match arg1]} {
	Anim::Move ORCL rightto [Anim::Dim RCL e,x] -newid ORCLBMW
    } elseif {[regexp {^comm-belt\(IPSd, BMW\)$} $line match]} {
	Anim::Move OIPSBMW upto [Anim::DimL BA start,y] \
	    rightto [Anim::Dim BMW w,x] -newid OBMW
    } elseif {[regexp {^comm-belt\(RCL, BMW\)$} $line match]} {
	Anim::Move ORCLBMW rightto [Anim::Dim BMW w,x] -newid OBMW
    } elseif {[regexp {^comm-request-RS\(RCL, request\((.*),.*,.*, IPSr\)\)$} $line match arg1]} {
	global type
	Anim::Move ORCL rightto [Anim::Dim RCL e,x] -newid ORCLIPS
	set type [string index $arg1 0]
    } elseif {[regexp {^comm-belt\(.*, IPSr\)$} $line match]} {
	global type
	Anim::Move ORCLIPS rightto [Anim::Dim IPS$type x] \
	    downto [Anim::Dim IPS$type n,y] -newid OIPS
    } elseif {[regexp {^comm-request-RS\(IPSr, request\((.*), (.*),.*, Dum\)\)$} $line match arg1 arg2]} {
	global nrA nrB nrC
	if {$arg1 == "Ch"} {
	    incr nrC [str_nr $arg2]
	} else {
	    incr nr$arg1 [str_nr $arg2]
	}
	Anim::DestroyItem OIPS
    } elseif {[regexp {^comm-request-RS\(IPSd, request\((.*), (.*),.*, BMW\)\)$} $line match arg1 arg2]} {
	Anim::DeactivateLine SCIPS
	Anim::DeactivateLine SCIPS$arg1
	Anim::DeleteText SCIPS
	set nr [str_nr $arg2]
	Anim::CreateItem OIPSBMW rect [Anim::Dim IPS$arg1 x] \
	    [Anim::Dim IPS$arg1 n,y] $printw $printw "$arg1$nr" \
	    -nolist -free -color 1
	global nrA nrB nrC
	incr nr$arg1 -$nr
	update
    } elseif {[regexp {^comm-request-RS\(BMW, request\((.*),.*,.*, BRE\)\)$} $line match arg1]} {
	Anim::Move OBMW rightto [Anim::Dim BMW x] upto [Anim::DimL BB start,y] \
	    leftto [Anim::Dim BMW w,x] -newid OBMWBRE
    } elseif {[regexp {^comm-request-RS\(BMW, request\((.*),.*,.*, IET\)\)$} $line match arg1]} {
	Anim::Move OBMW rightto [Anim::Dim BMW e,x] -newid OBMWIET
    } elseif {[regexp {^comm-belt\(.*, IET\)$} $line match]} {
	Anim::Move OBMWIET rightto [Anim::Dim IET w,x] -newid OIET
    } elseif {[regexp {^comm-request-RS\(IET, request\((.*),.*,.*, BTR\)\)$} $line match arg1]} {
	Anim::Move OIET rightto [Anim::Dim IET e,x] -newid OIETBTR
    } elseif {[regexp {^comm-belt\(.*, BTR\)$} $line match]} {
	Anim::Move OIETBTR rightto [Anim::Dim BTR w,x] -newid OBTR
    } elseif {[regexp {^comm-request-RS\(BTR, request\((.*),.*,.*, BRE\)\)$} $line match arg1]} {
	Anim::Move OBTR rightto [Anim::Dim BTR x] upto [Anim::DimL BB start,y] \
	    leftto [Anim::Dim BTR w,x] -newid OBTRBRE
    } elseif {[regexp {^comm-belt\(BMW, BRE\)$} $line match]} {
	Anim::Move OBMWBRE leftto [Anim::Dim BRE e,x] -newid OBRE
    } elseif {[regexp {^comm-belt\(BTR, BRE\)$} $line match]} {
	Anim::Move OBTRBRE leftto [Anim::Dim BRE e,x] -newid OBRE
    } elseif {[regexp {^comm-request-RS\(BRE, request\((.*),.*,.*, SSB\)\)$} $line match arg1]} {
	Anim::Move OBRE leftto [Anim::Dim BRE w,x] -newid OBRESSB
    } elseif {[regexp {^comm-belt\(.*, SSB\)$} $line match]} {
	Anim::Move OBRESSB leftto [Anim::Dim SSB e,x] -newid OSSB
    } elseif {[regexp {^comm-request-RS\(BRE, request\((.*),.*,.*, WAR\)\)$} $line match arg1]} {
	Anim::Move OBRE leftto [Anim::DimL BD start,x] upto [Anim::Dim BRE n,y] \
	    -newid OBREWAR
    } elseif {[regexp {^comm-belt\(.*, WAR\)$} $line match]} {
	Anim::Move OBREWAR upto [Anim::Dim WAR s,y] -newid OWAR
    } elseif {[regexp {^comm-request-RS\(WAR, request\((.*), (.*),.*, Dum\)\)$} $line match arg1 arg2]} {
	Anim::DestroyItem OWAR
	Anim::CreateText WARSQ "$arg1[str_nr $arg2]"
	Anim::ActivateLine WARSQ
    } elseif {[regexp {^comm-request-RS\(SSB, request\((.*), (.*),.*, SCP\)\)$} $line match arg1 arg2]} {
	set nr [str_nr $arg2]
	Anim::Move OSSB leftto [Anim::Dim SSB x]
	Anim::ChangeTextItem OSSB "$arg1$nr"
	Anim::Move OSSB downto [Anim::DimL BA start,y] \
	    rightto [Anim::Dim SSB e,x] -newid OSSBSCP
    } elseif {[regexp {^comm-order-SCS\(order\((.*), nat\(\(\^ (.*)\)\)\)\)$} $line match arg1 arg2]} {
	Anim::DeactivateLine WARSQ
	Anim::DeleteText WARSQ
	Anim::AddQueue SQ "$arg1$arg2"
    } elseif {[regexp {^comm-order-SE\(order\((.*), nat\(\(\^ (.*)\)\)\)\)$} $line match arg1 arg2]} {
	Anim::SubQueue SQ
	Anim::CreateText SQVAL "$arg1$arg2"
	Anim::ActivateLine SQVAL
    } elseif {[regexp {^comm-permit-PS$} $line match]} {
	global permit
	set permit 2
	Anim::DeactivateLine OQSC
	Anim::DeleteText OQSC
	global order
	if {$order(size) > 3} {
	    incr order(size) -3
	    Anim::CreateText SCorder "$order(type)$order(size)"
	    Anim::CreateText SCTPC "$order(type)3"
	    Anim::CreateText SCIPS "$order(type)3"
	} else {
	    if {$order(size)} {
		Anim::DeleteText SCorder
	    }
	    Anim::CreateText SCTPC "$order(type)$order(size)"
	    Anim::CreateText SCIPS "$order(type)$order(size)"
	    set order(size) 0
	}
	Anim::ActivateLine SCTPC
	if {$order(type) == "A"} {
	    Anim::ActivateLine SCTPCA
	} else {
	    Anim::ActivateLine SCTPCBC
	}
	Anim::ActivateLine SCIPS
	Anim::ActivateLine SCIPS$order(type)
    } elseif {[regexp {^comm-permit-RP$} $line match]} {
	global permit
	set permit [expr $permit-1]
    } elseif {[regexp {^comm-incr-count\(nat\(\(\^ (.*)\)\),.*\)$} $line match arg1]} {
	global count
	set count [expr $arg1 + 1]
    } elseif {[regexp {^comm-decr-count\(nat\(\(\^ (.*)\)\)\)$} $line match arg1]} {
	global count
	set count [expr $arg1 - 1]
    } elseif {[regexp {^input-order\((.*), nat\(\(\^ (.*)\)\)\)$} $line match arg1 arg2]} {
	Anim::CreateText VALin "$arg1$arg2"
	Anim::ActivateLine VALin
    } elseif {[regexp {^val-input\(order\((.*), nat\(\(\^ (.*)\)\)\)\)$} $line match arg1 arg2]} {
	Anim::DeactivateLine VALin
	Anim::DeleteText VALin
	Anim::CreateText VALOQ "$arg1$arg2"
	Anim::ActivateLine VALOQ
	global input
	incr input($arg1,$arg2)
    } elseif {[regexp {^val-output\(order\((.*), nat\(\(\^ (.*)\)\)\)\)$} $line match arg1 arg2]} {
	Anim::DeactivateLine SQVAL
	Anim::DeleteText SQVAL
	Anim::CreateText VALout "$arg1$arg2"
	Anim::ActivateLine VALout
	global output
	incr output($arg1,$arg2)
    } elseif {[regexp {^output-order\(order\((.*), nat\(\(\^ (.*)\)\)\)\)$} $line match arg1 arg2]} {
	Anim::DeactivateLine VALout
	Anim::DeleteText VALout
    }
}
