Anim::Windows 480 220 -text 45 10

Anim::CreateItem TSIM rect 140 30 20 15 ""
Anim::CreateItem TANIM rect 340 30 20 15 ""
Anim::CreateItem ISIM rect 140 100 20 15 ""
Anim::CreateItem IANIM rect 340 100 20 15 ""
Anim::CreateItem SIM rect 140 170 20 15 "SIM"
Anim::CreateItem ANIM rect 340 170 20 15 "ANIM"

Anim::CreateLine TSIMtoISIM pos [expr [Anim::Dim TSIM x] - 8] \
    [Anim::Dim TSIM s,y] pos [expr [Anim::Dim ISIM x] - 8] [Anim::Dim ISIM n,y] \
    -arrow last
Anim::CreateLine ISIMtoTSIM pos [expr [Anim::Dim ISIM x] + 8] \
    [Anim::Dim ISIM n,y] pos [expr [Anim::Dim TSIM x] + 8] [Anim::Dim TSIM s,y] \
    -arrow last
Anim::CreateLine ISIMtoSIM pos [expr [Anim::Dim ISIM x] - 8] \
    [Anim::Dim ISIM s,y] pos [expr [Anim::Dim SIM x] - 8] [Anim::Dim SIM n,y] \
    -arrow last
Anim::CreateLine SIMtoISIM pos [expr [Anim::Dim SIM x] + 8] \
    [Anim::Dim SIM n,y] pos [expr [Anim::Dim ISIM x] + 8] [Anim::Dim ISIM s,y] \
    -arrow last

Anim::CreateLine TANIMtoIANIM pos [expr [Anim::Dim TANIM x] - 8] \
    [Anim::Dim TANIM s,y] pos [expr [Anim::Dim IANIM x] - 8] \
    [Anim::Dim IANIM n,y] -arrow last
Anim::CreateLine IANIMtoTANIM pos [expr [Anim::Dim IANIM x] + 8] \
    [Anim::Dim IANIM n,y] pos [expr [Anim::Dim TANIM x] + 8] \
    [Anim::Dim TANIM s,y] -arrow last
Anim::CreateLine IANIMtoANIM pos [expr [Anim::Dim IANIM x] - 8] \
    [Anim::Dim IANIM s,y] pos [expr [Anim::Dim ANIM x] - 8] [Anim::Dim ANIM n,y] \
    -arrow last
Anim::CreateLine ANIMtoIANIM pos [expr [Anim::Dim ANIM x] + 8] \
    [Anim::Dim ANIM n,y] pos [expr [Anim::Dim IANIM x] + 8] [Anim::Dim IANIM s,y] \
    -arrow last

Anim::CreateLine TSIMtoTANIM pos [Anim::Dim TSIM e,x] \
    [expr [Anim::Dim TSIM y] + 8] pos [Anim::Dim TANIM w,x] \
    [expr [Anim::Dim TANIM y] + 8] -arrow last
Anim::CreateLine TANIMtoTSIM pos [Anim::Dim TANIM w,x] \
    [expr [Anim::Dim TANIM y] - 8] pos [Anim::Dim TSIM e,x] \
    [expr [Anim::Dim TSIM y] - 8] -arrow last

Anim::Textpos toolbus 5 30 w -noreset
Anim::Textpos interfaces 5 100 w -noreset
Anim::Textpos tools 5 170 w -noreset
Anim::CreateText toolbus ToolBus
Anim::CreateText interfaces interfaces
Anim::CreateText tools tools

Anim::TextposItem SIM SIM s n
Anim::TextposItem ANIM ANIM s n

Anim::TextposLine TSIM-ISIM TSIMtoISIM e
Anim::TextposLine ISIM-TSIM ISIMtoTSIM w
Anim::TextposLine ISIM-SIM ISIMtoSIM e
Anim::TextposLine SIM-ISIM SIMtoISIM w

Anim::TextposLine TANIM-IANIM TANIMtoIANIM e
Anim::TextposLine IANIM-TANIM IANIMtoTANIM w
Anim::TextposLine IANIM-ANIM IANIMtoANIM e
Anim::TextposLine ANIM-IANIM ANIMtoIANIM w

Anim::TextposLine TSIM-TANIM TSIMtoTANIM n
Anim::TextposLine TANIM-TSIM TANIMtoTSIM s

proc ANIM_action {atom} {
    if {[regexp {^sim\(control\((.*)\)\)$} $atom match arg1]} {
	Anim::DeleteText ISIM-SIM
	Anim::DeactivateLine ISIMtoSIM
    } elseif {[regexp {^sim\(ack\)$} $atom match]} {
	Anim::DeleteText ISIM-SIM
	Anim::DeactivateLine ISIMtoSIM
    } elseif {[regexp {^sim\((.*)\)$} $atom match arg1]} {
	Anim::DeleteText SIM
	Anim::DeleteText ISIM-SIM
	Anim::CreateText SIM "$arg1"
    } elseif {[regexp {^simint-comm\((.*)\)$} $atom match arg1]} {
	Anim::DeleteText ISIM-SIM
	Anim::DeactivateLine ISIMtoSIM
	Anim::DeleteText SIM
	Anim::CreateText SIM-ISIM "$arg1"
	Anim::ActivateLine SIMtoISIM
    } elseif {[regexp {^intsim-comm\((.*)\)$} $atom match arg1]} {
	Anim::DeleteText TSIM-ISIM
	Anim::DeactivateLine TSIMtoISIM
	Anim::CreateText ISIM-SIM "$arg1"
	Anim::ActivateLine ISIMtoSIM
    } elseif {[regexp {^simtb-comm-snd\(tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::DeleteText SIM-ISIM
	Anim::DeactivateLine SIMtoISIM
	Anim::CreateText ISIM-TSIM "$arg1"
	Anim::ActivateLine ISIMtoTSIM
    } elseif {[regexp {^simtb-comm-rec\(tb-term\((.*)\)\)$} $atom match arg1]} {
	if {! [regexp {^ack$} $arg1 match]} {
	    Anim::DeleteText TANIM-TSIM
	    Anim::DeactivateLine TANIMtoTSIM
	}
	Anim::CreateText TSIM-ISIM "$arg1"
	Anim::ActivateLine TSIMtoISIM
    } elseif {[regexp {^tb-comm-msg\(panim, tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::DeleteText ISIM-TSIM
	Anim::DeactivateLine ISIMtoTSIM
	Anim::CreateText TSIM-TANIM "$arg1"
	Anim::ActivateLine TSIMtoTANIM
    } elseif {[regexp {^tb-comm-msg\(psim, tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::DeleteText IANIM-TANIM
	Anim::DeactivateLine IANIMtoTANIM
	Anim::CreateText TANIM-TSIM "$arg1"
	Anim::ActivateLine TANIMtoTSIM
    } elseif {[regexp {^animtb-comm-rec\(tb-term\((.*)\)\)$} $atom match arg1]} {
	# clean ack from animint
	Anim::DeleteText IANIM-TANIM
	Anim::DeactivateLine IANIMtoTANIM
	Anim::DeleteText TSIM-TANIM
	Anim::DeactivateLine TSIMtoTANIM
	Anim::CreateText TANIM-IANIM "$arg1"
	Anim::ActivateLine TANIMtoIANIM
    } elseif {[regexp {^animtb-comm-snd\(tb-term\((.*)\)\)$} $atom match arg1]} {
	if {[regexp {^control\(.*\)$} $arg1 match]} {
	    Anim::DeleteText TANIM-IANIM
	    Anim::DeactivateLine TANIMtoIANIM
	} else {
	    Anim::DeleteText ANIM-IANIM
	    Anim::DeactivateLine ANIMtoIANIM
	}
	Anim::DeleteText ANIM-IANIM
	Anim::DeactivateLine ANIMtoIANIM
	Anim::CreateText IANIM-TANIM "$arg1"
	Anim::ActivateLine IANIMtoTANIM
    } elseif {[regexp {^intanim-comm\((.*)\)$} $atom match arg1]} {
	Anim::DeleteText TANIM-IANIM
	Anim::DeactivateLine TANIMtoIANIM
	Anim::CreateText IANIM-ANIM "$arg1"
	Anim::ActivateLine IANIMtoANIM
    } elseif {[regexp {^animint-comm\((.*)\)$} $atom match arg1]} {
	# clean after a reset
	Anim::DeleteText IANIM-ANIM
	Anim::DeactivateLine IANIMtoANIM

	Anim::DeleteText ANIM
	Anim::CreateText ANIM-IANIM "$arg1"
	Anim::ActivateLine ANIMtoIANIM
    } elseif {[regexp {^anim\((.*)\)$} $atom match arg1]} {
	Anim::DeleteText IANIM-ANIM
	Anim::DeactivateLine IANIMtoANIM
	Anim::DeleteText ANIM
	Anim::CreateText ANIM "$arg1"
    } elseif {[regexp {^TB-Shutdown$} $atom match]} {
	Anim::DeleteText ISIM-TSIM
	Anim::DeactivateLine ISIMtoTSIM
	Anim::DeleteText IANIM-TANIM
	Anim::DeactivateLine IANIMtoTANIM
    }
}

proc ANIM_choose {atom} {
    if {[regexp {^sim\((.*)\)$} $atom match arg1]} {
	Anim::AddList SIM $match
    } elseif {[regexp {^simint-comm\((.*)\)$} $atom match arg1]} {
	Anim::AddList SIM $match
    } elseif {[regexp {^intsim-comm\((.*)\)$} $atom match arg1]} {
	Anim::AddList ISIM $match
    } elseif {[regexp {^simtb-comm-snd\(tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::AddList ISIM $match
    } elseif {[regexp {^simtb-comm-rec\(tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::AddList TSIM $match
    } elseif {[regexp {^tb-comm-msg\(panim, tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::AddList TSIM $match
    } elseif {[regexp {^tb-comm-msg\(psim, tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::AddList TANIM $match
    } elseif {[regexp {^animtb-comm-rec\(tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::AddList TANIM $match
    } elseif {[regexp {^animtb-comm-snd\(tb-term\((.*)\)\)$} $atom match arg1]} {
	Anim::AddList IANIM $match
    } elseif {[regexp {^intanim-comm\((.*)\)$} $atom match arg1]} {
	Anim::AddList IANIM $match
    } elseif {[regexp {^animint-comm\((.*)\)$} $atom match arg1]} {
	Anim::AddList ANIM $match
    } elseif {[regexp {^anim\((.*)\)$} $atom match arg1]} {
	Anim::AddList ANIM $match
    } elseif {[regexp {^TB-Shutdown|TB-App-Shutdown$} $atom match]} {
	Anim::AddList TSIM $match
    }
}
