Anim::Windows 340 200 -text 30 10

Anim::CreateItem inp rect 30 30 15 15 "In"
Anim::CreateItem s1 rect 30 100 15 15 "1"
Anim::CreateItem s2 rect 100 100 15 15 "2"
Anim::CreateItem s3 rect 170 100 15 15 "3"
Anim::CreateItem s4 rect 240 100 15 15 "4"
Anim::CreateItem s5 rect 240 170 15 15 "5"
Anim::CreateItem s6 rect 310 170 15 15 "6"
Anim::CreateItem out rect 310 100 15 15 "Out"

Anim::CreateLine ins1 item inp s item s1 n -arrow last
Anim::TextposLine ins1 ins1 e
Anim::CreateLine outs6 item s6 n item out s -arrow last
Anim::TextposLine outs6 outs6 w

Anim::CreateLine s1s2 item s1 e item s2 w -width 15
Anim::CreateLine s2s3 item s2 e item s3 w -width 15
Anim::CreateLine s3s4 item s3 e item s4 w -width 15
Anim::CreateLine s3s5 item s3 s pos [Anim::Dim s3 x] [Anim::Dim s5 y] \
    item s5 w -width 15
Anim::CreateLine s4s5 item s4 s item s5 n -width 15
Anim::CreateLine s5s6 item s5 e item s6 w -width 15

proc ANIM_action {atom} {
    if {[regexp {^input\((.*)\)$} $atom match arg1]} {
	Anim::CreateText ins1 "$arg1"
	Anim::ActivateLine ins1
    } elseif {[regexp {^comm-input\((.*)\)$} $atom match arg1]} {
	Anim::DeleteText ins1
	Anim::DeactivateLine ins1
	Anim::CreateItem AT1 rect [Anim::Dim s1 x] [Anim::Dim s1 y] \
	7 7 "$arg1" -free -color 1
    } elseif {[regexp {^comm-belt\(3, 4, .*\)$} $atom match arg1]} {
	Anim::Move AT3 rightto [Anim::Dim s4 x] -newid AT4
    } elseif {[regexp {^comm-belt\(3, 5, .*\)$} $atom match arg1]} {
	Anim::Move AT3 downto [Anim::Dim s5 y] rightto [Anim::Dim s5 x] -newid AT5
    } elseif {[regexp {^comm-belt\(4, 5, .*\)$} $atom match arg1]} {
	Anim::Move AT4 downto [Anim::Dim s5 y] -newid AT5
    } elseif {[regexp {^comm-belt\((.*), (.*), .*\)$} $atom match arg1 arg2]} {
	Anim::Move AT$arg1 rightto [Anim::Dim s$arg2 x] -newid AT$arg2
    } elseif {[regexp {^comm-output\((.*)\)$} $atom match arg1]} {
	Anim::DestroyItem AT6
	Anim::CreateText outs6 "$arg1"
	Anim::ActivateLine outs6
    } elseif {[regexp {^output\((.*)\)$} $atom match arg1]} {
	Anim::DeleteText outs6
	Anim::DeactivateLine outs6
    }
}

proc ANIM_choose {atom} {
    if {[regexp {^input\((.*)\)$} $atom match arg1]} {
	Anim::AddList inp $match
    } elseif {[regexp {^comm-input\((.*)\)$} $atom match arg1]} {
	Anim::AddList s1 $match
    } elseif {[regexp {^comm-belt\((.*), (.*), .*\)$} $atom match arg1 arg2]} {
	Anim::AddList AT$arg1 $match
    } elseif {[regexp {^comm-output\((.*)\)$} $atom match arg1]} {
	Anim::AddList s6 $match
    } elseif {[regexp {^output\((.*)\)$} $atom match arg1]} {
	Anim::AddList out $match
    }
}
