Anim::Windows 440 200 -text 61 10

Anim::CreateItem recti rect 30 150 20 20 "I"
Anim::CreateItem ovals oval 120 150 20 20 "S"
Anim::CreateItem rectk rect 240 150 40 10 "K"
Anim::CreateItem ovalr oval 360 150 20 20 "R"
Anim::CreateItem rectl rect 240 50 40 10 "L"
Anim::CreateItem ovalas oval 360 50 20 20 "AS"
Anim::CreateItem ovalar oval 120 50 20 20 "AR"

Anim::CreateLine toS item recti e item ovals chop -arrow last
Anim::TextposLine toS toS s
Anim::CreateLine StoK item ovals chop item rectk w -arrow last
Anim::TextposLine StoK StoK n
Anim::TextposItem atK rectk s n
Anim::CreateLine KtoR item rectk e item ovalr chop -arrow last
Anim::TextposLine KtoR KtoR n
Anim::CreateLine fromR item ovalr chop pos 430 150 -arrow last
Anim::TextposLine fromR fromR s

Anim::CreateLine RtoAS item ovalr chop item ovalas chop -arrow last
Anim::TextposLine RtoAS RtoAS w
Anim::CreateLine AStoL item ovalas chop item rectl e -arrow last
Anim::TextposLine AStoL AStoL s
Anim::TextposItem atL rectl n s
Anim::CreateLine LtoAR item rectl w item ovalar chop -arrow last
Anim::TextposLine LtoAR LtoAR s
Anim::CreateLine ARtoS item ovalar chop item ovals chop -arrow last
Anim::TextposLine ARtoS ARtoS e

proc ANIM_action {line} {
    if {[regexp {^input\('(.*)\)$} $line match arg1]} {
	Anim::Clear recti
	Anim::Clear ovals
	Anim::CreateText toS "$arg1"
	Anim::ActivateLine toS
	Anim::AddClear ovals {line toS} {text toS}
    } elseif {[regexp {^comm-SK\(frame\('(.*), (.*)\)\)$} $line match arg1 arg2]} {
	Anim::Clear ovals
	Anim::CreateText StoK "$arg1 ($arg2)"
	Anim::ActivateLine StoK
	Anim::AddClear rectk {line StoK} {text StoK}
    } elseif {[regexp {^skip<(0|1|2)>$} $line match]} {
	Anim::Clear rectk
	Anim::CreateText atK "$match"
	Anim::AddClear rectk {text atK}
    } elseif {[regexp {^comm-KR\(frame\('(.*), (.*)\)\)$} $line match arg1 arg2]} {
	Anim::Clear rectk
	Anim::Clear ovalr
	Anim::CreateText KtoR "$arg1 ($arg2)"
	Anim::ActivateLine KtoR
	Anim::AddClear ovalr {line KtoR} {text KtoR}
    } elseif {[regexp {^comm-KR\((.*)\)$} $line match arg1]} {
	Anim::Clear rectk
	Anim::Clear ovalr
	Anim::CreateText KtoR "$arg1"
	Anim::ActivateLine KtoR
	Anim::AddClear ovalr {line KtoR} {text KtoR}
    } elseif {[regexp {^output\('(.*)\)$} $line match arg1]} {
	Anim::Clear ovalr
	Anim::CreateText fromR "$arg1"
	Anim::ActivateLine fromR
	Anim::AddClear ovalr {line fromR} {text fromR}
    } elseif {[regexp {^comm-RAS\((.*)\)$} $line match arg1]} {
	Anim::Clear ovalr
	Anim::CreateText RtoAS "$arg1"
	Anim::ActivateLine RtoAS
	Anim::AddClear ovalas {line RtoAS} {text RtoAS}
    } elseif {[regexp {^comm-ASL\((.*)\)$} $line match arg1]} {
	Anim::Clear ovalas
	Anim::CreateText AStoL "$arg1"
	Anim::ActivateLine AStoL
	Anim::AddClear ovalas {line AStoL} {text AStoL}
    } elseif {[regexp {^skip<(3|4|5)>$} $line match]} {
	Anim::Clear ovalas
	Anim::CreateText atL "$match"
	Anim::AddClear rectl {text atL}
    } elseif {[regexp {^comm-LAR\((.*)\)$} $line match arg1]} {
	Anim::Clear rectl
	Anim::Clear ovalar
	Anim::CreateText LtoAR "$arg1"
	Anim::ActivateLine LtoAR
	Anim::AddClear ovalar {line LtoAR} {text LtoAR}
    } elseif {[regexp {^comm-ARS\((.*)\)$} $line match arg1]} {
	Anim::Clear ovalar
	Anim::CreateText ARtoS "$arg1"
	Anim::ActivateLine ARtoS
	Anim::AddClear ovals {line ARtoS} {text ARtoS}
    }
}

proc ANIM_choose {line} {
    if {[regexp {^input\('(.*)\)$} $line match arg1]} {
	Anim::AddList recti $match
    } elseif {[regexp {^comm-SK\(frame\('(.*), (.*)\)\)$} $line match arg1 arg2]} {
	Anim::AddList ovals $match
    } elseif {[regexp {^skip<(0|1|2)>$} $line match]} {
	Anim::AddList rectk $match
    } elseif {[regexp {^comm-KR\(frame\('(.*), (.*)\)\)$} $line match arg1 arg2]} {
	Anim::AddList rectk $match
    } elseif {[regexp {^comm-KR\((.*)\)$} $line match arg1]} {
	Anim::AddList rectk $match
    } elseif {[regexp {^output\('(.*)\)$} $line match arg1]} {
	Anim::AddList ovalr $match
    } elseif {[regexp {^comm-RAS\((.*)\)$} $line match arg1]} {
	Anim::AddList ovalr $match
    } elseif {[regexp {^comm-ASL\((.*)\)$} $line match arg1]} {
	Anim::AddList ovalas $match
    } elseif {[regexp {^skip<(3|4|5)>$} $line match]} {
	Anim::AddList rectl $match
    } elseif {[regexp {^comm-LAR\((.*)\)$} $line match arg1]} {
	Anim::AddList rectl $match
    } elseif {[regexp {^comm-ARS\((.*)\)$} $line match arg1]} {
	Anim::AddList ovalar $match
    }
}
