Anim::Windows 440 220 -text 61 10

Anim::CreateItem recti rect 30 110 20 20 "I"
Anim::CreateItem ovals oval 120 110 20 20 "S"
Anim::CreateItem ovalr oval 360 110 20 20 "R"
Anim::CreateItem rectl rect 240 30 40 10 "L"
Anim::CreateItem rectk rect 240 190 40 10 "K"

Anim::CreateLine toS pos 50 110 item ovals chop -arrow last
Anim::TextposLine toS toS s
Anim::CreateLine fromR item ovalr chop pos 430 110 -arrow last
Anim::TextposLine fromR fromR s

Anim::CreateLine StoK item ovals se item rectk w -arrow last
Anim::TextposLine StoK StoK ne
Anim::TextposItem atK rectk s n
Anim::CreateLine KtoR item rectk e item ovalr sw -arrow last
Anim::TextposLine KtoR KtoR nw
Anim::CreateLine RtoL item ovalr nw item rectl e -arrow last
Anim::TextposLine RtoL RtoL sw
Anim::TextposItem atL rectl n s
Anim::CreateLine LtoS item rectl w item ovals ne -arrow last
Anim::TextposLine LtoS LtoS se

proc ANIM_action {line} {
    if {[regexp {^input\('(.*)\)$} $line match arg1]} {
	Anim::Clear recti
	Anim::Clear ovals
	Anim::CreateText toS "$arg1"
	Anim::ActivateLine toS
	Anim::AddClear ovals {line toS} {text toS}
    } elseif {[regexp {^skip frame-comm\(frame\((.*), '(.*)\)\)$} $line match arg1 arg2]} {
	Anim::Clear ovals
	Anim::CreateText StoK "$arg2 ($arg1)"
	Anim::ActivateLine StoK
	Anim::AddClear rectk {line StoK} {text StoK}
    } elseif {[regexp {^skip<(0|1)>$} $line match]} {
	Anim::Clear rectk
	Anim::CreateText atK "$match"
	Anim::AddClear rectk {text atK}
    } elseif {[regexp {^skip frame-or-error\(frame\((.*), '(.*)\)\)$} $line match arg1 arg2]} {
	Anim::Clear rectk
	Anim::CreateText KtoR "$arg2 ($arg1)"
	Anim::ActivateLine KtoR
	Anim::AddClear ovalr {line KtoR} {text KtoR}
    } elseif {[regexp {^skip frame-or-error\(frame-error\)$} $line match]} {
	Anim::Clear rectk
	Anim::CreateText KtoR "error"
	Anim::ActivateLine KtoR
	Anim::AddClear ovalr {line KtoR} {text KtoR}
    } elseif {[regexp {^output\('(.*)\)$} $line match arg1]} {
	Anim::Clear ovalr
	Anim::CreateText fromR "$arg1"
	Anim::ActivateLine fromR
	Anim::AddClear ovalr {line fromR} {text fromR}
    } elseif {[regexp {^skip ack-comm\(ack\((.*)\)\)$} $line match arg1]} {
	Anim::Clear ovalr
	Anim::CreateText RtoL "ack($arg1)"
	Anim::ActivateLine RtoL
	Anim::AddClear rectl {line RtoL} {text RtoL}
    } elseif {[regexp {^skip<(2|3)>$} $line match]} {
	Anim::Clear rectl
	Anim::CreateText atL "$match"
	Anim::AddClear rectl {text atL}
    } elseif {[regexp {^skip ack-or-error\(ack\((.*)\)\)$} $line match arg1]} {
	Anim::Clear rectl
	Anim::CreateText LtoS "ack($arg1)"
	Anim::ActivateLine LtoS
	Anim::AddClear recti {line LtoS} {text LtoS}
	Anim::AddClear ovals {line LtoS} {text LtoS}
    } elseif {[regexp {^skip ack-or-error\(ack-error\)$} $line match]} {
	Anim::Clear rectl
	Anim::CreateText LtoS "error"
	Anim::ActivateLine LtoS
	Anim::AddClear ovals {line LtoS} {text LtoS}
    }
}

proc ANIM_choose {line} {
    if {[regexp {^input\('(.*)\)$} $line match arg1]} {
	Anim::AddList recti $match
    } elseif {[regexp {^skip frame-comm\(frame\((.*), '(.*)\)\)$} $line match arg1 arg2]} {
	Anim::AddList ovals $match
    } elseif {[regexp {^skip<(0|1)>$} $line match]} {
	Anim::AddList rectk $match
    } elseif {[regexp {^skip frame-or-error\(frame\((.*), '(.*)\)\)$} $line match arg1 arg2]} {
	Anim::AddList rectk $match
    } elseif {[regexp {^skip frame-or-error\(frame-error\)$} $line match]} {
	Anim::AddList rectk $match
    } elseif {[regexp {^output\('(.*)\)$} $line match arg1]} {
	Anim::AddList ovalr $match
    } elseif {[regexp {^skip ack-comm\(ack\((.*)\)\)$} $line match arg1]} {
	Anim::AddList ovalr $match
    } elseif {[regexp {^skip<(2|3)>$} $line match]} {
	Anim::AddList rectl $match
    } elseif {[regexp {^skip ack-or-error\(ack\((.*)\)\)$} $line match arg1]} {
	Anim::AddList rectl $match
    } elseif {[regexp {^skip ack-or-error\(ack-error\)$} $line match]} {
	Anim::AddList rectl $match
    }
}
