#line 64 "TBmodule.c.nw"
#include <limits.h>
#include <stdio.h>
#include <tcl.h>
#include <tk.h>
#include <TB.h>
#include <procs.h>
#include <tool2.h>
#include "Python.h"
#include "allobjects.h"
#include "sysmodule.h"
#include "compile.h"
#include "frameobject.h"
#ifdef USE_TIDE
#include "debug-nub.tif.c"
#endif
#line 85 "TBmodule.c.nw"
#define MAX_FUN_LEN 128
#line 95 "TBmodule.c.nw"
void stopped_eventloop();
#line 102 "TBmodule.c.nw"
static PyMethodDef TermMethods[];
static PyMethodDef TBMethods[];

static PyObject *TBError;
static PyObject *Dict;
static PyObject *Modules[MAX_CONNECTIONS] = { NULL };
static TBbool simplify_all = TBtrue;
#ifndef NO_TK
static TBbool enableTk = TBfalse;
#endif

#ifdef USE_TIDE
#define ES_STOPPED	0
#define ES_SINGLE_STEP	1
#define ES_RUNNING	2

static PyObject *LocalTraceFunc;
static int debugCid = -1;
static int lastCid = -1;
static term *CPE = NULL;
static int exec_state = ES_STOPPED;
#endif

/* Print traces on stderr */
#define TRACE_CALLS 1
static int trace_mode = 0;

#line 141 "TBmodule.c.nw"
typedef struct {
  PyObject_HEAD
  term *t;
  PyObject *t_attr;
} PyTerm;
#line 161 "TBmodule.c.nw"
#define PyTerm_Check(op) ((op)->ob_type == &PyTerm_Type)
#line 168 "TBmodule.c.nw"
static int PyTerm_print(PyTerm *T, FILE *f, int flags);
static void PyTerm_dealloc(PyTerm *T);
static PyObject *PyTerm_getattr(PyTerm *T, char *name);
static int PyTerm_setattr(PyTerm *T, char *name, PyObject *V);
static int PyTerm_compare(PyTerm *T1, PyTerm *T2);
static PyObject *PyTerm_repr(PyTerm *T);
#line 182 "TBmodule.c.nw"
static PyTypeObject PyTerm_Type = {
        PyObject_HEAD_INIT(&PyType_Type)
        0,
        "term",
        sizeof(PyTerm),
        0,
        (destructor)PyTerm_dealloc,	/*tp_dealloc*/
        (printfunc)PyTerm_print,	/*tp_print*/
        (getattrfunc)PyTerm_getattr,	/*tp_getattr*/
        (setattrfunc)PyTerm_setattr,	/*tp_setattr*/
        (cmpfunc)PyTerm_compare,	/*tp_compare*/
        (reprfunc)PyTerm_repr,		/*tp_repr*/
        0,              /*tp_as_number*/
        0,              /*tp_as_sequence*/
        0,              /*tp_as_mapping*/
};
#line 208 "TBmodule.c.nw"
static PyObject *PyTerm_new(term *t);
static PyObject *PyTerm_new_list(term_list *l);

#line 220 "TBmodule.c.nw"
tkind name2kind(char *name)
{
  if(streq(name, "term"))
    return t_term;
  if(streq(name, "bool"))
    return t_bool;
  if(streq(name, "int"))
    return t_int;
  if(streq(name, "real"))
    return t_real;
  if(streq(name, "str"))
    return t_str;
  if(streq(name, "bstr"))
    return t_bstr;
  if(streq(name, "var"))
    return t_var;
  if(streq(name, "placeholder"))
    return t_placeholder;
  if(streq(name, "appl"))
    return t_appl;
  if(streq(name, "anno"))
    return t_anno;
  if(streq(name, "env"))
    return t_env;
  if(streq(name, "list"))
    return t_list;

  return -1;
}

#line 256 "TBmodule.c.nw"
static char *k2n[] = 
{
  "term", "bool", "int", "real", "str", "bstr", "var", 
  "placeholder", "appl", "anno", "env", "list"
};

const char *kind2name(int kind)
{
  static char buf[32];

  if(kind < 0 || kind > t_list) {
    sprintf(buf, "*illegal type: %d*", kind);
    return buf;
  }
  return k2n[kind];
}
#line 421 "TBmodule.c.nw"
static TBbool term_match(term *t, term *template, PyObject **L);

static TBbool list_match(term_list *l, term_list *template, PyObject **L)
{
  /*TBprintf(stdout, "list_match: %t matches %t?\n", template, l);*/
  /*PyObject_Print(L, stdout, 0);*/

  if(list_length(template) != list_length(l)) {
    Py_DECREF(*L);
    Py_INCREF(Py_None);
    *L = Py_None;
    return TBtrue;
  }

  while(*L != Py_None && template && l) {
    if(!term_match(first(l), first(template), L))
      return TBfalse;
    template = next(template);
    l = next(l);
  }
  if(*L && *L != Py_None && (template || l)) {
    /* One of the lists was longer than the other: match failed! */
    Py_DECREF(*L);
    Py_INCREF(Py_None);
    *L = Py_None;
    return TBtrue;
  }
  return TBtrue;
}
#line 280 "TBmodule.c.nw"
TBbool term_match(term *t, term *template, PyObject **L)
{
  PyObject *Obj = NULL;

  /*TBprintf(stdout, "term_match: %t matches %t?\n", t, template);*/

  /* Now we perform a preorder search for placeholders */
  if(is_placeholder(template)) {
    
#line 317 "TBmodule.c.nw"
    sym_idx sym = fun_sym(placeholder_type(template));
    switch(sym) {
	
#line 339 "TBmodule.c.nw"
case type_term:	
		Obj = PyTerm_new(t);
		break;
#line 320 "TBmodule.c.nw"
	
#line 345 "TBmodule.c.nw"
case type_list:	if(!is_list(t))
		  Obj = Py_None;
		else 
		  Obj = PyTerm_new_list(t);
		break;
#line 321 "TBmodule.c.nw"
	
#line 353 "TBmodule.c.nw"
case type_bool:	if(!is_bool(t))
		  Obj = Py_None;
		else
		  if(bool_val(t) == TBtrue)
		    Obj = PyInt_FromLong(1L);
		  else
		    Obj = Py_None;
		break;
#line 322 "TBmodule.c.nw"
	
#line 364 "TBmodule.c.nw"
case type_int:	if(!is_int(t))
		  Obj = Py_None;
		else
		  Obj = PyInt_FromLong(int_val(t));
		break;
#line 323 "TBmodule.c.nw"
	
#line 372 "TBmodule.c.nw"
case type_real:	if(!is_real(t))
		  Obj = Py_None;
		else
		  Obj = PyFloat_FromDouble(real_val(t));
		break;
#line 324 "TBmodule.c.nw"
	
#line 380 "TBmodule.c.nw"
case type_str:	if(!is_str(t))
		  Obj = Py_None;
		else
		  Obj = PyString_FromString(str_val(t));
		break;
#line 325 "TBmodule.c.nw"
	
#line 388 "TBmodule.c.nw"
case type_bstr:	if(!is_bstr(t))
		  Obj = Py_None;
		else
		  Obj = PyString_FromStringAndSize(bstr_val(t), bstr_len(t));
		break;
#line 326 "TBmodule.c.nw"
	
#line 396 "TBmodule.c.nw"
default:
		if(streq(get_txt(sym), "appl")) {
		  PyObject *Func, *Args;

		  if(!is_appl(t))
		    Obj = Py_None;
		  else {
		    Obj = PyTuple_New(2);
		    Func = PyString_FromString(get_txt(fun_sym(t)));
		    Args = PyTerm_new(fun_args(t));
		    PyTuple_SetItem(Obj, 0, Func);
		    PyTuple_SetItem(Obj, 1, Args);
		  }
		} else {
		  PyErr_SetString(TBError, "not implemented yet!");
                  return TBfalse;
                }
#line 327 "TBmodule.c.nw"
    }
    if(Obj == Py_None)
      *L = Py_None;
    else
      if(Obj)
        PyList_Append(*L, Obj);
      else
        return TBfalse;
    return TBtrue;
#line 289 "TBmodule.c.nw"
    if(Obj == Py_None) {
      /* match failed */
      Py_DECREF(*L);
      Py_INCREF(Py_None);
      *L = Py_None;
      return TBtrue;
    }
    if(Obj) {
      /* match succeeded */
      PyList_Append(*L, Obj);
      return TBtrue;
    }
    /* fall through: error occured */
  } else if(is_appl(template)) {
    return list_match(fun_args(t), fun_args(template), L);
  } else if(is_list(template)) {
    return list_match(t, template, L);
  } else if(term_equal(t, template)) {
    return TBtrue;
  }
  PyErr_SetString(TBError, "illegal term in matching");
  return TBfalse;
}
#line 473 "TBmodule.c.nw"
static PyObject *PyTerm_new(term *t)
{
  PyTerm *T;
  T = PyObject_NEW(PyTerm, &PyTerm_Type);

  if(T != NULL) {
    T->t_attr = NULL;
    TBprotect(&T->t);
    T->t = t;

    _Py_NewReference(T);
  }
  return (PyObject *)T;
}
#line 493 "TBmodule.c.nw"
static PyObject *PyTerm_new_list(term_list *l)
{
  int idx;
  PyObject *L, *T;

  L = PyList_New(list_length(l));
  if(!L)
    return L;

  idx = 0;
  while(l) {
    T = PyTerm_new(first(l));
    if(!T)
      return T;
    PyList_SetItem(L, idx, T);
    idx++;
    l = next(l);
  }
  
  return L;
}
#line 521 "TBmodule.c.nw"
static int PyTerm_print(PyTerm *T, FILE *f, int flags)
{
  TBprintf(f, "<term, %t", T->t);

  if(T->t_attr) {
    fprintf(f, ", ");
    PyObject_Print(T->t_attr, f, flags);
  }
  fprintf(f, ">");

  return 0;
}
#line 539 "TBmodule.c.nw"
static void PyTerm_dealloc(PyTerm *T)
{
  TBunprotect(&T->t);
  PyMem_DEL(T);
}
#line 550 "TBmodule.c.nw"
static PyObject *PyTerm_getattr(PyTerm *T, char *name)
{
  static char error[64];
  PyObject *v = NULL;

  int kind = name2kind(name);

  /*TBprintf(stdout, "getattr: %t, %s\n", T->t, name);*/

  if(kind != -1 && tkind(T->t) != kind) {
    sprintf(error, "term is not of type %s", name);
    PyErr_SetString(TBError, error);
    return NULL;
  }
    
  switch(kind) {
    case t_bool:	if(bool_val(T->t))
			  return Py_BuildValue("i", bool_val(T->t));
			Py_INCREF(Py_None);
			return Py_None;
    case t_int:		return Py_BuildValue("i", int_val(T->t));
    case t_real:	return Py_BuildValue("d", real_val(T->t));
    case t_str:		return Py_BuildValue("s", str_val(T->t));

    case t_placeholder:	return PyTerm_new(placeholder_type(T->t));

    case t_appl:	return Py_BuildValue("(sO)", get_txt(fun_sym(T->t)), 
					PyTerm_new(fun_args(T->t)));

    case t_list:	return PyTerm_new_list(T->t);

    case t_bstr:	return Py_BuildValue("s#", bstr_val(T->t), bstr_len(T->t));

    case t_var:
    case t_anno:
    case t_env: sprintf(error, "term type %s not implemented yet", name);
		PyErr_SetString(TBError, error);
		return NULL;
    default:	if(streq(name, "__dict__")) {
		  v = T->t_attr;
                  if (v == NULL)
                    v = Py_None;
		} else {
		  v = Py_FindMethod(TermMethods, (PyObject *)T, name);
		  if(v)
		    return v;
		}
		if(!v) {
		  if (T->t_attr != NULL)
                    v =  PyDict_GetItemString(T->t_attr, name);
		}
  
		if (v != NULL)
                  Py_INCREF(v);
		else
		  PyErr_SetString(TBError, "unknown attribute");
		return v;
  }
}
#line 615 "TBmodule.c.nw"
int PyTerm_setattr(PyTerm *T, char *name, PyObject *V)
{
  static char error[64];
  int i, kind;
  double r;
  char *s;
  PyTerm T2;
  PyObject L;

  if(V == NULL) {
    PyErr_SetString(TBError, "Cannot unset term fields");
    return -1;
  }

  kind = name2kind(name);
  
  if(kind != -1 && tkind(T->t) != kind) {
    sprintf(error, "term is not of type %s", name);
    PyErr_SetString(TBError, error);
    return -1;
  }

  switch(kind) {
    case t_bool:	if(!PyArg_Parse(V, "i", &i))
			  return -1;
			if(i)
			  bool_val(T->t) = TBtrue;
			else
			  bool_val(T->t) = TBfalse;
			break;

    case t_int:		if(!PyArg_Parse(V, "i", &i))
			  return -1;
			int_val(T->t) = i;
			break;

    case t_real:	if(!PyArg_Parse(V, "d", &r))
			  return -1;
			real_val(T->t) = r;
			break;

    case t_str:		if(!PyArg_Parse(V, "s", &s))
			  return -1;
			str_val(T->t) = s;
			break;

    case t_bstr:	if(!PyArg_Parse(V, "s#", &s, &i))
			  return -1;
			bstr_val(T->t) = s;
			bstr_len(T->t) = i;
			break;

    case t_appl:
    case t_list:
    case t_placeholder:	
    case t_var:
    case t_anno:
    case t_env:	sprintf(error, "setting the %s field of a term is not implemented yet", name);
		PyErr_SetString(TBError, error);
		return -1;
    default:	/* Term dictionary object */
	        if (T->t_attr == NULL) {
                  T->t_attr = PyDict_New();
                  if (T->t_attr == NULL)
                        return -1;
		}
		if (V == NULL) {
		  int rv = PyDict_DelItemString(T->t_attr, name);
		  if (rv < 0)
		    PyErr_SetString(PyExc_AttributeError,
                                "delete non-existing menu object attribute");
		  return rv;
		} else
                  return PyDict_SetItemString(T->t_attr, name, V);
  }
  return 0;
}
#line 698 "TBmodule.c.nw"
int PyTerm_compare(PyTerm *T1, PyTerm *T2)
{
  if(term_equal(T1->t, T2->t))
    return PyObject_Compare(T1->t_attr, T2->t_attr);

  return -1;
}
#line 711 "TBmodule.c.nw"
PyObject *PyTerm_repr(PyTerm *T)
{
  char *ptr = TBsprintf("%t", T->t);
  return PyString_FromString(ptr);
}
#line 755 "TBmodule.c.nw"
static PyObject *pythonify_list(term_list *t);
#line 773 "TBmodule.c.nw"
static PyObject *pythonify_term(term *t)
{
  PyObject *ex_val;

  switch(tkind(t)) {
    case t_bool:	if(bool_val(t) == TBtrue)
			  return PyInt_FromLong(1L);
			Py_INCREF(Py_None);
			return Py_None;

    case t_int:		return PyInt_FromLong((long)int_val(t));

    case t_real:	return PyFloat_FromDouble(real_val(t));

    case t_str:		return PyString_FromString(str_val(t));

    case t_bstr:	return PyString_FromStringAndSize(bstr_val(t), bstr_len(t));

    case t_list:	return pythonify_list(t);

    default:		return PyString_FromString(TBsprintf("%t", t));
  }
}
#line 802 "TBmodule.c.nw"
static PyObject *pythonify_list(term_list *t)
{
  PyObject *L;
  int i, len;

  len = list_length(t);
  L   = PyList_New(len);
  for(i=0; i<len; i++, t = next(t)) {
    PyList_SetItem(L, i, pythonify_term(first(t)));
  }
  return L;
}

#line 741 "TBmodule.c.nw"
static PyObject *Term_simplify(PyObject *self, PyObject *args)
{
  if(!PyArg_ParseTuple(args, ""))
    return NULL;

  /*TBprintf(stdout, "simplifying term %t\n", ((PyTerm *)self)->t);*/
  return pythonify_term(((PyTerm *)self)->t);    
}
#line 864 "TBmodule.c.nw"
static PyObject *Term_match(PyObject *self, PyObject *args)
{
  PyObject *template, *result;
  term *tmpl;
#line 873 "TBmodule.c.nw"
  if(PyTuple_Size(args) != 1) {
    PyErr_SetString(TBError, "term.match takes exactly 1 argument");
    return NULL;
  }

  template = PyTuple_GetItem(args, 0);
  if(!PyString_Check(template)) {
    PyErr_SetString(TBError, "argument of term.match must be a string object");
    return NULL;
  }

  tmpl = TBmake(PyString_AsString(template));
#line 889 "TBmodule.c.nw"
  result = PyList_New(0);
  if(!term_match(((PyTerm *)self)->t, tmpl, &result)) {
    Py_DECREF(result);
    return NULL;
  }
  return result;
}
#line 824 "TBmodule.c.nw"
static PyObject *Term_matchTerm(PyObject *self, PyObject *args)
{
  PyObject *template, *result;
#line 832 "TBmodule.c.nw"
  if(PyTuple_Size(args) != 1) {
    PyErr_SetString(TBError, "term.match_term takes exactly 1 argument");
    return NULL;
  }

  template = PyTuple_GetItem(args, 0);
  if(!PyTerm_Check(template)) {
    PyErr_SetString(TBError, "argument of term.match_term must be a term object");
    return NULL;
  }
#line 846 "TBmodule.c.nw"
  result = PyList_New(0);
  if(!term_match(((PyTerm *)self)->t, ((PyTerm *)template)->t, &result)) {
    Py_DECREF(result);
    return NULL;
  }
  return result;
}
#line 904 "TBmodule.c.nw"
static PyObject *Term_kind(PyObject *self, PyObject *args)
{
  char *mykind;

  if(!PyArg_ParseTuple(args, ""))
    return NULL;

  switch(tkind(((PyTerm *)self)->t)) {
    case t_term:	mykind = "term"; break;
    case t_bool:	mykind = "bool"; break;
    case t_int:		mykind = "int";  break;
    case t_real:	mykind = "real"; break;
    case t_str:		mykind = "str";  break;
    case t_bstr:	mykind = "bstr"; break;
    case t_var:		mykind = "var";  break;
    case t_placeholder: mykind = "placeholder"; break;
    case t_appl:	mykind = "appl"; break;
    case t_anno:	mykind = "anno"; break;
    case t_env:		mykind = "env";  break;
    case t_list:	mykind = "list"; break;
    default: mykind = "*illegal*";
  }
  return PyString_FromString(mykind);
}

#line 1049 "TBmodule.c.nw"
void hyphens2underscores(char *name, char *buf)
{
  int i;

  for(i=0; i<MAX_FUN_LEN && name[i]; i++)
    if(name[i] == '-')
      buf[i] = '_';
    else
      buf[i] = name[i];

  buf[i] = '\0';
}
#line 970 "TBmodule.c.nw"
term *call_python(int cid, char *func, term_list *args)
{
  static char fbuf[MAX_FUN_LEN];
  PyObject *dict, *py_func, *py_args, *py_result;
  PyFrameObject *Frame;
  PyObject *LocalTraceFunc;
  term *result;
  int i, len;


  hyphens2underscores(func, fbuf);

/*
  if(debugCid >= 0) {
    LocalTraceFunc = PyDict_GetItemString(Dict, "_local_trace_func");
    Frame = (PyFrameObject *)PyEval_GetFrame();
    while(Frame) {
      Py_INCREF(LocalTraceFunc);
      Frame->f_trace = LocalTraceFunc;
      Frame = Frame->f_back;
    }
  }
*/

  dict = PyModule_GetDict(Modules[cid]);
  py_func = PyDict_GetItemString(dict, fbuf);
  if(!py_func) {
    fprintf(stderr, "couldn't find func %s in module %s\n", fbuf, Modules[cid]);
    return NULL;
  }

  if(trace_mode & TRACE_CALLS) {
    PyObject *Name = PyDict_GetItemString(dict, "__name__");
    char *name = PyString_AsString(Name);
    TBprintf(stderr, "calling python function %s in module %s with args %l\n", 
		fbuf, name, args);
  }

  /* Building argument tuple */
  len = list_length(args);
  py_args = PyTuple_New(len+1);
  PyTuple_SetItem(py_args, 0, PyInt_FromLong(cid));
  if(simplify_all) {
    for(i=0; i<len; i++, args = next(args))
      PyTuple_SetItem(py_args, i+1, pythonify_term(first(args)));
  } else {
    for(i=0; i<len; i++, args = next(args))
      PyTuple_SetItem(py_args, i+1, PyTerm_new(first(args)));
  }
  /*PyObject_Print(py_args, stderr, 0);*/

  /* Calling the actual python code */
  py_result = PyEval_CallObject(py_func, py_args);
  Py_DECREF(py_args);

  if(!py_result) {
    PyErr_Print();
    PyErr_Clear();
  } else {
    if(py_result == Py_None) {
      Py_DECREF(py_result);
      return NULL;
    }
    if(!PyTerm_Check(py_result)) {
      fprintf(stderr, "return value of function %s in module %s was" \
		 " not a term:\n", fbuf, Modules[cid]);
      PyObject_Print(py_result, stderr, 0);
      Py_DECREF(py_result);
    } else {
      result = ((PyTerm *)py_result)->t;
      Py_DECREF(py_result);
      return result;
    }
  }
  return NULL;
}

#line 941 "TBmodule.c.nw"
static term *toolbus_handler(int cid, term *t)
{
  char *func;
  term_list *args;
  term *arg;
  term *result = NULL;

  /*TBprintf(stderr, "toolbus_handler: %d, %t\n", cid, t);*/

  if(TB_match(t, "rec-do(<appl>)", &func, &args)) {
    call_python(cid, func, args);
  } else if(TB_match(t, "rec-eval(<appl>)", &func, &args)) {
    result = call_python(cid, func, args);
  } else if(TB_match(t, "rec-ack-event(<term>)", &arg)) {
    result = call_python(cid, "rec_ack_event", mk_list1(arg));
  } else if(TB_match(t, "rec-monitor(<appl>)", 
		TB_make("[<str>, <list>]", &func, &args))) {
    result = call_python(cid, "rec_monitor", args);
  } else if(TB_match(t, "rec-terminate(<term>)", &arg)) {
    result = call_python(cid, "rec_terminate", mk_list1(arg));
  } else {
    PyErr_SetString(TBError, TBsprintf("cannot handle term: %t", t));
  }
  return result;
}
#line 1121 "TBmodule.c.nw"
TBbool check_python_func(int cid, char *func)
{
  static char fbuf[MAX_FUN_LEN];
  PyObject *dict, *py_func, *py_args, *py_result;
  int i, len;

  /*TBprintf(stderr, "check_python_func: %d,%s\n", cid, func);*/
  hyphens2underscores(func, fbuf);

  dict = PyModule_GetDict(Modules[cid]);
  /*PyObject_Print(dict, stderr, 0);*/
  py_func = PyDict_GetItemString(dict, fbuf);
  if(py_func && PyCallable_Check(py_func))
    return TBtrue;

  return TBfalse;
}

#line 1096 "TBmodule.c.nw"
TBbool signature_ok(int cid, term *func)
{
  char *fun;
  term *arg;
  term_list *args;
  term *t;

  /*TBprintf(stderr, "checking signature %t for tool %d\n", func, cid);*/
  if(TB_match(func, "rec-do(<term>,<appl>)", &t, &fun, &args)) {
    return check_python_func(cid, fun);
  } else if(TB_match(func, "rec-eval(<term>,<appl>)", &t, &fun)) {
    return check_python_func(cid, fun);
  } else if(TB_match(func, "rec-ack-event(<term>,<term>)", &t, &arg)) {
    return check_python_func(cid, "rec_ack_event");
  } else if(TB_match(func, "rec-monitor(<term>, <appl>)", &t, &fun, &args)) {
    return check_python_func(cid, "rec_monitor");
  } else if(TB_match(func, "rec-terminate(<term>, <term>)", &t, &arg)) {
    return check_python_func(cid, "rec_terminate");
  }
  PyErr_SetString(TBError, TBsprintf("cannot handle term: %t", func));
  return TBfalse;
}

#line 1074 "TBmodule.c.nw"
static term *toolbus_sigchk(int cid, term *l)
{
  term_list *erroneous = NULL;

  /*TBprintf(stderr, "toolbus_sigchck: %d, %t\n", cid, l);*/

  for( ; l; l=next(l)) {
    if(!signature_ok(cid, first(l)))
      erroneous = list_concat_term(erroneous, first(l));
  }
  return erroneous;
}
#line 1144 "TBmodule.c.nw"
#ifndef NO_TK
void tcl_handler(ClientData CID, int mask)
{
  int cid = (int)CID;

  /*fprintf(stderr, "tcl_handler called: %d\n", cid);*/
  TB_handle_one(cid);
}
#endif

#line 1280 "TBmodule.c.nw"
char *get_one_arg(PyObject *Args, int i)
{
  PyObject *Arg;
  char *arg;

  if(PyList_Size(Args) <= i) {
    PyErr_SetString(TBError, "expected another argument");
    return NULL;
  }
  Arg = PyList_GetItem(Args, i);
  if(!PyString_Check(Arg)) {
    PyErr_SetString(TBError, "argument list must be a list of strings");
    return NULL;
  }
  arg = PyString_AsString(Arg);
  return arg;
}

#line 1194 "TBmodule.c.nw"
static PyObject *TBP_parseArgs(PyObject *self, PyObject *args)
{
  PyObject *Args, *ScriptArgs = NULL, *Details;
  PyObject *Mod;
  char *tool = NULL;
  char *host = NULL;
  char *details = NULL;
  int port = 8999;
  TBbool vb = TBfalse;
  int tid = -1;
  int len, i, cid;

  if(!PyArg_ParseTuple(args, "OO", &Args, &Mod))
    return NULL;
  
  if(!PyList_Check(Args)) {
    PyErr_SetString(TBError, "first argument must be a list of options");
    return NULL;
  }

  if(!PyModule_Check(Mod)) {
    PyErr_SetString(TBError, "second argument must be a module");
    return NULL;
  }

  len = PyList_Size(Args);
  for(i=1; i<len; i++) {
    char *arg = get_one_arg(Args, i);
    if(!arg)
      return NULL;
    if(streq(arg, "-TB_TOOL_NAME")) {
      tool = get_one_arg(Args, ++i);
    } else if(streq(arg, "-TB_HOST")) {
      host = get_one_arg(Args, ++i);
    } else if(streq(arg, "-TB_PORT")) {
      port = atoi(get_one_arg(Args, ++i));
    } else if(streq(arg, "-TB_TOOL_ID")) {
      tid = atoi(get_one_arg(Args, ++i));
    } else if(streq(arg, "-TB_VERBOSE")) {
      vb = TBtrue;
    } else if(streq(arg, "-details")) {
      details = get_one_arg(Args, ++i);
    } else if(streq(arg, "-trace-calls")) {
      trace_mode |= TRACE_CALLS;
    } else if(streq(arg, "-script-args")) {
      ScriptArgs = PyList_GetSlice(Args, i+1, len);
      Py_INCREF(ScriptArgs);
      i = len-1;
    } 
  }
  /*fprintf(stdout, "calling TB_newConnection: %s,%s,%d\n", 
		tool, host ? host : "<null>", port);
  fprintf(stdout, "  tid = %d, verbose=%d, details=%s\n", 
		tid, vb, details ? details : "<null>");
  */

  cid = TB_newConnection(tool, host, port, toolbus_handler, toolbus_sigchk);
  if(cid < 0) {
    PyErr_SetString(TBError, "couldn't open a new connection");
    return NULL;
  }

  Py_INCREF(Mod);
  Modules[cid] = Mod;

  TB_setTid(cid, tid);
  TB_setVerbose(cid, vb);

  if(details) {
    Details = PyString_FromString(details);
  } else {
    Py_INCREF(Py_None);
    Details = Py_None;
  }
  PyDict_SetItemString(Dict, "details", Details);
  if(!ScriptArgs) {
    Py_INCREF(Py_None);
    ScriptArgs = Py_None;
  }
  PyDict_SetItemString(Dict, "argv", ScriptArgs);

  return PyInt_FromLong((long)cid);
}
#line 1303 "TBmodule.c.nw"
static PyObject *TBP_newConnection(PyObject *self, PyObject *args)
{
  char *tool, *host;
  int port;
  PyObject *Mod;
  int cid;

  if(!PyArg_ParseTuple(args, "sziO", &tool, &host, &port, &Mod))
    return NULL;

  fprintf(stderr, "callling TB_newConnection: %s,%s,%d\n", 
		tool, host ? host : "<null>", port);
  cid = TB_newConnection(tool,host,port, toolbus_handler, toolbus_sigchk);
  if(cid < 0) {
    PyErr_SetString(TBError, "couldn't open a new connection");
    return NULL;
  }

  Modules[cid] = Mod;
  
  if(cid < 0) {
    PyErr_SetString(TBError, "Maximum number of connections reached");
    return NULL;
  }

  return PyInt_FromLong((long)cid);
}
#line 1336 "TBmodule.c.nw"
static PyObject *TBP_connect(PyObject *self, PyObject *args)
{
  int result, cid;

  if(!PyArg_ParseTuple(args, "i", &cid))
    return NULL;

  if(!TB_validConnection(cid)) {
    PyErr_SetString(TBError, "Invalid connection number");
    return NULL;
  }

  /*fprintf(stderr, "calling TB_connect: %d\n", cid);*/
  result = TB_connect(cid);
  if(result < 0) {
    PyErr_SetFromErrno(TBError);
    return NULL;
  }


  lastCid = cid;

#ifndef NO_TK
  if(enableTk) {
    Tcl_File f = Tcl_GetFile((ClientData)TB_getSocket(cid), TCL_UNIX_FD);
    Tcl_CreateFileHandler(f, TCL_READABLE, tcl_handler, (ClientData)cid);
  }
#endif

  Py_INCREF(Py_None);
  return Py_None;
}

#line 1414 "TBmodule.c.nw"
static TBbool term_make(term *template, PyObject *args, int *idx, term **t);

static TBbool list_make(term_list *l, PyObject *args, int *idx, term **t)
{
  term_list *cur = l;
  term *trm;

  while(cur) {
    if(!term_make(first(cur), args, idx, &trm))
      return TBfalse;
    first(cur) = trm;
    cur = next(cur);
  }
  *t = l;
  return TBtrue;
}
#line 1436 "TBmodule.c.nw"
static TBbool make_appl(char *str, PyObject *l, term **t);
static TBbool make_list(PyObject *l, term **t);

static TBbool term_make(term *template, PyObject *args, int *idx, term **t)
{
  term *trm;

  /* Here, we only perform a preorder search for placeholders */
  if(is_placeholder(template)) {
    
#line 1464 "TBmodule.c.nw"
    int sym;
    TBbool b;
    int i;
    double r;
    char *s;
    PyObject *T, *L;

    PyObject *arg = PyTuple_GetItem(args, *idx);
    (*idx)++;

    sym = fun_sym(placeholder_type(template));
    switch(sym) {
	
#line 1489 "TBmodule.c.nw"
case type_term:	if(!PyTerm_Check(arg)) {
		  PyErr_SetString(TBError, "<term> needs a PyTerm object");
		  return TBfalse;
		}
		*t = ((PyTerm *)arg)->t;
		break;
		
#line 1477 "TBmodule.c.nw"
	
#line 1499 "TBmodule.c.nw"
case type_list:	return make_list(arg, t);
		break;
#line 1478 "TBmodule.c.nw"
	
#line 1504 "TBmodule.c.nw"
case type_bool:	if(arg == Py_None)
		  *t = mk_bool(TBfalse);
		else
		  *t = mk_bool(TBtrue);
		break;
#line 1479 "TBmodule.c.nw"
	
#line 1512 "TBmodule.c.nw"
case type_int:	if(!PyInt_Check(arg)) {
		  PyErr_SetString(TBError, "not an integer");
		  return TBfalse;
		}
		i = (int)PyInt_AsLong(arg);
		*t = mk_int(i);
		break;
#line 1480 "TBmodule.c.nw"
	
#line 1522 "TBmodule.c.nw"
case type_real:	if(!PyFloat_Check(arg)) {
		  PyErr_SetString(TBError, "not a float");
		  return TBfalse;
		}
		r = PyFloat_AsDouble(arg);
		*t = mk_real(r);
		break;
#line 1481 "TBmodule.c.nw"
	
#line 1532 "TBmodule.c.nw"
case type_str:	if(!PyString_Check(arg)) {
		  PyErr_SetString(TBError, "not a string");
		  return TBfalse;
		}
		s = PyString_AsString(arg);
		*t = mk_str(s);
		break;
#line 1482 "TBmodule.c.nw"
	
#line 1542 "TBmodule.c.nw"
case type_bstr:	if(!PyString_Check(arg)) {
		  PyErr_SetString(TBError, "not a string");
		  return TBfalse;
		}
		s = PyString_AsString(arg);
		i = PyString_Size(arg);
		*t = mk_bstr(s, i);
		break;
#line 1483 "TBmodule.c.nw"
	
#line 1553 "TBmodule.c.nw"
default:	/*fprintf(stderr, "default: %s\n", get_txt(sym));*/
		if(streq(get_txt(sym), "appl")) {
		  if(!PyArg_ParseTuple(arg, "sO", &s, &L))
		    return TBfalse;
		  return make_appl(s, L, t);
		} else {
		  PyErr_SetString(TBError, "not implemented yet!");
                  return TBfalse;
                }
#line 1484 "TBmodule.c.nw"
    }
    return TBtrue;
#line 1446 "TBmodule.c.nw"
    return TBtrue;
  } else if(is_appl(template)) {
    if(!list_make(fun_args(template), args, idx, &trm))
      return TBfalse;
    fun_args(template) = trm;
    *t = template;
    return TBtrue;
  } else if(is_list(template)) {
    return list_make(template, args, idx, t);
  }
  *t = template;
  return TBtrue;
}
#line 1574 "TBmodule.c.nw"
static TBbool make_appl(char *str, PyObject *l, term **t)
{
  if(PyList_Check(l)) {
    term_list *args = NULL;
    int i,len = PyList_Size(l);
    
    for(i=0; i<len; i++) {
      PyObject *el = PyList_GetItem(l, i);
      if(!PyTerm_Check(el)) {
        PyErr_SetString(TBError, "second argument of <appl> contains non-term object.");
	return TBfalse;
      }
      args = list_concat_term(args, ((PyTerm *)el)->t);
    }
    *t = mk_appl(TBlookup(str), args);
    return TBtrue;
  }
  if(PyTerm_Check(l) && is_list(((PyTerm *)l)->t)) {
    *t = mk_appl(TBlookup(str), ((PyTerm *)l)->t);
    return TBtrue;
  }
  PyErr_SetString(TBError, "second argument of <appl> must be a Python or ToolBus list!");
  return TBfalse;
}
#line 1606 "TBmodule.c.nw"
static TBbool make_list(PyObject *l, term **t)
{
  if(PyList_Check(l)) {
    term_list *lst = NULL;
    int i,len = PyList_Size(l);
    
    for(i=0; i<len; i++) {
      PyObject *el = PyList_GetItem(l, i);
      if(!PyTerm_Check(el)) {
        PyErr_SetString(TBError, "argument of <list> contains non-term object.");
	return TBfalse;
      }
      lst = list_concat_term(lst, ((PyTerm *)el)->t);
    }
    *t = lst;
    return TBtrue;
  }
  if(PyTerm_Check(l) && is_list(((PyTerm *)l)->t)) {
    *t = ((PyTerm *)l)->t;
    return TBtrue;
  }
  PyErr_SetString(TBError, "argument of <list> must be a Python or ToolBus list!");
  return TBfalse;
}

#line 1380 "TBmodule.c.nw"
static PyObject *TBP_make(PyObject *self, PyObject *args)
{
  term_list *l;
  term *t;
  PyObject *Fmt;
  char *fmt;
  int idx;

  int len = PyTuple_Size(args);
  if(len < 1) {
    PyErr_SetString(PyExc_SyntaxError, "Usage: TB.make(format, ...)");
    return NULL;
  }

  Fmt = PyTuple_GetItem(args, 0);
  if(!Fmt)
    return NULL;

  if(!PyArg_Parse(Fmt, "s", &fmt))
    return NULL;

  t = TBmake(fmt);
  
  idx = 1;
  if(term_make(t, args, &idx, &t) == TBfalse)
    return NULL;

  return PyTerm_new(t);
}
#line 1638 "TBmodule.c.nw"
static PyObject *TBP_send(PyObject *self, PyObject *args)
{
  int cid, result;
  PyObject *T;

  if(!PyArg_ParseTuple(args, "iO", &cid, &T))
    return NULL;

  if(!PyTerm_Check(T)) {
    PyErr_SetString(TBError, "not a term object");
    return NULL;
  }

  result = TB_send(cid, ((PyTerm *)T)->t);
  if(result < 0) {
    PyErr_SetFromErrno(TBError);
    return NULL;
  }

  Py_INCREF(Py_None);
  return Py_None;
}


#line 1668 "TBmodule.c.nw"
PyObject *TBP_eventloop(PyObject *self, PyObject *args)
{
  if(!PyArg_ParseTuple(args, ""))
    return NULL;

#ifndef NO_TK
  if(enableTk) {
    PyErr_SetString(TBError, "Use the Tk eventloop after enabling Tk!");
    return NULL;
  }
#endif

  TB_eventloop();

  Py_INCREF(Py_None);
  return Py_None;
}
#line 1696 "TBmodule.c.nw"
PyObject *TBP_enableTk(PyObject *self, PyObject *args)
{
  int i;

  if(!PyArg_ParseTuple(args, ""))
    return NULL;

#ifdef NO_TK
  PyErr_SetString(TBError, "Tk support not built in!");
  return NULL;
#else 
  enableTk = TBtrue;
  for(i=0; i<MAX_CONNECTIONS; i++) {
    if(TB_validConnection(i)) {
      Tcl_File f = Tcl_GetFile((ClientData)TB_getSocket(i), TCL_UNIX_FD);
      Tcl_CreateFileHandler(f, TCL_READABLE, tcl_handler, (ClientData)i);
    }
  }

  Py_INCREF(Py_None);
  return Py_None;
#endif
}
#line 1728 "TBmodule.c.nw"
PyObject *TBP_enableDebugging(PyObject *self, PyObject *args)
{
#ifdef USE_TIDE
  PyObject *GlobalTraceFunc;
  PyFrameObject *Frame;

  if(!PyArg_ParseTuple(args, "i", &debugCid))
    return NULL;

  if(lastCid < 0) {
    PyErr_SetString(TBError, "not connected to any ToolBus");
    return NULL;
  }

  fprintf(stderr, "starting debuggin via connection %d\n", debugCid);
  if(!TB_validConnection(debugCid)) {
    PyErr_SetString(TBError, "invalid debugging connection");
    return NULL;
  }

  if(TB_getSocket(debugCid) >= 0) {
    PyErr_SetString(TBError, "debbugger connection already occupied");
    return NULL;
  }

  TB_setHandler(debugCid, debug_nub_handler);
  TB_setSigChecker(debugCid, debug_nub_check_in_sign);
  if(TB_connect(debugCid) < 0) {
    PyErr_SetString(TBError, "debug connection attempt failed");
    return NULL;
  }

  /* We need to get TBP_traceFunction as a function object */
  GlobalTraceFunc = PyDict_GetItemString(Dict, "_trace_func");
  assert(GlobalTraceFunc);

  Py_INCREF(GlobalTraceFunc);
  _PySys_TraceFunc = GlobalTraceFunc;

  fprintf(stderr, "debugging enabled!\n");

  Py_INCREF(Py_None);
  return Py_None; 
#else
  PyErr_SetString(TBError, "TIDE support not enabled");
  return NULL;
#endif
}

#line 46 "TBmodule.c.nw"
#ifdef USE_TIDE
#line 1169 "TBmodule.c.nw"
void line_trace(char *file, int line)
{
  switch(exec_state) {
    case ES_SINGLE_STEP:
			exec_state = ES_STOPPED;
    case ES_STOPPED:	CPE = TB_make("cpe([[\"*\",\"line\",<str>,<int>]])", file,line);
			TB_send(debugCid, TB_make("snd-event(<term>)", CPE));
			stopped_eventloop();
			break;

    case ES_RUNNING:	/* Check for breakpoints comes here */
			break;
    default:		assert(0);
  }
  TBprintf(stdout, "continuing execution from %t\n", CPE);
}
#line 1782 "TBmodule.c.nw"
PyObject *TBP_traceFunction(PyObject *self, PyObject *args)
{
  PyFrameObject *Frame;
  char *event;
  PyObject *Arg;
  int lineno;
  char *filename = NULL;

  if(!PyArg_ParseTuple(args, "OsO", &Frame, &event, &Arg))
    return NULL;

  fprintf(stderr, "- TBP_traceFunction called:\n");
  fprintf(stderr, "frame: ");
  PyObject_Print((PyObject *)Frame, stderr, 0);
  fprintf(stderr, "\nevent: %s\narg: ", event);
  PyObject_Print(Arg, stderr, 0);
  fprintf(stderr, "\n");

  if(Frame->f_code)
    filename = PyString_AsString(Frame->f_code->co_filename);
  lineno = Frame->f_lineno;

  if(streq(event, "line"))
    line_trace(filename, lineno);

  Py_INCREF(LocalTraceFunc);
  return LocalTraceFunc;
}
#line 1816 "TBmodule.c.nw"
PyObject *TBP_localTraceFunction(PyObject *self, PyObject *args)
{
  PyFrameObject *Frame;
  char *event;
  PyObject *Arg;
  int lineno;
  char *filename = NULL;

  if(!PyArg_ParseTuple(args, "OsO", &Frame, &event, &Arg))
    return NULL;

  fprintf(stdout, "- TBP_localTraceFunction called:\n");
  fprintf(stdout, "frame: ");
  PyObject_Print((PyObject *)Frame, stdout, 0);
  fprintf(stdout, "\nevent: %s\narg: ", event);
  PyObject_Print(Arg, stdout, 0);
  fprintf(stdout, "\n");

  if(Frame->f_code)
    filename = PyString_AsString(Frame->f_code->co_filename);
  lineno = Frame->f_lineno;

  if(streq(event, "line"))
    line_trace(filename, lineno);

  Py_INCREF(LocalTraceFunc);
  return LocalTraceFunc;
}
#line 50 "TBmodule.c.nw"
#endif

#line 1851 "TBmodule.c.nw"
static PyMethodDef TermMethods[] = {
  { "simplify",		Term_simplify,		1},
  { "match",		Term_match,		1},
  { "matchTerm",	Term_matchTerm,		1},
  { "kind",		Term_kind,		1},
  { NULL, NULL} /* Sentinel */
};
#line 1864 "TBmodule.c.nw"
static PyMethodDef TBMethods[] = {
  { "parseArgs",	TBP_parseArgs,		1},
  { "newConnection",	TBP_newConnection,	1},
  { "connect",		TBP_connect,		1},
  { "make",		TBP_make,		1},
  { "send",		TBP_send,		1},
  { "eventloop",	TBP_eventloop,		1},
  { "enableTk",		TBP_enableTk,		1},
  { "enableDebugging",	TBP_enableDebugging,	1},
#ifdef USE_TIDE
  { "_trace_func",	TBP_traceFunction,	1},
  { "_local_trace_func",TBP_localTraceFunction,	1},
#endif
  { NULL,   NULL} /* Sentinel */
};
#line 1886 "TBmodule.c.nw"
void initTB()
{
  PyObject *m;

  /*fprintf(stderr, "initTB called!\n");*/
  m = Py_InitModule("TB", TBMethods);
  Dict = PyModule_GetDict(m);
  TBError = PyString_FromString("TB.error");
  PyDict_SetItemString(Dict, "error", TBError);

  TB_init();

#ifdef USE_TIDE
  LocalTraceFunc = PyDict_GetItemString(Dict, "_local_trace_func");
  assert(LocalTraceFunc);
  TBprotect(&CPE);
#endif
}

#line 1930 "TBmodule.c.nw"
void stopped_eventloop()
{
  exec_state = ES_STOPPED;
  while(exec_state == ES_STOPPED) {
    TB_handle_one(debugCid);
  }
}

#line 1944 "TBmodule.c.nw"
term *get_info(int cid)
{
  term_list *info, *tb_list;
  term *id;
  static char path[_POSIX_PATH_MAX];

  fprintf(stderr, "get_info(%d)\n", cid);

  getcwd(path, _POSIX_PATH_MAX);
  id = TB_make("tb(<str>,<int>,<str>)", 
		TB_getHost(lastCid), TB_getPort(lastCid), path); 
  info = TB_make("[[\"type\",\"nub\"]," \
                 "[\"language\",\"Python\"]," \
		 "[\"toolbus\",<term>]," \
		 "[\"tid\",<int>]," \
		 "[\"name\",<str>]]" , 
		 id, TB_getTid(lastCid), TB_getTool(lastCid));
  tb_list = TB_getConnections();

  while(tb_list) {
    int cid, port, tid, sock;
    char *host;
    int r = TB_match(first(tb_list), "[<int>,<str>,<int>,<int>,<int>]",
	&cid, &host, &port, &tid, &sock);
    assert(r);
    host = host ? host : "";
    info = list_concat_term(info, TB_make("[\"toolbus\",tb(<str>,<int>)]",
					host, port));
    tb_list = next(tb_list);
  }
  TBprintf(stderr, "end of get_info: %t\n", info);
  return TB_make("snd-value(info(<term>))", info);
}
#line 1983 "TBmodule.c.nw"
term *get_cpe(int cid)
{
  TBprintf(stderr, "get_cpe, returning: cpe(%t)\n", CPE);
  return TB_make("snd-value(cpe(<term>))", CPE);
}
#line 1995 "TBmodule.c.nw"
void stop(int cid, term *who, term *when)
{
  /* Not implemented yet */
  TBprintf(stderr, "stop: %t,%t\n", who, when);
}
#line 2006 "TBmodule.c.nw"
void start(int cid, term *who, term *mode)
{
  TBprintf(stderr, "start: %t,%t\n", who, mode);
  if(TB_match(mode, "step"))
    exec_state = ES_SINGLE_STEP;
  else if(TB_match(mode, "run"))
    exec_state = ES_RUNNING;
  else {
    TBprintf(stderr, "Python nub: unknown exec-mode %t,%t\n", who, mode);
  }
}

#line 2024 "TBmodule.c.nw"
term *watch_vars(int cid, term_list *scope, term_list *names)
{
  return TB_make("cannot-watch(\"not implemented\")");
}
#line 2034 "TBmodule.c.nw"
term *get_var_list(int cid, term *scope_id)
{
  return TB_make("snd-value(no-var-list(\"not implemented\"))");
}
#line 2044 "TBmodule.c.nw"
term *change_var(int cid, term_list *scope, char *name, term *val)
{
  return TB_make("cannot-change(\"change-var not implemented yet!\")");
}
#line 2054 "TBmodule.c.nw"
term *get_scopes(int cid, term *constraints)
{
  return TB_make("snd-value(scopes(<term>,[]))", constraints);
}

#line 2065 "TBmodule.c.nw"
void rec_terminate(int cid, term *arg)
{
  exit(1);
}
#line 2075 "TBmodule.c.nw"
void rec_ack_event(int cid, term *ev)
{
}
