
package main;

$VERSION = "0.00";

use Options;

&Options::Get;

$ui = 'WebUI';
if (defined $::language) {
    $lang = $::language;
} else {
    $lang = 'PGLA';
}
if (defined $::command) {
    $lang = 'PGLNull';
}
if (defined $::basic) {
    $bi = $::basic;
    if ($bi eq 'MPP') {
	$bi = 'MPPV';
    }
} else {
    $bi = 'MPPV';
}
foreach $l (@::library) {
    unshift(@INC, $l);
}

if (! eval {require "$lang.pm"}) {
    die "language module $lang not found\n";
} else {
    $m = "${lang}::Exec";
    die "language module $lang does not support execution\n" unless defined &{$m};
}
if (! eval {require "$bi.pm"}) {
    die "basic instructions module $bi not found\n";
}
if (! eval {require "$ui.pm"}) {
    die "interface module $ui not found\n";
}

$id = shift;
$counter = shift;
$sequence = shift;
use WebKernel;
$errors = WebKernel->Init($lang, $bi, $ui, $sequence);
if ($errors) {
    $result = 'E';
    $pc = WebKernel->Run($counter - 1);
} else {
    $pc = WebKernel->Run($counter);
    if (${"${lang}::result"}) {
	$result = 'T';
    } else {
	if ($counter) {
	    $result = 'F';
	} else {
	    $result = 'N';
	}
    }
}
if (defined $::command) {
    print "$pc $result\n";
} else {
    print "$pc\n";
}
use FluidBase;
$ENV{'DOTFONTPATH'} = "/home/bobd/fonts";
FluidBase->GenDot($id);
#system("/home/bobd/graphviz/bin/dot -Tgif $id > ${id}.gif");
#system("/home/psf/bin/dot -Tgif $id > ${id}.gif");
system("/usr/bin/dot -Tgif $id > ${id}.gif");
unlink("$id");
