
proc Msg {s} {
    global wmsg

    $wmsg insert end [subst -nocommands -novariables "$s\n"]
    $wmsg see end
    update
    Wait
}

proc trace {id step result} {
    Msg "$id: $step => $result\n"
}

proc rec-terminate {n} {
    destroy .
}

proc Input {} {
    ClearWait
    gets stdin line
    if {$line == "quit"} {
	exit;
    }
    Msg $line
}

proc Wait {} {
    fileevent stdin readable { Input }
}

proc ClearWait {} {
    fileevent stdin readable ""
}

proc Initialize {} {
    global wmsg

    frame .f -bd 0
    pack .f -expand 1 -fill both

    set w .f
    frame $w.msg -bd 1 -relief raised
    pack $w.msg -expand 1 -fill both
    frame $w.msg.text
    frame $w.msg.text.f -bd 1 -relief sunken
    set wmsg [text $w.msg.text.f.te -bd 0 -width 36 -height 15 -takefocus 0 \
        -highlightthickness 0 -yscrollcommand "$w.msg.text.sbv set"]
    pack $w.msg.text.f.te -in $w.msg.text.f -expand 1 -fill both
    scrollbar $w.msg.text.sbv -width 8 -bd 1 -highlightthickness 0 \
        -orient vertical -takefocus 0 -command " $w.msg.text.f.te yview "
#    pack $w.msg.text.f -in $w.msg.text -side left \
        -expand 1 -fill both
#    pack $w.msg.text.sbv -in $w.msg.text -side left -expand 1 -fill y
    grid $w.msg.text.f -in $w.msg.text -row 0 -column 0 -sticky nsew
    grid $w.msg.text.sbv -in $w.msg.text -row 0 -column 1 -sticky ns
    grid columnconfig $w.msg.text 0 -weight 1
    grid columnconfig $w.msg.text 1 -weight 0
    grid rowconfig $w.msg.text 0 -weight 1

    pack $w.msg.text -in $w.msg -side top -padx 4 -pady 4 -expand 1 -fill both
}

Initialize

Wait
