
package main;

$VERSION = "0.02";

use Global;

sub init {
    $basic = shift;

    if (! eval {require "$basic.pm"}) {
#       die "module $basic not found\n";
        # die gives problems with the perl-adapter
        print STDERR "module $basic not found\n";
        exit 1;
    }
    $bin = Global::Get('BINDIR');
    $pid = open(TR, "| $bin/tracedisplay");
    $oldf = select TR;
    $| = 1;
    select $oldf;
    $nr = 0;
}

sub trace {
    my $id = shift;
    my $action = shift;
    my $result = shift;

    @a = split('___', $action);
    $nr ++;
    $s = sprintf "%3d %-4s %-20s => %s", $nr, $id, $basic->Print(@a), $result ? "T" : "F";
    print TR "$s\n";
}

sub rec_terminate {
    print TR "quit\n";
    exit;
}
