
package main;

$VERSION = "0.00";

use Global;

$basic = "MPP";
$primitives = "PGLA";

$options = "";
$load = "";

$threadoptions = "-b";

$bindir = Global::Get('BINDIR');
$libdir = Global::Get('LIBDIR');

while ($_ = $ARGV[0], /^-/) {
    shift;
    if (/^-B$/) {
	$basic = shift;
    } elsif (/^-P$/) {
	$primitives = shift;
    } elsif (/^-l$/) {
	$f = shift;
	$load .= " -l $primitives $f";
    } elsif (/^-b$/) {
	$threadoptions = "-b";
    } elsif (/^-i$/) {
	$threadoptions = "-i";
    } elsif (/^-L$/) {
	$l = shift;
	if ($l =~ /\.$/) {
	    $bindir = $l;
	    $libdir = $l;
	} else {
	    $bindir = "$l/bin";
	    $libdir = "$l/lib";
	}
	$ENV{PGABINDIR} = $bindir;
	$ENV{PGALIBDIR} = $libdir;
    } elsif (/^-V$/) {
	$options .= " -viewer";
    } else {
	die "usage: $0 [-P primitives] [-B basic] [-i] [-l thread] ...\n";
    }
}

# setting path so the tools can be found
$ENV{PATH} = "$BINDIR:$ENV{PATH}";

# It is not possible to give script-args to the perl-adapter like the
# wish-adapter, therefore we use an environment variable.
$ENV{PGATHREADOPTIONS} = "$threadoptions";

$wish = Global::Get('WISH');

exec "toolbus $options -DBINDIR='\"$bindir\"' -DCONTROLOPT='\"\\\"-P $primitives -B $basic $load\\\"\"' -DWISH='\"$wish\"' $libdir/threadsim.tb";
