
set version 0.10

package require ComboBox

### List operations ###

proc listpush {l v} {
    upvar $l list

    lappend list $v
}

proc listpop {l} {
    upvar $l list

    set v [lindex $list end]
    set list [lreplace $list end end]
    return $v
}

proc listshift {l} {
    upvar $l list

    set v [lindex $list 0]
    set list [lreplace $list 0 0]
    return $v
}

proc listunshift {l v} {
    upvar $l list

    set list [linsert $list 0 $v]
}

### end List operations ###

proc DisableRun {} {
    global wctrl
    global wstr
    global wnew
    global wcore
    global wthr
    global wbp

    $wctrl.run configure -state disabled
    $wctrl.stop configure -state normal
    $wctrl.step configure -state disabled
    $wctrl.quit configure -state disabled

    ComboBox::State $wstr.cycle.e disabled
    ComboBox::State $wstr.steps.e disabled

    $wnew.prim.e configure -state disabled
    $wnew.prog.e configure -state disabled
    $wnew.new configure -state disabled

    $wcore.dump configure -state disabled
    $wcore.init configure -state disabled
    $wcore.update configure -state disabled

    $wbp.one configure -state disabled
    $wbp.all configure -state disabled
}

proc EnableRun {} {
    global wctrl
    global wstr
    global wnew
    global wcore
    global wthr
    global wbp

    $wctrl.run configure -state normal
    $wctrl.stop configure -state disabled
    $wctrl.step configure -state normal
    $wctrl.quit configure -state normal

    ComboBox::State $wstr.cycle.e normal
    ComboBox::State $wstr.steps.e normal

    $wnew.prim.e configure -state normal
    $wnew.prog.e configure -state normal
    $wnew.new configure -state normal

    $wcore.dump configure -state normal
    $wcore.init configure -state normal
    $wcore.update configure -state normal

    $wbp.one configure -state normal
    $wbp.all configure -state normal
}

proc NewThread {pi bi prog {pc 0}} {
    global maxid
    global newid
    global thrinfo

    if {$newid != -1} return
    set newid "id$maxid"
    incr maxid
    set thrinfo($newid,primitive) $pi
    set thrinfo($newid,basic) $bi
    set thrinfo($newid,program) $prog
    sendTB "snd-event(new(\"$newid\", \"$pi\", \"$bi\", \"$prog\", $pc))"
}

proc Hold {id} {
    global hold
    global nrholds

    if {$hold($id)} {
	incr nrholds
    } else {
	incr nrholds -1
    }
}

proc AddNewThread {} {
    global wthr
    global thrlist
    global state
    global thrcycle
    global currentthr
    global newid
    global hold

    set id $newid
    set t $wthr.$id
    frame $t -bd 0
    label $t.tid -text $id -width 6 -bd 1
    checkbutton $t.hold -padx 6 -variable hold($id) -command "Hold $id"
    label $t.step -text "" -width 4 -bd 1
    label $t.state -text "run" -width 5 -bd 1
    pack $t.tid $t.hold $t.step $t.state -in $t -side left

    if {[llength $thrlist] == 0} {
	pack $t -in $wthr
	listpush thrlist $id
	if {$currentthr == ""} {
	    NextThread
	}
    } else {
	if {$thrcycle == "right"} {
	    set e [lindex $thrlist end]
	    pack $t -in $wthr -after $wthr.$e
	    listpush thrlist $id
	} else {
	    set e [lindex $thrlist 0]
	    pack $t -in $wthr -before $wthr.$e
	    listunshift thrlist $id
	}
    }
    set state($id) "run"
    set hold($id) 0
}

proc SetStepThread {} {
    global wthr
    global currentthr
    global currentstep

    $wthr.$currentthr.step configure -text "$currentstep"
}

proc UnsetStepThread {} {
    global wthr
    global currentthr

    $wthr.$currentthr.step configure -text ""
}

proc SetStateThread {t s} {
    global currentthr
    global wthr
    global state

    set state($t) "$s"
    $wthr.$t.state configure -text "$s"
}

proc UnselectThread {} {
    global wthr
    variable currentthr

    if {$currentthr != ""} {
	$wthr.$currentthr.tid configure -foreground black
    }
}

proc SelectThread {id} {
    global wthr
    global currentthr

    UnselectThread
    $wthr.$id.tid configure -foreground blue
    set currentthr $id
}

proc SkipThread {} {
    global currentthr

    UnsetStepThread
    UnselectThread
    set currentthr ""
}

proc NextThread {} {
    global currentthr
    global thrlist
    global thrcycle
    global currentstep
    global running
    global breakwhen
    global state
    global hold
    global nrholds

    set nrthr [llength $thrlist]
    if {$nrholds > $nrthr} {
	Stop
	return
    }
    if {$currentthr != ""} {
	UnsetStepThread
	if {$thrcycle == "right"} {
	    listpush thrlist $currentthr
	} else {
	    listunshift thrlist $currentthr
	}
	incr nrthr
    }
    if {$nrthr != 0} {
	while {1} {
	if {$nrholds == $nrthr} {
	    puts stderr "all holded"
	}
	    if {$thrcycle == "right"} {
		set t [listshift thrlist]
	    } else {
		set t [listpop thrlist]
	    }
	    SelectThread $t
	    set currentthr $t
	    if {! $hold($t)} {
		if {$running && $breakwhen == "all"} {
		    if {$state($t) != "break"} {
			break
		    }
		} else {
		    break
		}
	    }
	    if {$thrcycle == "right"} {
		listpush thrlist $currentthr
	    } else {
		listunshift thrlist $currentthr
	    }
	}
	set currentstep 0
	SetStepThread
    }
}

proc NextStep {} {
    global currentstep
    global thrsteps

    incr currentstep 
    if {$currentstep < $thrsteps} {
	SetStepThread
    } else {
	NextThread
    }
}

### Break operations ###

proc ClearBreaks {} {
    global thrlist
    global state
    global nrbreaks

    foreach t $thrlist {
	if {$state($t) == "break"} {
	    SetStateThread $t run
	}
    }
    set nrbreaks 0
}

proc SetBreak {t} {
    global nrbreaks

    SetStateThread $t break
    incr nrbreaks
}

proc BreakAll {} {
    global nrbreaks
    global thrlist
    global breakwhen

    if {$breakwhen == "all"} {
	if {$nrbreaks > [llength $thrlist]} {
	    return 1
	}
    }
    return 0;
}

proc BreakOne {} {
    global nrbreaks
    global breakwhen

    if {$breakwhen == "one"} {
	return $nrbreaks
    }
    return 0
}

proc Break {} {
    if {[BreakOne] || [BreakAll]} {
	return 1
    }
    return 0
}

### end Breakpoint operations ###

### Console ###

proc Msg {s} {
    global wmsg

    $wmsg insert end [subst -nocommands -novariables "$s"]
    $wmsg see end
    update
}

### end Console ###

### Interface actions ###

proc Run {} {
    global running
    global currentthr

    if {$currentthr != ""} {
	DisableRun
	ClearBreaks
	set running 1
	Step
    } else {
	Msg "no thread available\n"
    }
}

proc Stop {} {
    global running
    global coreupdates

    set running 0
    EnableRun

    if {! $coreupdates} {
        sendTB "snd-event(update)"
    }
}

proc Step {} {
    global currentthr
    global running
    global coreupdates

    if {$currentthr != ""} {
	SetStateThread $currentthr run
	sendTB "snd-event(step(\"$currentthr\"))"
	if {! $running && ! $coreupdates} {
	    sendTB "snd-event(update)"
	}
    } else {
	Msg "no thread available\n"
    }
}

proc Quit {} {
    sendTB "snd-event(quit)"
}

proc SetThreadSteps {n} {
    global thrsteps

    set thrsteps $n
}

proc SetThreadCycle {n} {
    global thrcycle

    set thrcycle $n
}

proc CoreUpdates {} {
    global coreupdates

    sendTB "snd-event(setupdate($coreupdates))"
}

proc StartThread {} {
    global primitive
    global basic
    global program

    NewThread $primitive $basic $program
}

### end Interface actions ###

### ToolBus actions ###

proc rec-ack-event { n } {
}

proc rec-terminate { n } {
    destroy .
}

proc done { s } {
    global currentthr
    global running

    if {$s == "stop"} {
	SetStateThread $currentthr "S"
	SkipThread
	if {$running && [Break]} {
	    Stop
	}
	NextThread
    } elseif {$s == "break"} {
	SetBreak $currentthr
	if {$running && [Break]} {
	    Stop
	}
	NextThread
    } elseif {$s == "deadlock"} {
	SetStateThread $currentthr "D"
	SkipThread
	if {$running && [Break]} {
	    Stop
	}
	NextThread
    } elseif {$s == "block"} {
#	BlockThread $currentthr
    } else { # ok
	NextStep
    }
    if {$running} {
	if {$currentthr == ""} {
	    Stop
	} else {
	    if {[Break]} {
		Stop
	    } else {
		Step
	    }
	}
    }
}

proc result { s } {
    global newid
    global thrcreation
    global currentthr

    if {$s == "\"ok\""} {
#	puts stderr "new ok"
	AddNewThread
    } else {
#	puts stderr "new failed $s"
	regexp {^\"error\((.*)\)\"$} $s match msg
	Msg "$msg\n"
    }
    set newid -1
    if {$thrcreation} {
	set thrcreation 0
	if {$s == "\"ok\""} {
	    set r 1
	} else {
	    set r 0
	}
	sendTB "snd-event(threadresult(\"$currentthr\", \"$r\"))"
    } else {
	StartProgs
    }
}

set thrcreation 0
proc thread {action} {
    global thrinfo
    global currentthr
    global thrcreation
    global allowthrcreation

    if {[regexp {^\"create (.+)\"$} $action match pc]} {
	if {$allowthrcreation} {
	    NewThread $thrinfo($currentthr,primitive) $thrinfo($currentthr,basic) $thrinfo($currentthr,program) $pc
	    set thrcreation 1
	} else {
	    Msg "thread creation not allowed\n"
	    sendTB "snd-event(threadresult(\"$currentthr\", \"0\"))"
	}
    }
}

### end ToolBus actions ###

proc Initialize {} {
    global wctrl
    global wstr
    global wnew
    global wcore
    global wthr
    global coreupdates
    global wbp
    global wmsg
    global allowthrcreation

    wm title . "threadcontrol"
    frame .f -bd 0
    pack .f

    frame .f.l -bd 0

    ###
    set wctrl .f.l.ctrl
    frame $wctrl -bd 1 -relief raised
    button $wctrl.run -text "run" -takefocus 0 -command { Run }
    button $wctrl.stop -text "stop" -takefocus 0 -command { Stop } -state disabled
    button $wctrl.step -text "step" -takefocus 0 -command { Step }
    button $wctrl.quit -text "quit" -takefocus 0 -command { Quit }
    set stop 1
    pack $wctrl.run $wctrl.stop $wctrl.step $wctrl.quit -in $wctrl \
	-side left -padx 2 -pady 2

    ###
    set wstr .f.l.str
    frame $wstr -bd 1 -relief raised
    label $wstr.head -text "Strategy"
    frame $wstr.cycle -bd 0
    label $wstr.cycle.t -text "cycle"
#    entry $wstr.cycle.e -width 6 -textvariable thrcycle
    ComboBox::Create $wstr.cycle.e 6 0 SetThreadCycle
    ComboBox::Add $wstr.cycle.e "left"
    ComboBox::Add $wstr.cycle.e "right"
    ComboBox::Set $wstr.cycle.e "right"
    pack $wstr.cycle.t $wstr.cycle.e -in $wstr.cycle -side left
    frame $wstr.steps -bd 0
    label $wstr.steps.t -text "steps"
#    entry $wstr.steps.e -width 6 -textvariable thrsteps
    ComboBox::Create $wstr.steps.e 2 0 SetThreadSteps
    for {set i 1} {$i <= 10} { incr i} {
	ComboBox::Add $wstr.steps.e $i
    }
    ComboBox::Set $wstr.steps.e 1
    pack $wstr.steps.t $wstr.steps.e -in $wstr.steps -side left
    pack $wstr.head -in $wstr -padx 2 -pady 2 -anchor w
    pack $wstr.cycle $wstr.steps -in $wstr -side left -ipadx 2 -padx 2 -pady 2

    ###
    set wnew .f.l.new
    frame $wnew -bd 1 -relief raised
    label $wnew.head -text "New Thread"
    frame $wnew.prim -bd 0
    label $wnew.prim.l -text "primitive"
    entry $wnew.prim.e -width 16 -textvariable primitive
    pack $wnew.prim.l $wnew.prim.e -in $wnew.prim -side left
    frame $wnew.prog -bd 0
#    label $wnew.prog.l -text "program" -width 9 -anchor e
#    entry $wnew.prog.e -width 24 -textvariable program
    label $wnew.prog.l -text "program"
    entry $wnew.prog.e -width 20 -textvariable program
    pack $wnew.prog.l $wnew.prog.e -in $wnew.prog -side left
    button $wnew.new -text "start" -command { StartThread }
    pack $wnew.head -in $wnew -padx 2 -pady 2 -anchor w
    pack $wnew.prim $wnew.prog $wnew.new -in $wnew -padx 2 -pady 2 -anchor w

    ###
    set wcreate .f.l.create
    frame $wcreate -bd 1 -relief raised
    checkbutton $wcreate.allow -text "allow thread creation" -indicatoron 1 -takefocus 0 \
	-variable allowthrcreation
    set allowthrcreation 1
    pack $wcreate.allow -in $wcreate

    ###
    set wcore .f.l.core
    frame $wcore -bd 1 -relief raised
    label $wcore.l -text "Core"
    button $wcore.dump -text "dump" -takefocus 0 -command { sendTB "snd-event(dumpcore)" }
    # initialize can screw up operations on core
    button $wcore.init -text "initialize" -takefocus 0 -command { sendTB "snd-event(initcore)" }
    checkbutton $wcore.update -text "updates" -indicatoron 1 -takefocus 0 \
	-variable coreupdates -command { CoreUpdates }
    set coreupdates 1
    pack $wcore.l -in $wcore -padx 2 -pady 2 -anchor w
    pack $wcore.dump $wcore.init $wcore.update -in $wcore -side left -padx 2 -pady 2

    ###
    set wbp .f.l.break
    frame $wbp -bd 1 -relief raised
    label $wbp.l -text "Breakpoints"
    radiobutton $wbp.one -text "when one" -indicatoron 1 -takefocus 0 \
	-variable breakwhen -value "one"
    radiobutton $wbp.all -text "when all" -indicatoron 1 -takefocus 0 \
	-variable breakwhen -value "all"
    pack $wbp.l -in $wbp -padx 2 -pady 2 -anchor w
    pack $wbp.one $wbp.all -in $wbp -padx 2 -pady 2 -side left
    $wbp.one select

    ###
    set w .f.l
    frame $w.msg -bd 1 -relief raised
    pack $w.msg -expand 1 -fill both
    label $w.msg.l -text "Console"
    frame $w.msg.text
        # text
    frame $w.msg.text.f -bd 1 -relief sunken
    set wmsg [text $w.msg.text.f.te -bd 0 -width 32 -height 5 -takefocus 0 \
        -highlightthickness 0 -yscrollcommand "$w.msg.text.sbv set"]
    pack $w.msg.text.f.te -in $w.msg.text.f -expand 1 -fill both
    scrollbar $w.msg.text.sbv -width 8 -bd 1 -highlightthickness 0 \
        -orient vertical -takefocus 0 -command " $w.msg.text.f.te yview "
#    pack $w.msg.text.f -in $w.msg.text -side left \
        -expand 1 -fill both
#    pack $w.msg.text.sbv -in $w.msg.text -side left -expand 1 -fill y
    grid $w.msg.text.f -in $w.msg.text -row 0 -column 0 -sticky nsew
    grid $w.msg.text.sbv -in $w.msg.text -row 0 -column 1 -sticky ns
    grid columnconfig $w.msg.text 0 -weight 1
    grid columnconfig $w.msg.text 1 -weight 0
    grid rowconfig $w.msg.text 0 -weight 1

    pack $w.msg.l -in $w.msg -side top -padx 4 -pady 4
    pack $w.msg.text -in $w.msg -side top -padx 4 -pady 4 -expand 1 -fill both

    ###
    pack $wctrl $wstr $wnew $wcreate $wcore $wbp $w.msg -in .f.l -fill both

    frame .f.r -bd 1 -relief raised

    ###
    set wthr .f.r.thr
    frame $wthr -bd 1 -relief sunken
    set h $wthr.h
    frame $h -bd 0
    label $h.tid -text "thread" -width 6 -bd 1 -relief raised
    label $h.hold -text "hold" -width 4 -bd 1 -relief raised
    label $h.step -text "step" -width 4 -bd 1 -relief raised
    label $h.state -text "state" -width 5 -bd 1 -relief raised
    pack $h.tid $h.hold $h.step $h.state -in $h -side left

    pack $h -in $wthr
    frame $wthr.f -bd 0
    pack $wthr.f -in $wthr -expand 1 -fill both

    ###
    pack $wthr -in .f.r -expand 1 -fill both -padx 2 -pady 2
    set wthr $wthr.f

    pack .f.l .f.r -in .f -side left -fill both
}

proc StartProgs {} {
    global progs
    global primitive
    global basic
    global program

    if {[llength $progs]} {
	set primitive [listshift progs]
	set program [listshift progs]
	NewThread $primitive $basic $program
    }
}

### Initialize Interface ###

Initialize

### Processing arguments ###

# argc has the wrong value
set argc [llength $argv]
set primitive ""
set basic ""
set progs ""
for {set i 0} {$i < $argc} { incr i} {
    switch -exact -- [lindex $argv $i] {
	-P {
	    incr i
	    set primitive [lindex $argv $i]
	}
	-B {
	    incr i
	    set basic [lindex $argv $i]
	}
	-l {
	    incr i
	    lappend progs [lindex $argv $i]
	    incr i
	    lappend progs [lindex $argv $i]
	}
    }
}

### Initialize simulation ###

# initialize BI
sendTB "snd-event(init(\"$basic\"))"

set maxid 0
set newid -1
set currentthr ""
set thrlist [list]
set running 0
set nrholds 0

StartProgs
