
# This wrapper does also thread extraction behavior, which really should
# be build into the kernel of the simulator.
# Now a break clearance may still cause a break since it is already
# collected here.

package main;

$VERSION = "0.03";

use Global;

use FileHandle;
use IPC::Open2;

$behavior = 0;
if (defined $ENV{PGATHREADOPTIONS}) {
    $_ = $ENV{PGATHREADOPTIONS};
    if (/^-b$/) {
	$behavior = 1;
    } elsif (/^-i$/) {
	$behavior = 0;
    }
}

sub init {
    my $id = shift;
    my $primitive = shift;
    my $basic = shift;
    my $file = shift;
    my $pc = shift;

    $bin = Global::Get('BINDIR');
    if ($file eq "") {
	$load = "";
    } else {
	$load = "-l $file";
    }
    $pid = open2(\*SIMR, \*SIMW, "$bin/gensim -TB -THR -ID $id -g -P $primitive -B $basic -pc $pc $load");
    $result = <SIMR>;
    chop $result;
    if ($result =~ /^error\((.*)\)$/) {
	TBsend("snd-value(error(\"error($1)\"))");
	rec_terminate();
    } else {
	TBsend("snd-value(ok)");
#	if ($behavior) {
#	    NextStep();
#	}
    }
}

my @pclist = ();

sub inpclist {
    my $pc = shift;

    foreach $i (@pclist) {
	if ($i == $pc) {
	    return 1;
	}
    }
    push @pclist, $pc;
    return 0;
}

sub clearpclist {
    @pclist = ();
}

sub NextStep {
    while (1) {
	print SIMW "s\n";
	$command = <SIMR>;
	if ($command =~ /^exec\((.*)\)$/) {
	    clearpclist();
#	    TBsend("snd-value(exec(\"$1\"))");
	    $nextstep = "exec(\"$1\")";
	    last;
	} elsif ($command =~ /^thread\((.*)\)$/) {
	    clearpclist();
#	    TBsend("snd-value(thread(\"$1\"))");
	    $nextstep = "thread(\"$1\")";
	    last;
	} elsif ($command =~ /^done\((\d+), (\d)\)$/) {
	    if (inpclist($1)) {
#		TBsend("snd-value(deadlock)");
		$nextstep = "deadlock";
		last;
	    }
	    if ($2) {
#		TBsend("snd-value(break)");
		$nextstep = "break";
		last;
	    }
	    if (! $behavior) {
#		TBsend("snd-value(done)");
		$nextstep = "done";
		last;
	    }
	} elsif ($command =~ /^stop$/) {
#	    TBsend("snd-value(stop)");
		$nextstep = "stop";
	    last;
	} else {
#	    TBsend("snd-value(unknown(\"$command\"))");
		$nextstep = "unknown(\"$command\")";
	    last;
	}
    }
}

sub step {
#    if (! $behavior) {
	NextStep();
#    }
    TBsend("snd-value($nextstep)");
    if ($nextstep =~ /^exec\((.*)\)$/) {
    } elsif ($nextstep =~ /^thread\((.*)\)$/) {
    } elsif ($nextstep =~ /^stop$/) {
    } else {
#	if ($behavior) {
#	    NextStep();
#	}
    }
}

sub ack {
    my $n = shift;

    print SIMW "ack($n)\n";
    $command = <SIMR>;
    if ($command =~ /^done\((.*), (\d)\)$/) {
	if ($2) {
	    TBsend("snd-value(break)");
	} else {
	    TBsend("snd-value(done)");
	}
    } elsif ($command =~ /^exec\((.*)\)$/) { # added voor eval as primitive
	TBsend("snd-value(exec(\"$1\"))");
	return;
    } else {
	TBsend("snd-value(unknown(\"$command\"))");
    }
#    if ($behavior) {
#	NextStep();
#    }
}

sub rec_ack_event {
}

sub rec_terminate {
    if ($nextstep =~ /^exec\((.*)\)$/) {
	print SIMW "ack(1)\n";
	$command = <SIMR>;
    } elsif ($nextstep =~ /^thread\((.*)\)$/) {
	print SIMW "ack(1)\n";
	$command = <SIMR>;
    }
    print SIMW "q\n";
    exit;
}

