
set version 0.01

proc Initialize {} {
    global w

    wm title . "State Machines"
    set w .f
    frame $w
    pack $w -expand 1 -fill both
    frame $w.h -relief raised -border 2
    label $w.h.l -text "State Machines"
    pack $w.h.l -in $w.h
    frame $w.f
    pack $w.f -expand 1 -fill both
    pack $w.h $w.f -in $w -expand 1 -fill both
}

proc Reset {} {
    global w

    destroy $w.f
    frame $w.f
    pack $w.f -expand 1 -fill both
    pack $w.f -in $w -expand 1 -fill both
}

proc Perform {t n f a} {
    global w

    if {[catch { package require $t } r]} {
	puts stderr "could not find module $t"
    } else {
	set u [string toupper [string index $f 0]]
	set r [string range $f 1 end]
	set fun "$u$r"
	eval "${t}::$fun $w.f $n $a"
    }
}

proc ReadInput {} {
    gets stdin line
    if {[regexp {^quit$} $line match]} {
	exit
    } elseif {[regexp {^reset$} $line match]} {
	Reset
    } elseif {[regexp {^ *([^ ]*) +([^ ]*) +([^ ]*)( .*)?$} $line match type name fun args]} {
#	puts stderr "$type - $name - $fun - $args -"
	Perform $type $name $fun $args
    } else {
	puts stderr "no match"
    }
}

for {set i 0} {$i < $argc} {incr i} {
    set a [lindex $argv $i]
#    if {[string index $a 0] == "."} {
#	regsub {^\.} $a "/home/bobd/PGA/src" a
#    }
    lappend auto_path $a
}

Initialize

fileevent stdin readable ReadInput
