
package main;

$VERSION = "0.00";

use SLabel;
use NLabel;
use Generic;
use Input;
use Display;

SLabel->Init('Input', 'Generic', 'Display');
NLabel->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
SLabel->Parse(0);
SLabel->Check;

my $src = \@SLabel::prog;
my $dest = \@NLabel::prog;
my $ic;
my @i;
my $opc;
my $l;

my $nrlabel = 0;

sub setmaxlabel {
    my $l = shift;

    if ($l =~ /^(\d+)$/) {
	if ($l > $nrlabel) {
	    $nrlabel = $l;
	}
    }
}

sub setstartlabel {
    $nrlabel += 1000;
    $nrlabel -= $nrlabel % 1000;
}

sub getnlabel {
    my $s = shift;

    if ($l =~ /^(\d+)$/) {
	return $s;
    }
    if (!defined $s2n{$s}) {
	$s2n{$s} = $nrlabel;
	$nrlabel ++;
    }
    return $s2n{$s};
}

# find max label
for ($ic = 0; $ic <= $#{$src}; $ic ++) {
    @i = @{$$src[$ic]};
    $opc = shift @i;
    if ($opc eq 'LABEL' || $opc eq 'GOTO' || $opc eq 'RETGOTO') {
	$l = shift @i;
	setmaxlabel($l);
    }
}
# start at a multiple of 1000 to make new labels distinguishable from old ones
setstartlabel();

for ($ic = 0; $ic <= $#{$src}; $ic ++) {
    @i = @{$$src[$ic]};
    $opc = shift @i;
    if ($opc eq 'GOTO' || $opc eq 'RETGOTO') {
	$l = shift @i;
	$$dest[$ic] = [( $opc, getnlabel($l), '?' )];
    } elsif ($opc eq 'LABEL') {
	$l = shift @i;
	$$dest[$ic] = [( $opc, getnlabel($l) )];
    } else {
	$$dest[$ic] = [( $opc, @i )];
    }
}

for ($ic = 0; $ic <= $#{$dest}; $ic ++) {
    @i = @{$$dest[$ic]};
    $s = NLabel->PrintStep(0, @i);
    if ($ic == $#{$dest}) {
	print "$s\n";
    } else {
	print "$s;\n";
    }
}
