
set version 0.01

proc Initialize {} {
    global w
    global window

#    wm title . "BPView"
    frame .all
    pack .all -expand 1 -fill both
    #
    set w .all.save
    frame $w -bd 1 -relief raised
    button $w.save -text "save in/out" -command { Save }
    button $w.load -text "load in" -command { Load } -state disabled
    button $w.comp -text "compare in/out" -command { Compare } -state disabled
    pack $w.save $w.load $w.comp -in $w -side left -expand 0 -fill both
    pack $w -in .all -expand 0 -fill both
    #
    set w .all.var
    frame $w
    pack $w -expand 1 -fill both
    frame $w.in -bd 0
    label $w.in.l -text "in" -bd 1 -relief raised
    frame $w.in.f -bd 1 -relief raised
    pack $w.in.l -in $w.in -fill x
    pack $w.in.f -in $w.in -fill both -expand 1
    frame $w.aux -bd 0
    label $w.aux.l -text "aux" -bd 1 -relief raised
    frame $w.aux.f -bd 1 -relief raised
    pack $w.aux.l -in $w.aux -fill x
    pack $w.aux.f -in $w.aux -fill both -expand 1
    frame $w.out -bd 0
    label $w.out.l -text "out" -bd 1 -relief raised
    frame $w.out.f -bd 1 -relief raised
    pack $w.out.l -in $w.out -fill x
    pack $w.out.f -in $w.out -fill both -expand 1
    pack $w.in $w.aux $w.out -in $w -side left -fill both -expand 1
    pack $w -in .all -side top
    set window(in) $w.in.f
    set window(aux) $w.aux.f
    set window(out) $w.out.f
}

proc DisplayMessage { t s } {
    tk_messageBox -title "$t" -type ok -message "$s"
}

proc Save {} {
    global value
    global save

    array set save [array get value]
    .all.save.load configure -state normal
    .all.save.comp configure -state normal
}

proc Load {} {
    global value
    global save

    # input names do not match
    set savelist [lsort [array names save in,*]]
    set list [lsort [array names value in,*]]
    if {[join $savelist -] != [join $list -]} {
	DisplayMessage "load" "input propositions do not match"
	return
    }

    # set input
    foreach e $savelist {
	set value($e) $save($e)
    }
}

proc Compare {} {
    global value
    global save

    set comp 1
    # input names do not match
    set savelist [lsort [array names save in,*]]
    set list [lsort [array names value in,*]]
    if {[join $savelist -] != [join $list -]} {
	DisplayMessage "compare" "input propositions do not match"
	return
    }
    # input values do not match
    foreach e $savelist {
	if {$value($e) != $save($e)} {
	    DisplayMessage "compare" "input values do not match"
	    set comp 0
	    break
	}
    }
    # output names do not match
    set savelist [lsort [array names save out,*]]
    set list [lsort [array names value out,*]]
    if {[join $savelist -] != [join $list -]} {
	DisplayMessage "compare" "output propositions do not match"
	return
    }
    # output values do not match
    foreach e $savelist {
	if {$value($e) != $save($e)} {
	    DisplayMessage "compare" "output values do not match"
	    set comp 0
	    break
	}
    }
    if {$comp} {
	DisplayMessage "compare" "input and output match"
    }
}

proc Add { type nr } {
    global window
    global value

    set w $window($type)
    frame  $w.$nr
    if {$type == "in"} {
	button $w.$nr.l -text "$nr" -anchor e -width 5 -bd 0 -pady 0 -highlightthickness 0 -command "Toggle $nr"
    } else {
	label $w.$nr.l -text "$nr" -anchor e -width 5
    }
    label $w.$nr.v -textvariable value($type,$nr) -width 7
    pack $w.$nr.l $w.$nr.v -in $w.$nr -side left
    set value($type,$nr) "false"
    for {set i [expr $nr - 1]} {$i >= 0} {incr i -1} {
	if {[info exists value($type,$i)]} {
	    break
	}
    }
    if {$i == -1} {
	set wl [pack slaves $w]
	if {$wl == ""} {
	    pack $w.$nr -in $w
	} else {
	    set f [lindex $wl 0]
	    pack $w.$nr -in $w -before $f
	}
    } else {
	pack $w.$nr -in $w -after $w.$i
    }
}

proc Toggle { nr } {
    global value

    if {$value(in,$nr) == "false"} {
	set value(in,$nr) "true"
    } else {
	set value(in,$nr) "false"
    }
}

proc Set { type nr val } {
    global value

    if {! [info exists value($type,$nr)]} {
	Add $type $nr
    }
    set value($type,$nr) $val
}

proc Get { type nr } {
    global value

    if {! [info exists value($type,$nr)]} {
	Add $type $nr
    }
    puts "$value($type,$nr)"
}

proc Is { type nr val } {
    global value

    if {! [info exists value($type,$nr)]} {
	Add $type $nr
    }
    if {$value($type,$nr) == $val} {
	puts "true"
    } else {
	puts "false"
    }
}

proc Reset {} {
    global window
    global value

    eval destroy [winfo children $window(in)]
    eval destroy [winfo children $window(aux)]
    eval destroy [winfo children $window(out)]
    if {[info exists value]} {
	unset value
    }
}

proc ReadInput {} {
    gets stdin line
    if {[regexp {^quit$} $line match]} {
	exit
    } elseif {[regexp {^reset$} $line match]} {
	Reset
    } elseif {[regexp {^ *INIT +([^ ]+) +([^ ]+)$} $line match type number]} {
	set type [string tolower $type]
	Set $type $number "false"
    } elseif {[regexp {^ *SET +([^ ]+) +([^ ]+) ([^ ]+)$} $line match type number value]} {
	set type [string tolower $type]
	Set $type $number $value
    } elseif {[regexp {^ *GET +([^ ]+) +([^ ]+)$} $line match type number]} {
	set type [string tolower $type]
	Get $type $number
    } elseif {[regexp {^ *IS +([^ ]+) +([^ ]+) ([^ ]+)$} $line match type number value]} {
	set type [string tolower $type]
	Is $type $number $value
    } else {
	puts stderr "no match"
    }
}

Initialize

#Add in 0
#Add in 10
#Add in 8
#Add aux 10
#Add aux 12
#Add aux 11
#Add out 8
#Add out 88
#Add out 9
#Add in 30000

fileevent stdin readable ReadInput
