
package main;

$VERSION = "0.02";

@{$language[0]} = ( 'pgla', 'pglb', 'pglc', 'pgld', 'pgldg', 'pgle', 'pglec', 'pglecr', 'pglecm' );
@{$language[1]} = ( 'pgla', 'pglb', 'pglc', 'pgld', 'pgldg', 'pgle', 'pglec', 'pglecw');

$0 =~ /^(.*)\/[^\/]+$/;
$execpath = $1;

sub usage {
    die "usage: $0 [-p] from-language to-language\n       $0 -l\n";
}

while ($_ = $ARGV[0], /^-/) {
    shift;
    if (/^-l$/) {
	for ($i = 0; $i <= $#language; $i ++) {
	    print join(" -> ", reverse @{$language[$i]}), "\n";
	}
	exit 0;
    } elsif (/^-p$/) {
	$noexec = 1;
    } else {
	usage;
    }
}
if ($#ARGV != 1) {
    usage;
}

$from = lc shift;
$to = lc shift;

if ($from eq $to) {
    die "$0: no projection onto the same language\n";
}

$from_exist = 0;
for ($j = 0; $j <= $#language; $j ++) {
    $command = "cat";
    $found_from = 0;
    $found_to = 0;
    @list = @{$language[$j]};
    for ($i = $#list; $i >= 0; $i --) {
	if (! $found_from) {
	    if ($list[$i] eq $from) {
		$found_from = 1;
		$found_exist = 1;
	    }
	} else {
	    $lf = $list[$i + 1];
	    $lt = $list[$i];
	    $command .= " | ${lf}2${lt}";
	    if ($list[$i] eq $to) {
		$found_to = 1;
		last;
	    }
	}
    }

    if ($found_from) {
	if ($found_to) {
	    if ($noexec) {
		print "$command\n";
	    } else {
		$ENV{PATH} = "$execpath:$ENV{PATH}";
		exec "$command";
	    }
	    exit;
	}
    }
}
if ($found_exist) {
    if (! $found_to) {
	die "$0: no projection from $from onto $to possible\n";
    }
} else {
    die "$0: language '$from' is unknown\n";
}
