
package main;

$VERSION = "0.04";

use Input;
use Display;

use Benchmark;

sub Load {
    my $prim = shift;
    my $f = shift;
    my $ts = shift;

    if (open(IN, "<$f")) {
        Input->Stream(\*IN);
#	$t0 = new Benchmark;
	$prim->Parse(0);
        close IN;
#	$t1 = new Benchmark;
#	print STDERR "time parse: ", timestr(timediff($t1, $t0)), "\n";
        $prim->Check;
#	$t2 = new Benchmark;
#	print STDERR "time check: ", timestr(timediff($t2, $t1)), "\n";
	$ts->MakeTrans($prim->Mem);
#	$t3 = new Benchmark;
#	print STDERR "time maketrans: ", timestr(timediff($t3, $t2)), "\n";
    } else {
        die "could not open file '$f'\n";
    }
}

sub MakeTrans {
    my $language = shift;
    my $file = shift;
    my $ts;
    my $strts;

    require Generic;
    $strts = "${language}TransSystem";
    if (! eval {require "$strts.pm"}) {
	die "module $strts not found\n";
    }
    if (! eval {require "$language.pm"}) {
	die "module $language not found\n";
    }
    $language->Init('Input', 'Generic', 'Display');
    $ts = new $strts;
    Load($language, $file, $ts);
    return $ts;
}

$verbose = 0;
$language = 'PGLA';
$print = 0;
while ($_ = $ARGV[0], /^-/) {
    shift;
    if (/^-v$/) {
	$verbose = 1;
    } elsif (/^-p$/) {
	$print = 1;
    } elsif (/^-L$/) {
	$modlib = shift;
	unshift(@INC, $modlib);
    } elsif (/^-P$/) {
	$language = shift;
    } else {
	die "usage: $0 [-v] [-L lib] [-P language] file\n";
    }
}
if ($#ARGV == 0) {
    $file = shift;
} else {
    die "usage: $0 [-v] [-L lib] [-P language] file\n";
}

$ts = MakeTrans($language, $file);
if ($print) {
    $ts->Print();
} else {
    $ts->WriteAut();
}
