
package main;

$VERSION = "0.00";

use Directive;
use PGLNull;
use Generic;
use LineInput;
use Display;

Directive->Init('LineInput', 'Generic', 'Display');
PGLNull->Init('LineInput', 'Generic', 'Display');

LineInput->Stream(\*STDIN);
Directive->Parse(0);
Directive->Check;

my $src = \@Directive::prog;
my $dest = \@PGLNull::prog;
my $ic;
my @i;
my $opc;
my $l;

@ns = ('main');

sub makelabel {
    my $l = shift;

    return "\"" . join(":", @ns) . ":" . $l . "\"";
}

sub makellabel {
    my $l = shift;
    my $i;

    $i = index($l, ":");
    if ($i != 0) {
	return "\"main:$l\"";
    } elsif ($i == 0) {
	return makelabel(substr($l, 1));
    }
}

$dic = 0;
for ($ic = 0; $ic <= $#{$src}; $ic ++) {
    @i = @{$$src[$ic]};
    $opc = shift @i;
    if ($opc eq 'NAMESPACE') {
	$l = shift @i;
	push @ns, $l;
    } elsif ($opc eq 'END') {
	pop @ns;
    } elsif ($opc eq 'LABEL') {
	$l = shift @i;
	$sp = shift @i;
	$sl = makelabel($l);
	$$dest[$dic ++] = [( 'ACTION', ( "${sp}L$sl;" ) )];
    } elsif ($opc eq 'GOTO') {
	$l = shift @i;
	$sp = shift @i;
	$sl = makellabel($l);
	$$dest[$dic ++] = [( 'ACTION', ( "${sp}##L$sl;" ) )];
    } elsif ($opc eq 'CALL') {
	$l = shift @i;
	$sp = shift @i;
	$sl = makellabel($l);
	$$dest[$dic ++] = [( 'ACTION', ( "${sp}R##L$sl;" ) )];
    } elsif ($opc eq 'RETURN') {
	$sp = shift @i;
	$$dest[$dic ++] = [( 'ACTION', ( "${sp}R;" ) )];
    } elsif ($opc eq 'COMMENT') {
    } else {
	$$dest[$dic ++] = [( $opc, @i )];
    }
}

for ($ic = 0; $ic <= $#{$dest}; $ic ++) {
    @i = @{$$dest[$ic]};
    $s = PGLNull->PrintStep(0, @i);
    if ($ic == $#{$dest}) {
	if ($s =~ /;$/) {
	    chop $s;
	}
    }
    print "$s\n";
}
