
package main;

$VERSION = "0.03";

use LineInput;
use Display;

sub usage {
    die "usage: $0 [-v] [-p [-l]] [-P primitives] [-B basic-instructions] [-L library] file\n       $0 [-v] [-p [-l]] [-i] [-P primitives] [-B basic-instructions] [-L library]\n";
}

$language = 'Directive';
$basic = 'Generic';
$verbose = 0;
$print = 0;
$linenumbers = 0;
$fromstdin = 0;
while ($_ = $ARGV[0], /^-/) {
    shift;
    if (/^-P$/) {
	$language = shift;
    } elsif (/^-B$/) {
	$basic = shift;
    } elsif (/^-L$/) {
	push @library, shift;
    } elsif (/^-v$/) {
	$verbose = 1;
    } elsif (/^-p$/) {
	$print = 1;
    } elsif (/^-l$/) {
	$linenumbers = 1;
    } elsif (/^-i$/) {
	$fromstdin = 1;
    } else {
	usage;
    }
}
if ($#ARGV != 0 && (! $fromstdin && $#ARG == -1)) {
    usage;
}
foreach $l (@library) {
    unshift(@INC, $l);
}

if (! eval {require "$language.pm"}) {
    die "module $language not found\n";
}
if (! eval {require "$basic.pm"}) {
    die "module $basic not found\n";
}

$language->Init('LineInput', $basic, 'Display');

if ($fromstdin) {
    *FH = *STDIN;
} else {
    open(FH, "$ARGV[0]") || die "could not open $ARGV[0]\n";
}

LineInput->Stream(\*FH);
$errors = $language->Parse($verbose);
if ($verbose) {
    print "\n";
}
if (! $fromstdin) {
    close FH;
}
if ($errors) {
    print "parse errors: $errors\n";
}
$language->Check;
if ($print) {
    $language->Print($linenumbers);
}

exit $errors;
