
package main;

$VERSION = "0.00";

use PGLEcw;
use PGLEc;
use Generic;
use Input;
use Display;

PGLEcw->Init('Input', 'Generic', 'Display');
PGLEc->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLEcw->Parse(0);
PGLEcw->Check;
#PGLEcw->Print(0);

my $src = \@PGLEcw::prog;
my $dest = \@PGLEc::prog;
my $ic;
my $nic;
my @i;
my $opc;
my $l;

for ($ic = 0, $nic = 0; $ic <= $#{$src}; $ic ++, $nic ++) {
    @i = @{$$src[$ic]};
    $opc = shift @i;
    if ($opc eq 'LABEL') {
	$l = shift @i;
	$$dest[$nic] = [( $opc, $l + $#{$src} + 1 + 1 )];
    } elsif ($opc eq 'GOTO') {
	$l = shift @i;
	$$dest[$nic] = [( $opc, $l + $#{$src} + 1 + 1, '?' )];
    } elsif ($opc eq 'WHILET') {
	$l = pop @i;
	$$dest[$nic ++] = [( 'LABEL', $ic + 1, '?' )];
	$$dest[$nic] = [( 'IFT', @i, '?' )];
    } elsif ($opc eq 'WHILEF') {
	$l = pop @i;
	$$dest[$nic ++] = [( 'LABEL', $ic + 1, '?' )];
	$$dest[$nic] = [( 'IFF', @i, '?' )];
    } elsif ($opc eq 'WHILE') {
	$l = pop @i;
	$$dest[$nic] = [( 'LABEL', $ic + 1, '?' )];
    } elsif ($opc eq 'ENDWHILE') {
	$l = pop @i;
	$$dest[$nic] = [( 'GOTO', $l + 1, '?' )];
	@j = @{$$src[$l]};
	$jopc = shift @j;
	if ($jopc ne 'WHILE') {
	    $nic ++;
	    $$dest[$nic] = [( 'ENDIF', '?' )];
	}
    } else {
	$$dest[$nic] = [( $opc, @i )];
    }
}

#print "--------\n";
for ($ic = 0; $ic <= $#{$dest}; $ic ++) {
    @i = @{$$dest[$ic]};
    $s = PGLEc->PrintStep(0, @i);
    if ($ic == $#{$dest}) {
	print "$s\n";
    } else {
	print "$s;\n";
    }
}
