
package main;

$VERSION = "0.07";

use PGLEcm;
use PGLEcr;
use Generic;
use Input;
use Display;

PGLEcm->Init('Input', 'Generic', 'Display');
PGLEcr->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLEcm->Parse(0);
PGLEcm->Check;
#PGLEcm->Print(0);

my $src = \@PGLEcm::prog;
my $dest = \@PGLEcr::prog;
my $maxlabel = 0;
my $ic;
my $nic;
my @i;
my $opc;
my $l;

for ($ic = 0; $ic <= $#{$src}; $ic ++, $nic ++) {
    @i = @{$$src[$ic]};
    $opc = shift @i;
    if ($opc eq 'LABEL') {
	$l = shift @i;
	if ($l > $maxlabel) {
	    $maxlabel = $l;
	}
    }
}

my $methodlabel;
my $object;
my $method;
my %method;
my @mi;
my $n;
my $j;
my $call;
my $x;

$methodlabel = $maxlabel + 1000;
for ($ic = 0; $ic <= $#{$src}; $ic ++, $nic ++) {
    @i = @{$$src[$ic]};
    $opc = shift @i;
    if ($opc eq 'METHODDEF') {
	$method{shift @i} = $methodlabel ++;
    }
}

$nic = 0;
for ($ic = 0; $ic <= $#{$src}; $ic ++, $nic ++) {
    @i = @{$$src[$ic]};
#    PGLEcm->PrintStep(0, @i);
#    print ";\n";
    $opc = shift @i;
    if ($opc eq 'METHODDEF') {
	$l = $method{shift @i};
	$$dest[$nic] = [( 'LABEL', "$l" )];
    } elsif ($opc eq 'METHODEND') {
	$$dest[$nic] = [( 'RETURN' )];
    } elsif ($opc eq 'METHODCALL') {
	$object = shift @i;
	$method = shift @i;
	$n = pop @i;
	if ($object eq "") {
	    $call = $method;
	} else {
#	    $call = "$object.$method";
	    $call = $method;
	}
	@mi = @{$$src[$n]};
	shift @mi;
	shift @mi;
	for ($j = 0; $j <= $#i; $j ++) {
	    $$dest[$nic ++] = [( 'ACTION', "stackframe.+$mi[$j]" )];
	    $$dest[$nic ++] = [( 'ACTION', "stackframe.$mi[$j] = $mi[$j]" )];
	    $$dest[$nic ++] = [( 'ACTION', "$mi[$j] = $i[$j]" )];
	}
	if ($object ne "") {
	    $$dest[$nic ++] = [( 'ACTION', 'stackframe.+this' )];
	    $$dest[$nic ++] = [( 'ACTION', 'stackframe.this = this' )];
	    $$dest[$nic ++] = [( 'ACTION', "this = $object" )];
	}
	$l = $method{$call};
	$$dest[$nic ++] = [( 'RETGOTO', $l, '?' )];
	if ($object ne "") {
	    $$dest[$nic ++] = [( 'ACTION', 'this = stackframe.this' )];
	    $$dest[$nic ++] = [( 'ACTION', 'stackframe.-this' )];
	}
	for ($j = 0; $j <= $#i; $j ++) {
	    $$dest[$nic ++] = [( 'ACTION', "$mi[$j] = stackframe.$mi[$j]" )];
	    $$dest[$nic ++] = [( 'ACTION', "stackframe.-$mi[$j]" )];
	}
	$nic --;
    } elsif ($opc eq 'ASSMETHODCALL') {
	$x = shift @i;
	$object = shift @i;
	$method = shift @i;
	$n = pop @i;
	if ($object eq "") {
	    $call = $method;
	} else {
#	    $call = "$object.$method";
	    $call = "$method";
	}
	@mi = @{$$src[$n]};
	shift @mi;
	shift @mi;
	for ($j = 0; $j <= $#i; $j ++) {
	    $$dest[$nic ++] = [( 'ACTION', "stackframe.+$mi[$j]" )];
	    $$dest[$nic ++] = [( 'ACTION', "stackframe.$mi[$j] = $mi[$j]" )];
	    $$dest[$nic ++] = [( 'ACTION', "$mi[$j] = $i[$j]" )];
	}
	if ($object ne "") {
	    $$dest[$nic ++] = [( 'ACTION', 'stackframe.+this' )];
	    $$dest[$nic ++] = [( 'ACTION', 'stackframe.this = this' )];
	    $$dest[$nic ++] = [( 'ACTION', "this = $object" )];
	}
	$l = $method{$call};
	$$dest[$nic ++] = [( 'RETGOTO', $l, '?' )];
	if ($object ne "") {
	    $$dest[$nic ++] = [( 'ACTION', 'this = stackframe.this' )];
	    $$dest[$nic ++] = [( 'ACTION', 'stackframe.-this' )];
	}
	for ($j = 0; $j <= $#i; $j ++) {
	    $$dest[$nic ++] = [( 'ACTION', "$mi[$j] = stackframe.$mi[$j]" )];
	    $$dest[$nic ++] = [( 'ACTION', "stackframe.-$mi[$j]" )];
	}
	$$dest[$nic ++] = [( 'ACTION', "$x = that" )];
	$nic --;
    } else {
	$$dest[$nic] = [( $opc, @i )];
    }
}

#print "--------\n";
for ($ic = 0; $ic <= $#{$dest}; $ic ++) {
    @i = @{$$dest[$ic]};
    $s = PGLEcr->PrintStep(0, @i);
    if ($ic == $#{$dest}) {
	print "$s\n";
    } else {
	print "$s;\n";
    }
}
