
package main;

$VERSION = "0.02";

use PGLEc;
use PGLE;
use Generic;
use Input;
use Display;

PGLEc->Init('Input', 'Generic', 'Display');
PGLE->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLEc->Parse(0);
PGLEc->Check;
#PGLEc->Print(0);

my $ecprog = \@PGLEc::prog;
my $eprog = \@PGLE::prog;
my $ic;
my $nic;
my @i;
my $opc;
my $l;

for ($ic = 0, $nic = 0; $ic <= $#{$ecprog}; $ic ++, $nic ++) {
    @i = @{$$ecprog[$ic]};
#    PGLEc->PrintStep(0, @i);
#    print ";\n";
    $opc = shift @i;
    if ($opc eq 'LABEL') {
	$l = shift @i;
	$$eprog[$nic] = [( $opc, $l + $#{$ecprog} + 1 + 1 )];
    } elsif ($opc eq 'GOTO') {
	$l = shift @i;
	$$eprog[$nic] = [( $opc, $l + $#{$ecprog} + 1 + 1, '?' )];
    } elsif ($opc eq 'IFT') {
	$l = pop @i;
	$$eprog[$nic ++] = [( 'TESTF', @i )];
	$$eprog[$nic] = [( 'GOTO', $l + 1 - 1, '?' )];
    } elsif ($opc eq 'IFF') {
	$l = pop @i;
	$$eprog[$nic ++] = [( 'TESTT', @i )];
	$$eprog[$nic] = [( 'GOTO', $l + 1 - 1, '?' )];
    } elsif ($opc eq 'ELSE') {
	$l = pop @i;
	$$eprog[$nic ++] = [( 'GOTO', $l + 1 - 1, '?' )];
	$$eprog[$nic] = [( 'LABEL', $ic + 1, '?' )];
    } elsif ($opc eq 'ENDIF') {
	$$eprog[$nic] = [( 'LABEL', $ic + 1, '?' )];
    } else {
	$$eprog[$nic] = [( $opc, @i )];
    }
}

#print "--------\n";
for ($ic = 0; $ic <= $#{$eprog}; $ic ++) {
    @i = @{$$eprog[$ic]};
    $s = PGLE->PrintStep(0, @i);
    if ($ic == $#{$eprog}) {
	print "$s\n";
    } else {
	print "$s;\n";
    }
}
