
package main;

$VERSION = "0.03";

use PGLDg;
use PGLD;
use Generic;
use Input;
use Display;

PGLDg->Init('Input', 'Generic', 'Display');
PGLD->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLDg->Parse(0);
PGLDg->Check;
#PGLDg->Print(0);

my $dgprog = \@PGLDg::prog;
my $dprog = \@PGLD::prog;
my $ic;
my @i;
my $opc;
my $l;

for ($ic = 0; $ic <= $#{$dgprog}; $ic ++) {
    @i = @{$$dgprog[$ic]};
#    PGLDg->PrintStep(0, @i);
#    print ";\n";
    $opc = shift @i;
    if ($opc eq 'END') {
	$$dprog[$ic] = [( 'GOTOABS', 0, '?' )];
    } elsif ($opc eq 'LABEL') {
	$$dprog[$ic] = [( 'GOTOABS', $ic + 1 + 1, '?' )];
    } elsif ($opc eq 'GOTO') {
	$l = pop @i;
	$$dprog[$ic] = [( 'GOTOABS', $l + 1, '?' )];
    } else {
	$$dprog[$ic] = [( $opc, @i )];
    }
}

#print "--------\n";
for ($ic = 0; $ic <= $#{$dprog}; $ic ++) {
    @i = @{$$dprog[$ic]};
    $s = PGLD->PrintStep(0, @i);
    if ($ic == $#{$dprog}) {
	print "$s\n";
    } else {
	print "$s;\n";
    }
}
