
package main;

$VERSION = "0.00";

use PGLBu;
use PGLBg;
use Generic;
use Input;
use Display;

PGLBu->Init('Input', 'Generic', 'Display');
PGLBg->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLBu->Parse(0);
PGLBu->Check;

my $src = \@PGLBu::prog;
my $dest = \@PGLBg::prog;
my $ic;
my @i;
my $opc;
my $l;

sub label {
    my $l = shift;
    my $end = shift;

    if ($end eq "") {
	$s = "$l";
    } else {
	$s = "$l,$end";
    }
}

sub f_target {
    my $l = shift;
    my $ic = shift;
    my $rpos = shift;
    my $ulength = shift;

    if ($ulength eq "") {
	return label($l + $ic, "");
    } else {
	$ulength =~ /^(\d+)/;
	if ($ulength =~ /^(\d+),(.*)$/) {
	    $k = $1;
	    $ulength2 = $2;
	} else {
	    $ulength =~ /^(\d+)/;
	    $k = $1;
	    $ulength2 = "";
	}
	if ($l + $ic <= $k) {
	    $x = label($l + $ic, $rpos);
	    return $x;
	} else {
	    if ($rpos =~ /^(\d+),(.*)$/) {
		return f_target($l + $ic - $k, $1, $2, $ulength2);
	    } else {
		$rpos =~ /^(\d+)/;
		return f_target($l + $ic - $k, $1, "", $ulength2);
	    }
	}
    }
}

sub b_target {
    my $l = shift;
    my $ic = shift;
    my $rpos = shift;

    if ($rpos eq "") {
	if ($ic > $l) {
	    return label($ic - $l, "");
	} else {
	    return "0";
	}
    } else {
	if ($ic - $l >= 1) {
	    return label($ic -$l, $rpos);
	} else {
	    if ($rpos =~ /^(\d+),(.*)$/) {
		return b_target($l - $ic + 1, $1, $2);
	    } else {
		$rpos =~ /^(\d+)/;
		return b_target($l - $ic + 1, $1, "");
	    }
	}
    }
}

sub pglbu2pglbg {
    my $ulength = shift;
    my $rpos = shift;
    my $lnr;

    for ($lnr = 1; $ic <= $#{$src}; $ic ++, $lnr ++) {
	@i = @{$$src[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    $l = shift @i;
	    $$dest[$nic ++] = [( 'LABEL', label($lnr, $rpos) )];
	    $l = f_target($l, $lnr, $rpos, $ulength);
	    $$dest[$nic ++] = [( 'GOTO', $l, '?' )];
	} elsif ($opc eq 'GOTOB') {
	    $l = shift @i;
	    $$dest[$nic ++] = [( 'LABEL', label($lnr, $rpos) )];
	    $l = b_target($l, $lnr, $rpos);
	    $$dest[$nic ++] = [( 'GOTO', $l, '?' )];
	} elsif ($opc eq 'TESTT') {
	    $$dest[$nic ++] = [( 'LABEL', label($lnr, $rpos) )];
	    $$dest[$nic ++] = [( 'TESTT', @i )];
	    $l = f_target(1, $lnr, $rpos, $ulength);
	    $$dest[$nic ++] = [( 'GOTO', $l, '?' )];
	    $l = f_target(2, $lnr, $rpos, $ulength);
	    $$dest[$nic ++] = [( 'GOTO', $l, '?' )];
	} elsif ($opc eq 'TESTF') {
	    $$dest[$nic ++] = [( 'LABEL', label($lnr, $rpos) )];
	    $$dest[$nic ++] = [( 'TESTF', @i )];
	    $l = f_target(1, $lnr, $rpos, $ulength);
	    $$dest[$nic ++] = [( 'GOTO', $l, '?' )];
	    $l = f_target(2, $lnr, $rpos, $ulength);
	    $$dest[$nic ++] = [( 'GOTO', $l, '?' )];
	} elsif ($opc eq 'UNITSTART') {
	    $$dest[$nic ++] = [( 'LABEL', label($lnr, $rpos) )];
	    $ic ++;
	    pglbu2pglbg(label((pop @i) - $ic, $ulength), label($lnr, $rpos));
	} elsif ($opc eq 'UNITEND') {
	    return;
	} else {
	    $$dest[$nic ++] = [( 'LABEL', label($lnr, $rpos) )];
	    $$dest[$nic ++] = [( $opc, @i )];
	}
    }
}

$ic = 0;
$nic = 0;
pglbu2pglbg("", "");

for ($ic = 0; $ic <= $#{$dest}; $ic ++) {
    @i = @{$$dest[$ic]};
    $s = PGLBg->PrintStep(0, @i);
    if ($ic == $#{$dest}) {
	print "$s\n";
    } else {
	print "$s;\n";
    }
}
