
package main;

$VERSION = "0.05";

use PGLB;
use PGLA;
use Generic;
use Input;
use Display;

PGLB->Init('Input', 'Generic', 'Display');
PGLA->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLB->Parse(0);
PGLB->Check;

my $bprog = \@PGLB::prog;
my $aprog = \@PGLA::prog;
my $ic;
my @i;
my $opc;
my $l;

for ($ic = 0; $ic <= $#{$bprog}; $ic ++) {
    @i = @{$$bprog[$ic]};
    $opc = shift @i;
    if ($opc eq 'GOTO') {
	$l = shift @i;
	if ($ic + 1 + $l <= $#{$bprog} + 1) {
	    $$aprog[$ic] = [( $opc, $l, '?' )];
	} else {
	    $$aprog[$ic] = [( $opc, 0, '?' )];
	}
    } elsif ($opc eq 'GOTOB') {
	$l = shift @i;
	if ($l < $ic + 1) {
	    $$aprog[$ic] = [( 'GOTO', $#{$bprog} + 1 + 2 - $l, '?' )];
	} else {
	    $$aprog[$ic] = [( 'GOTO', 0, '?' )];
	}
    } elsif ($opc eq 'TESTT' || $opc eq 'TESTF') {
	$$aprog[$ic] = [( $opc, @i, '?' )];
    } else {
	$$aprog[$ic] = [( $opc, @i )];
    }
}
$$aprog[$ic ++] = [( 'GOTO', 0, '?' )];
$$aprog[$ic ++] = [( 'GOTO', 0, '?' )];
$$aprog[$ic ++] = [( 'REPEAT', $#{$bprog} + 1 + 2, '?' )];

for ($ic = 0; $ic <= $#{$aprog}; $ic ++) {
    @i = @{$$aprog[$ic]};
    $s = PGLA->PrintStep(0, @i);
    if ($ic == $#{$aprog}) {
	print "$s\n";
    } else {
	print "$s;\n";
    }
}
