
package main;

$VERSION = "0.00";

use PGLAu;
use PGLBu;
use Generic;
use Input;
use Display;

PGLAu->Init('Input', 'Generic', 'Display');
PGLBu->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLAu->Parse(0);
PGLAu->Check;

my $src = \@PGLAu::prog;
my $dest = \@PGLBu::prog;
my $ic;
my @i;
my $opc;
my $l;

my $nic = 0;

sub unitconv {
    my $start = shift;
    my $end = shift;
    my $maxl = 2;
    my $l;
    my $i;

    for ($ic = $start; $ic <= $end; $ic ++) {
	@i = @{$$src[$ic]};
	$opc = shift @i;
	if ($opc eq 'UNITSTART') {
	    $$dest[$nic ++] = [( 'UNITSTART', '?' )];
	    $l = pop @i;
	    $m = unitconv($ic + 1, $l - 1);
	    if ($m > $maxl) {
		$maxl = $m;
	    }
	    $ic = $l - 1;
	} elsif ($opc eq 'UNITEND') {
	    $$dest[$nic ++] = [( 'UNITEND', '?' )];
	} elsif ($opc eq 'GOTO') {
	    $l = shift @i;
	    if ($l > $maxl) {
		$maxl = $l;
	    }
	    $$dest[$nic ++] = [( 'GOTO', $l, '?' )];
	} elsif ($opc eq 'REPEAT') {
	    $l = shift @i;
	    for ($i = 0; $i < $maxl; $i ++) {
		$$dest[$nic ++] = [( 'GOTOB', $l, '?' )];
	    }
	    return $maxl;
	} else {
	    $$dest[$nic ++] = [( $opc, @i )];
	}
    }
    return $maxl;
}

unitconv(0, $#{$src});

for ($ic = 0; $ic <= $#{$dest}; $ic ++) {
    @i = @{$$dest[$ic]};
    $s = PGLBu->PrintStep(0, @i);
    $opc = shift @i;
    if ($ic == $#{$dest} || $opc eq 'UNITSTART') {
	print "$s\n";
    } else {
	@i = @{$$dest[$ic + 1]};
	$opc = shift @i;
	if ($opc eq 'UNITEND') {
	    print "$s\n";
	} else {
	    print "$s;\n";
	}
    }
}
