
package main;

$VERSION = "0.01";

use PGLAu;
use PGLB;
use Generic;
use Input;
use Display;

PGLAu->Init('Input', 'Generic', 'Display');
PGLB->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLAu->Parse(0);
PGLAu->Check;

my $src = \@PGLAu::prog;
my $dest = \@PGLB::prog;
my $ic;
my @i;
my $opc;
my $l;

# mapping of instructions to the real instructions
$ri = 0;
for ($ic = 0; $ic <= $#{$src}; $ic ++) {
    @i = @{$$src[$ic]};
    $opc = shift @i;
    if ($opc eq 'UNITSTART') {
	$map[$ic] = $ri;
    } elsif ($opc eq 'UNITEND') {
	$map[$ic] = $ri;
    } elsif ($opc eq 'TESTT' || $opc eq 'TESTF') {
	$map[$ic] = $ri;
	$ri ++;
	@i = @{$$src[$ic + 1]};
	$opc = shift @i;
	if ($opc eq 'UNITSTART') {
	    $ri += 2;
	}
    } elsif ($opc eq 'REPEAT') {
	$map[$ic] = $ri;
	$ri += 2;
    } else {
	$map[$ic] = $ri;
	$ri ++;
    }
}

for ($ic = 0, $nic = 0; $ic <= $#{$src}; $ic ++) {
    @i = @{$$src[$ic]};
    $opc = shift @i;
    if ($opc eq 'GOTO') {
	$l = pop @i;
	$rl = $map[$l] - $map[$ic];
	if ($rl < 0) {
	    $$dest[$nic ++] = [( 'GOTOB', - $rl, '?' )];
	} else {
	    $$dest[$nic ++] = [( 'GOTO', $rl, '?' )];
	}
    } elsif ($opc eq 'TESTT' || $opc eq 'TESTF') {
	$$dest[$nic ++] = [( $opc, @i )];
	@i = @{$$src[$ic + 1]};
	$opc = shift @i;
	if ($opc eq 'UNITSTART') {
	    $$dest[$nic ++] = [( 'GOTO', 2, '?' )];
	    $l = pop @i;
	    $rl = $map[$l + 1] - $nic;
	    $$dest[$nic ++] = [( 'GOTO', $rl, '?' )];
	}
    } elsif ($opc eq 'UNITSTART' || $opc eq 'UNITEND') {
	next;
    } elsif ($opc eq 'REPEAT') {
	$l = pop @i;
	$rl = $map[$ic] - $map[$l];
	$$dest[$nic ++] = [( 'GOTOB', $rl, '?' )];
	$$dest[$nic ++] = [( 'GOTOB', $rl, '?' )];
    } else {
	$$dest[$nic ++] = [( $opc, @i )];
    }
}

for ($ic = 0; $ic <= $#{$dest}; $ic ++) {
    @i = @{$$dest[$ic]};
    $s = PGLB->PrintStep(0, @i);
    if ($ic == $#{$dest}) {
	print "$s\n";
    } else {
	print "$s;\n";
    }
}
