
package main;

$VERSION = "0.01";

use PGLA;
use Generic;
use Input;
use Display;

PGLA->Init('Input', 'Generic', 'Display');

Input->Stream(\*STDIN);
PGLA->Parse(0);
PGLA->Check;
#PGLA->Print(1);

my $prog = \@PGLA::prog;
my $ic;
my @i;
my $opc;

sub inlist {
    my $n = shift;
    my $l = shift;
    my $i;

    foreach $i (@{$l}) {
	if ($i == $n) {
	    return 1;
	}
    }
    return 0;
}

sub jump {
    my $n = shift;
    my $repeat = shift;
    my $src = shift;
    my @list;
    my @i;
    my $opc;
    my $ic;

    $ic = $n;
    while (1) {
	if ($ic > $#{$src}) {
	    if ($repeat == -1) {
		return $n;
	    } else {
		$ic -= $repeat;
	    }
	}
	if ($ic < 0) {
	    return $n;
	}
	@i = @{$$src[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    push @list, $ic;
	    $ic = pop @i;
	    if (inlist($ic, \@list)) {
		return $n;
	    }
	} elsif ($opc eq 'REPEAT') {
	    push @list, $ic;
	    $ic = pop @i;
	    if (inlist($ic, \@list)) {
		return $n;
	    }
	} else {
	    return $ic;
	}
    }
}

sub back2forward {
    my $src = shift;
    my $rep = shift;
    my $ic;
    my @i;
    my $opc;
    my $n;

    # change backward jumps in forward jump
    if ($rep) {
	# backward jump can only occur if we have a repeat
	for ($ic = 0; $ic <= $#{$src}; $ic ++) {
	    @i = @{$$src[$ic]};
	    $opc = shift @i;
	    if ($opc eq 'GOTO') {
		$n = shift @i;
		if ($n < 0) {
		    if ($rep == 0) {
			$$src[$ic] = [( $opc, 0, '?' )];
		    } else {
			while ($n < 0) {
			    $n += $rep;
			}
			$$src[$ic] = [( $opc, $n, '?' )];
		    }
		}
	    }
	}
    }
    return $src;
}

### eliminate consecutive jumps and eliminate unused jumps
# resulting programs are in second canonical form except
# for that a program may have the form Zw (should be Y;Zw)

sub OptimizeJumps {
    my $src = shift;
    my $ic;
    my @i;
    my $opc;
    my $n;
    my @goto;
    my @use;
    my @map;
    my @dest;
    my $repeat;

    # define repeat
    @i = @{$$src[$#{$src}]};
    $opc = pop @i;
    if ($opc eq 'REPEAT') {
	$repeat = pop @i;
    } else {
	$repeat = -1;
    }
    # calculate jumps
    for ($ic = 0; $ic <= $#{$src}; $ic ++) {
	@i = @{$$src[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    $goto[$ic] = jump($ic, $repeat, $src);
	}
    }

    # mark instructions in use to which a jump is made
    for ($i = 0; $i <= $#goto; $i ++) {
	if (defined $goto[$i]) {
	    if ($goto[$i] != $i) {
		$use[$goto[$i]] = 1;
	    }
    #	print "$i -> $goto[$i]\n";
	}
    }

    # mark instructions in use and calculate mapping of instructions
    $nic = 0;
    for ($ic = 0; $ic <= $#{$src}; $ic ++) {
	@i = @{$$src[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    if ($use[$ic]) {
		$map[$ic] = $nic ++;
	    }
	} elsif ($opc eq 'TESTT' || $opc eq 'TESTF') {
	    $use[$ic] = 1;
	    $map[$ic] = $nic ++;
	    $use[$ic + 1] = 1;
	    $use[$ic + 2] = 1;
	} elsif ($opc eq 'REPEAT') {
	    $use[$ic] = 1;
	    $map[$ic] = $nic ++;
	} elsif ($opc eq 'END') {
	    $use[$ic] = 1;
	    $map[$ic] = $nic ++;
	} else {
	    $use[$ic] = 1;
	    $map[$ic] = $nic ++;
	    if ($ic < $#{$src}) {
		$use[$ic + 1] = 1;
	    }
	}
    }

    if (0) {
    for ($ic = 0; $ic <= $#use; $ic ++) {
	if (defined $use[$ic]) {
	    print "$ic => $map[$ic]\n";
	}
    }
    }

    # do the mapping and calculate the new labels
    $rep = 0;
    for ($ic = 0; $ic <= $#use; $ic ++) {
	if (defined $use[$ic]) {
	    @i = @{$$src[$ic]};
	    $opc = shift @i;
    #print "dest $map[$ic]\n";
	    if ($opc eq 'GOTO') {
    #	    $n = pop @i;
		$l = $map[$goto[$ic]] - $map[$ic];
    #print "$ic: $map[$ic]: $n $goto[$ic] $l\n";
		$dest[$map[$ic]] = [( $opc, $l, '?' )];
	    } elsif ($opc eq 'REPEAT') {
		$n = pop @i;
		if ($n >= 0) {
		    while (! defined $use[$n]) {
			$n ++;
		    }
		}
		$rep = $map[$ic] - $n;
		$dest[$map[$ic]] = [( $opc, $rep, '?' )];
	    } else {
		$dest[$map[$ic]] = [( $opc, @i )];
	    }
	}
    }

    $res = back2forward(\@dest, $rep);

    if (0) {
    for ($ic = 0; $ic <= $#dest; $ic ++) {
	@i = @{$dest[$ic]};
	$s = PGLA->PrintStep(0, @i);
	if ($ic == $#dest) {
	    print "$s\n";
	} else {
	    print "$s;\n";
	}
    }
    }
    return $res;
}

#### eliminate jumps to the next instructions

sub EliminateJumpNext {
    my $src = shift;
    my $testlast;
    my $nic;
    my @map;
    my $ic;
    my @i;
    my $opc;
    my $n;
    my @dest;

    # calculate mapping of instructions (skipping #1 if possible)
    $testlast = 0;
    $nic = 0;
    @map = ();
    for ($ic = 0; $ic <= $#{$src}; $ic ++) {
	@i = @{$$src[$ic]};
	$opc = shift @i;
	if ($opc eq 'GOTO') {
	    if ($testlast) {
		$testlast = 0;
	    } else {
		$n = shift @i;
		if ($n == 1) {
		    next;
		}
	    }
	} elsif ($opc eq 'TESTT' || $opc eq 'TESTF') {
	    $testlast = 1;
	} else {
	    $testlast = 0;
	}
	$map[$ic] = $nic ++;
    #print "$ic $map[$ic]\n";
    }

    # do the mapping and calculate the new labels
    for ($ic = 0; $ic <= $#{$src}; $ic ++) {
	if (! defined $map[$ic]) {
	    next;
	}
	@i = @{$$src[$ic]};
	$opc = shift @i;
    #print "$opc $map[$ic] = $ic\n";
	if ($opc eq 'GOTO') {
	    $n = shift @i;
	    $i = $ic + $n;
	    if ($i > $#{$src}) {
		$i -= $rep;
	    }
	    $n = $map[$i] - $map[$ic];
	    $dest[$map[$ic]] = [( $opc, $n, '?' )];
	} elsif ($opc eq 'REPEAT') {
	    $n = shift @i;
	    if ($ic < $n) {
		$rep = $n - ($ic - $map[$ic]);
	    } else {
		$rep = $map[$ic] - $map[$ic - $n];
	    }
	    $dest[$map[$ic]] = [( $opc, $rep, '?' )];
	} else {
	    $dest[$map[$ic]] = $$src[$ic];
	}
    }

    $res = back2forward(\@dest, $rep);

    return $res;
}

###

sub Print {
    my $src = shift;
    my $ic;
    my @i;
    my $s;

    for ($ic = 0; $ic <= $#{$src}; $ic ++) {
	@i = @{$$src[$ic]};
	$s = PGLA->PrintStep(0, @i);
	if ($ic == $#{$src}) {
	    print "$s\n";
	} else {
	    print "$s;\n";
	}
    }
}

$prog = OptimizeJumps($prog);
$prog = EliminateJumpNext($prog);
Print($prog);
