
set version 0.9

proc Msg {s} {
    global wmsg

    $wmsg insert end [subst -nocommands -novariables "$s"]
    $wmsg see end
    update
}

proc Wait {} {
    global wait

    set wait 1
    fileevent stdin readable { Input }
}

proc ClearWait {} {
    global wait

    fileevent stdin readable ""
    set wait 0
}

proc Input {} {
    global stop
    global disabled

    ### surrounded by ClearWait and Wait in order not to get nested calls
    ClearWait
    gets stdin line
    if {[regexp {^ack$} $line match]} {
	if {$disabled} {
	    EnableRun
	    set stop 1
	}
	ClearWait
	return
    } elseif {[regexp {^msg\((.*)\)$} $line match msg]} {
	Msg $msg
    } elseif {[regexp {^error\((.*)\)$} $line match msg]} {
	Msg "Error: $msg"
    } elseif {[regexp {^quit$} $line match]} {
	exit
    } elseif {[regexp {^runcontinue$} $line match id]} {
	if {$stop} {
	    puts "stop"
	} else {
	    puts "continue"
	}
    } elseif {[regexp {^list\((.*)\)$} $line match l]} {
	ProgView::AddLine $l
    } elseif {[regexp {^program\((.*)\)$} $line match prog]} {
	ProgView::Program $prog
    } elseif {[regexp {^pc\((.*)\)$} $line match pc]} {
	ProgView::PC $pc
    } else {
	if {$line != ""} {
	puts stderr "xxxx $line"
	}
    }
    ###
    Wait
}

proc Load {} {
    global wload
    global wait

    if {$wait} {
	return
    }
    set c [$wload.e get]
    if { $c == "" } {
	return
    }
    puts "l $c"
    Wait
}

proc DisableRun {} {
    global wload
    global wrun
    global wexec
    global woptions
    global wcore
    global wname
    global wtext
    global wbreak
    global disabled

    $wload.l configure -state disabled
    $wload.e configure -state disabled
    $wrun.run configure -state disabled
    $wrun.stop configure -state normal
    $wrun.step configure -state disabled
    $wrun.reset configure -state disabled
    $wrun.quit configure -state disabled
    $wexec.l configure -state disabled
    $wexec.e configure -state disabled
    $woptions.trace configure -state disabled
    $wcore.update configure -state disabled
    $wcore.dump configure -state disabled
    $wcore.init configure -state disabled
    ComboBox::State $wname.e disabled
    $wtext configure -state disabled
    ProgView::Disable
    $wbreak.clear configure -state disabled
    set disabled 1
}

proc EnableRun {} {
    global wload
    global wrun
    global wexec
    global woptions
    global wcore
    global wname
    global wtext
    global wbreak
    global disabled
    global nocore

    $wload.l configure -state normal
    $wload.e configure -state normal
    $wrun.run configure -state normal
    $wrun.stop configure -state disabled
    $wrun.step configure -state normal
    $wrun.reset configure -state normal
    $wrun.quit configure -state normal
    $wexec.l configure -state normal
    $wexec.e configure -state normal
    $woptions.trace configure -state normal
    if {! $nocore} {
	$wcore.update configure -state normal
	$wcore.dump configure -state normal
	$wcore.init configure -state normal
    }
    ComboBox::State $wname.e normal
    $wtext configure -state normal
    ProgView::Enable
    $wbreak.clear configure -state normal
    set disabled 0
}

proc Run {} {
    global stop
    global wait

    if {$wait} {
	return
    }

    DisableRun
    set stop 0
    puts "r"
    Wait
}

proc Stop {} {
    global stop
    global wrun

    $wrun.stop configure -state disabled
    set stop 1
}

proc Step {} {
    global wait

    if {$wait} {
	return
    }
    puts "s"
    Wait
}

proc Reset {} {
    global wait

    if {$wait} {
	return
    }
    puts "reset"
    Wait
}

proc Quit {} {
    global wait

    if {$wait} {
	return
    }
    puts "q"
    Wait
}

proc Execute {} {
    global wexec
    global stop
    global wait

    if {$wait} {
	return
    }

    set c [$wexec.e get]
    if { $c == "" } {
	return
    }
    DisableRun
    # set stop 0
    # stop for execution of eval constructions
    set stop 1
    puts "e $c"
    Wait
}

proc Trace {} {
    global trace
    global wait

    if {$wait} {
	return
    }

    if {$trace} {
	puts "t+"
    } else {
	puts "t-"
    }
    Wait
}

proc CoreUpdates {} {
    global coreupdates
    global wait

    if {$wait} {
	return
    }

    if {$coreupdates} {
	puts "u+"
    } else {
	puts "u-"
    }
    Wait
}

proc CoreDump {} {
    global wait

    if {$wait} {
	return
    }
    puts "d"
    Wait
}

proc CoreInitialize {} {
    global wait

    if {$wait} {
	return
    }
    puts "i"
    Wait
}

proc SetProgram {p} {
    global wait

    if {$wait} {
	return
    }
    puts "lc $p"
    Wait
}

proc SetBreakpoint {bp o} {
    global wait

    if {$wait} {
	return
    }
    if {$o} {
	puts "b+ $bp"
    } else {
	puts "b- $bp"
    }
    Wait
}

proc ClearBreakpoints {} {
    global wait

    if {$wait} {
	return
    }
    ProgView::ClearBreakpoints
    update
    puts "bc"
    Wait
}

proc Initialize {} {
    global name
    global wmsg
    global wload
    global wrun
    global wexec
    global woptions
    global wcore
    global wname
    global wftext
    global wtext
    global wbreak
    global stop
    global size
    global disabled
    global nocore

    wm title . "$name"
    set w .g
    frame $w -bd 0 -relief raised
    pack $w -expand 1 -fill both

    # Commands
    frame $w.comm -bd 1 -relief raised
#    pack $w.comm -expand 1 -fill both
    label $w.comm.l -text "Commands"
    frame $w.comm.f
	# load
    set load $w.comm.f.load
    set wload [frame $load -bd 2 -relief groove]
    label $load.l -text "load"
    entry $load.e -width 16 -highlightthickness 0
    pack $load.l $load.e -in $load -side left -padx 2 -pady 2
    bind $wload.e <Return> { Load }
	# run
    set run $w.comm.f.run
    set wrun [frame $run -bd 2 -relief groove]
    button $run.run -text "run" -takefocus 0 -command { Run }
    button $run.stop -text "stop" -takefocus 0 -command { Stop } -state disabled
    button $run.step -text "step" -takefocus 0 -command { Step }
    button $run.reset -text "reset" -takefocus 0 -command { Reset }
    button $run.quit -text "quit" -takefocus 0 -command { Quit }
    set stop 1
    pack $run.run $run.stop $run.step $run.reset $run.quit -in $run \
	-side left -padx 2 -pady 2
	# exec
    set exec $w.comm.f.exec
    set wexec [frame $exec -bd 2 -relief groove]
    label $exec.l -text "execute"
    entry $exec.e -width 32 -highlightthickness 0
    pack $exec.l $exec.e -in $exec -side left -padx 2 -pady 2
    bind $wexec.e <Return> { Execute }
	# options
    set opt $w.comm.f.opt
    set woptions [frame $opt -bd 2 -relief groove]
    checkbutton $opt.trace -text "trace" -indicatoron 1 -takefocus 0 \
	-variable trace -command { Trace }
#    checkbutton $opt.fluid -text "fluid updates" -indicatoron 1 -takefocus 0 \
#	-variable coreupdates -command { CoreUpdates }
    set ::coreupdates 1
    pack $opt.trace -in $opt -side top -anchor w -padx 2 -pady 2
	# core
    set core $w.comm.f.core
    set wcore [frame $core -bd 2 -relief groove]
    label $core.l -text "core"
    button $core.dump -text "dump" -takefocus 0 -command { CoreDump }
    button $core.init -text "initialize" -takefocus 0 -command { CoreInitialize }
    checkbutton $core.update -text "updates" -indicatoron 1 -takefocus 0 \
	-variable coreupdates -command { CoreUpdates }
    if {$nocore} {
	$core.update configure -state disabled
	$core.l configure -state disabled
	$core.dump configure -state disabled
	$core.init configure -state disabled
    }
    pack $core.l $core.dump $core.init $core.update -in $core -side left -padx 2 -pady 2

    pack $load $run $exec $opt $core -in $w.comm.f -padx 2 -pady 2 -expand 1 -fill both
    pack $w.comm.l $w.comm.f -in $w.comm -padx 4 -pady 4

    # Console
    frame $w.msg -bd 1 -relief raised
#    pack $w.msg -expand 1 -fill both
    label $w.msg.l -text "Console"
    frame $w.msg.text
	# text
    frame $w.msg.text.f -bd 1 -relief sunken
    set wmsg [text $w.msg.text.f.te -bd 0 -width 40 -height 15 -takefocus 0 \
	-highlightthickness 0 -yscrollcommand "$w.msg.text.sbv set"]
    pack $w.msg.text.f.te -in $w.msg.text.f -expand 1 -fill both
    scrollbar $w.msg.text.sbv -width 8 -bd 1 -highlightthickness 0 \
	-orient vertical -takefocus 0 -command " $w.msg.text.f.te yview "
#    pack $w.msg.text.f -in $w.msg.text -side left \
	-expand 1 -fill both
#    pack $w.msg.text.sbv -in $w.msg.text -side left -expand 1 -fill y
    grid $w.msg.text.f -in $w.msg.text -row 0 -column 0 -sticky nsew
    grid $w.msg.text.sbv -in $w.msg.text -row 0 -column 1 -sticky ns
    grid columnconfig $w.msg.text 0 -weight 1
    grid columnconfig $w.msg.text 1 -weight 0
    grid rowconfig $w.msg.text 0 -weight 1

    pack $w.msg.l -in $w.msg -side top -padx 4 -pady 4
    pack $w.msg.text -in $w.msg -side top -padx 4 -pady 4 -expand 1 -fill both

    # Program
    frame $w.prog -bd 1 -relief raised
#    pack $w.prog -expand 1 -fill both
    label $w.prog.l -text "Program"
    frame $w.prog.f
	# current
    set curr $w.prog.f.curr
    frame $curr -bd 2 -relief groove
	    # name
    set name $curr.name
    set wname [frame $name]
    label $name.l -text "name"
#    entry $name.e -width 16 -bd 1 -textvariable programname -takefocus 0
    ComboBox::Create $name.e 16 0 SetProgram
    pack $name.l $name.e -in $name -side left -padx 2 -pady 2
	    # list
    set list $curr.list
    frame $list
    set wftext [frame $list.f -bd 1 -relief sunken]
    set wtext [text $list.f.te -bd 0 -width 24 -height 24 -wrap none -takefocus 0 \
	-highlightthickness 0 -cursor arrow \
	-xscrollcommand "$list.sbh set" -yscrollcommand "$list.sbv set"]
    pack $list.f.te -in $list.f -expand 1 -fill both
    scrollbar $list.sbh -width 8 -bd 1 -highlightthickness 0 \
	-orient horizontal -command "$list.f.te xview" -takefocus 0
    scrollbar $list.sbv -width 8 -bd 1 -highlightthickness 0 \
	-orient vertical -command "$list.f.te yview" -takefocus 0
    grid $list.f -in $list -column 0 -row 0 -sticky nsew
    grid $list.sbv -in $list -column 1 -row 0 -sticky ns
    grid $list.sbh -in $list -column 0 -row 1 -sticky ew
    grid rowconfig $list 0 -weight 1
    grid rowconfig $list 1 -weight 0
    grid columnconfig $list 0 -weight 1
    grid columnconfig $list 1 -weight 0
    pack $name -in $curr -padx 2 -pady 2
    pack $list -in $curr -padx 2 -pady 2 -expand 1 -fill both
	# breakpoints
    set bp $w.prog.f.bp
    set wbreak [frame $bp -bd 2 -relief groove]
    button $bp.clear -text "clear breakpoints" -takefocus 0 -command { ClearBreakpoints }
    pack $bp.clear -in $bp -padx 2 -pady 2

#    pack $curr -in $w.prog.f -side top -padx 2 -pady 2 -expand 1 -fill both
#    pack $bp -in $w.prog.f -side top -padx 2 -pady 2
    grid $curr -in $w.prog.f -column 0 -row 0 -sticky nsew -padx 2 -pady 2
    grid $bp -in $w.prog.f -column 0 -row 1 -sticky nsew -padx 2 -pady 2
    grid columnconfig $w.prog.f 0 -weight 1
    grid rowconfig $w.prog.f 0 -weight 1
    grid rowconfig $w.prog.f 1 -weight 0
    pack $w.prog.l -in $w.prog -side top -padx 4 -pady 4
    pack $w.prog.f -in $w.prog -side top -padx 4 -pady 4 -expand 1 -fill both

    grid $w.comm -in $w -column 0 -row 0 -sticky ns
    grid $w.prog -in $w -column 1 -row 0 -sticky nsew
    grid $w.msg ^ -in $w -column 0 -row 1 -sticky nsew
    grid rowconfig $w 0 -weight 0
    grid rowconfig $w 1 -weight 1
    grid columnconfig $w 0 -weight 0
    grid columnconfig $w 1 -weight 1

    focus $wexec.e

    update

    bind Text <1> {}
    bind Text <B1-Motion> {}
    bind Text <Double-1> {}
    bind Text <Triple-1> {}

    set size(w) [winfo width $w]
    set size(h) [winfo height $w]
    set size(wftext) [winfo width $wftext]
    set size(hftext) [winfo height $wftext]

    ProgView::Init $list.f.te $name.e
    set disabled 0

    fconfigure stdout -translation lf
}


# options
set name "Gui"
set nocore 0
for {set i 0} {$i < $argc} {incr i} {
    set a [lindex $argv $i]
    if {$a == "-gn"} {
        incr i
        set name [lindex $argv $i]
    } elseif {$a == "-NC"} {
	set nocore 1
    }
}

package require ProgView
package require ComboBox

Initialize

Wait
