
package main;

$VERSION = "0.05";

use Options;
use Input;

&Options::Get;

if (defined $::gui) {
    $ui = 'GUI';
} else {
    $ui = 'TUI';
}
if (defined $::language) {
    $lang = $::language;
    @llist = split(":", $::language);
} else {
    $lang = 'PGLA';
    @llist = ('PGLA');
}
if (defined $::basic) {
    $bi = $::basic;
} else {
    $bi = 'MPP';
}
if (defined $::thread) {
    $kernel = 'ThreadKernel';
} else {
    $kernel = 'Kernel';
}
foreach $l (@::library) {
    unshift(@INC, $l);
}

foreach $lang (@llist) {
if (! eval {require "$lang.pm"}) {
    die "language module $lang not found\n";
} else {
    $m = "${lang}::Exec";
    die "language module $lang does not support execution\n" unless defined &{$m};
}
}
if (! eval {require "$bi.pm"}) {
    die "basic instructions module $bi not found\n";
}
if (! eval {require "$ui.pm"}) {
    die "interface module $ui not found\n";
}
if (! eval {require "$kernel.pm"}) {
    die "interface module $kernel not found\n";
}

$b = $bi;
while ($#llist > 0) {
    $lang = pop @llist;
    $lang->Init($b);
    $b = $lang;
}
$lang = pop @llist;
$lang->Init('Input', $b, $ui);
# $ui->Run($lang);
$kernel->Run($lang, $ui);
