
package main;

$VERSION = "0.04";

use Input;
use Display;

sub usage {
    die "usage: $0 [-v] [-p [-l]] [-P primitives] [-B basic-instructions] [-L library] file\n       $0 [-v] [-p [-l]] [-i] [-P primitives] [-B basic-instructions] [-L library]\n";
}

$language = 'PGLA';
$basic = 'Generic';
$verbose = 0;
$print = 0;
$linenumbers = 0;
$fromstdin = 0;
@llist = ();
while ($_ = $ARGV[0], /^-/) {
    shift;
    if (/^-P$/) {
	@llist = split(":", shift);
    } elsif (/^-B$/) {
        $basic = shift;
    } elsif (/^-v$/) {
	$verbose = 1;
    } elsif (/^-p$/) {
	$print = 1;
    } elsif (/^-l$/) {
	$linenumbers = 1;
    } elsif (/^-i$/) {
	$fromstdin = 1;
    } elsif (/^-L$/) {
	push @library, shift;
    } else {
	usage;
    }
}
if ($#llist == -1) {
    @llist = ('PGLA');
}
if ($#ARGV != 0 && (! $fromstdin && $#ARG == -1)) {
    usage;
}
foreach $l (@library) {
    unshift(@INC, $l);
}

foreach $l (@llist) {
    if (! eval {require "$l.pm"}) {
	die "module $l not found\n";
    }
}
if (! eval {require "$basic.pm"}) {
    die "module $basic not found\n";
}

$b = $basic;
while ($#llist > 0) {
    $l = pop @llist;
    $l->Init($b);
    $b = $l;
}
$language = pop @llist;
$language->Init('Input', $b, 'Display');


if ($fromstdin) {
    *FH = *STDIN;
} else {
    open(FH, "$ARGV[0]") || die "could not open $ARGV[0]\n";
}

Input->Stream(\*FH);
$errors = $language->Parse($verbose);
if ($verbose) {
    print "\n";
}
if (! $fromstdin) {
    close FH;
}
if ($errors) {
    print "parse errors: $errors\n";
}
$language->Check;
if ($print) {
    $language->Print($linenumbers);
}

exit $errors;
