
set version 0.01

proc Initialize {} {
    global w
    global W
    global returnvalue

    wm title . "Generic"
    set w .f
    frame $w
    pack $w -expand 1 -fill both
    frame $w.h -relief raised -border 2
    frame $w.h.text
    frame $w.h.text.f -bd 1 -relief sunken
    set W [text $w.h.text.f.te -bd 0 -width 20 -height 20 -takefocus 0 \
	-highlightthickness 0 -yscrollcommand "$w.h.text.sbv set"]
    pack $w.h.text.f.te -in $w.h.text.f -expand 1 -fill both
    scrollbar $w.h.text.sbv -width 8 -bd 1 -highlightthickness 0 \
	-orient vertical -takefocus 0 -command "$w.h.text.f.te yview "
    grid $w.h.text.f -in $w.h.text -row 0 -column 0 -sticky nsew
    grid $w.h.text.sbv -in $w.h.text -row 0 -column 1 -sticky ns

    pack $w.h.text -in $w.h

    frame $w.h.return
    label $w.h.return.l -text "return"
    radiobutton $w.h.return.t -text "T" -indicatoron 1 -variable returnvalue \
	-value 1 -takefocus 0
    radiobutton $w.h.return.f -text "F" -indicatoron 1 -variable returnvalue \
	-value 0 -takefocus 0
    set returnvalue 1
    pack $w.h.return.l $w.h.return.t $w.h.return.f -in $w.h.return -side left
    pack $w.h.return -in $w.h
    
    pack $w.h -in $w -expand 1 -fill both
}

proc Reset {} {
    global w

    destroy $w.f
    frame $w.f
    pack $w.f -expand 1 -fill both
    pack $w.f -in $w -expand 1 -fill both
}

proc Perform {a} {
    global W
    global returnvalue

    $W insert end [subst -nocommands -novariables "$a\n"]
    $W see end
    update
    return $returnvalue
}

proc ReadInput {} {
    gets stdin line
    if {[regexp {^quit$} $line match]} {
	exit
    } elseif {[regexp {^reset$} $line match]} {
	Reset
    } elseif {[regexp {^action *([^ ]*)$} $line match action]} {
#	puts stderr "line: $action -"
	set r [Perform $action]
	puts "$r"
    } else {
	puts stderr "no match"
    }
}

for {set i 0} {$i < $argc} {incr i} {
    set a [lindex $argv $i]
#    if {[string index $a 0] == "."} {
#	regsub {^\.} $a "/home/bobd/PGA/src" a
#    }
    lappend auto_path $a
}

Initialize

fileevent stdin readable ReadInput
