
package main;

$VERSION = "0.02";

use Global;
use Input;
use Display;

use CG;

sub usage {
    die "usage: $0 [-P primitives] [-B basic-instructions] [-L library] file\n";
}

$language = 'PGLEc';
$basic = 'MSPio';
$target = 'PIR';
while ($_ = $ARGV[0], /^-/) {
    shift;
    if (/^-P$/) {
        $language = shift;
    } elsif (/^-B$/) {
        $basic = shift;
    } elsif (/^-T$/) {
        $target = shift;
    } elsif (/^-L$/) {
	$s = shift;
        push @library, $s;
	Global::Set('LIBDIR', $s);
    } else {
        usage;
    }
}
#if ($#ARGV != 0) {
#    usage;
#}
foreach $l (@library) {
    unshift(@INC, $l);
}

if (! eval {require "$language.pm"}) {
    die "module $language not found\n";
}
if (! eval {require "$basic.pm"}) {
    die "module $basic not found\n";
}
if (! CG::Init($target)) {
    die "module $target not found\n";
}
import CG;
$languagecg = $language . "_CG";
if (! eval {require "$languagecg.pm"}) {
    die "module $languagecg not found\n";
}
$basiccg = $basic . "_CG";
if (! eval {require "$basiccg.pm"}) {
    die "module $basiccg not found\n";
}

$language->Init('Input', 'MSPio', 'Display');

Input->Stream(\*STDIN);
if ($language->Parse(0)) {
    print STDERR "parse errors.\n";
    exit 1;
}
$language->Check();

### Code Generation

$languagecg->Init($basiccg);

$date = localtime(time);
OutputComment("Generated by gencompiler from language $language.$basic");
OutputComment("Date: $date");
OutputPre();

my $src = $language->Mem;
my $ic;
for ($ic = 0; $ic <= $#{$src}; $ic ++) {
    @i = @{$$src[$ic]};
    $l = getInstrLabel($ic);
    $s = $language->PrintStep(0, @i);
    OutputLabel($l, $s);
    $languagecg->CG($ic, @i);
}
# extra label in case program ended in ;
$l = getInstrLabel($ic);
OutputLabel($l);

OutputPost();
