
set version 0.12

proc Resize {} {
    global c

    set p [winfo parent $c]
    set fwidth [expr [winfo width $p] - 4]
    set fheight [expr [winfo height $p] - 4]
    $c configure -width $fwidth -height $fheight
}

proc Print {} {
    global g
    global print

    if {[catch {open "$print(file)" w} fh]} {
	tk_messageBox -icon error -type ok -message "Unable to open file '$print(file)'"
	return
    }
    $g write $fh $print(type)
    close $fh
}

proc PopupPrint {} {
    set w .print
    set x [winfo pointerx .]
    set y [winfo pointery .]
    wm geometry $w "+$x+$y"
    wm deiconify $w
    tkwait visibility $w
    grab $w
}

proc PopdownPrint {} {
    set w .print
    wm withdraw $w
    grab release $w
}

proc InitPrint {} {
    global print

    toplevel .print
    wm withdraw .print
    wm transient .print .

    set f .print.file
    frame $f -relief raised -bd 1
    pack $f

    label $f.l -text "File" -width 5 -anchor w
    entry $f.e -width 20 -textvariable print(file)
    set print(file) "fluiddump"
    pack $f.l $f.e -in $f -side left -pady 1
    pack $f -in .print -fill both -expand 1

    set f .print.type
    frame $f -relief raised -bd 1
    pack $f
    radiobutton $f.ps -text "ps" -variable print(type) -value ps
    radiobutton $f.mif -text "mif" -variable print(type) -value mif
    radiobutton $f.hpgl -text "hpgl" -variable print(type) -value hpgl
    radiobutton $f.gif -text "gif" -variable print(type) -value gif
    radiobutton $f.plain -text "plain" -variable print(type) -value plain
    radiobutton $f.dot -text "dot" -variable print(type) -value dot
    $f.ps select
    pack $f.ps $f.mif $f.hpgl $f.gif $f.plain $f.dot -in $f -anchor w
    pack $f -in .print -fill both -expand 1

    set f .print.butt
    frame $f -relief raised -bd 1
    pack $f
    button $f.print -text "Print" \
	-command {
	    Print
	    PopdownPrint
	}
    button $f.cancel -text "Cancel" \
	-command {
	    PopdownPrint
	}
    pack $f.print $f.cancel -in $f -side left -fill none -expand 1
    pack $f -in .print -fill both -expand 1
}

proc Initialize {} {
    global c
    global basic

    wm title . "Fluid$basic"
    set w .g
    frame $w -bd 1 -relief raised
    pack $w -expand 1 -fill both

    frame $w.f -bd 1 -relief sunken
    pack $w.f
    set c [canvas $w.f.c -bd 0 -xscrollcommand "$w.sbh set" -yscrollcommand "$w.sbv set"]
    pack $c -in $w.f -expand 1 -fill both
    scrollbar $w.sbv -width 8 -bd 1 -highlightthickness 0 -orient vertical -command " $w.f.c yview "
    scrollbar $w.sbh -width 8 -bd 1 -highlightthickness 0 -orient horizontal -command " $w.f.c xview "
    frame $w.resize -background gray70

    grid $w.f -in $w -column 0 -row 0 -sticky nsew
    grid $w.sbv -in $w -column 1 -row 0 -sticky ns
    grid $w.sbh -in $w -column 0 -row 1 -sticky ew
    grid $w.resize -in $w -column 1 -row 1 -sticky nsew
    grid rowconfig $w 0 -weight 1
    grid rowconfig $w 1 -weight 0
    grid columnconfig $w 0 -weight 1
    grid columnconfig $w 1 -weight 0

    update
    bind $c <Configure> { Resize }
#    bind $c <ButtonPress-2> { $c scan mark %x %y }
#    bind $c <B2-Motion> { $c scan dragto %x %y }
    bind $c <ButtonPress-1> { $c scan mark %x %y }
    bind $c <B1-Motion> { $c scan dragto %x %y }
    bind $c <Button-4> { $c yview scroll -1 units }
    bind $c <Button-5> { $c yview scroll 1 units }
    bind $c <ButtonPress-3> { PopupPrint }
    bind $c <ButtonPress-3> { PopupPrint }
    bind . <ButtonPress-3> { PopupPrint }
    bind . <Control-p> { PopupPrint }

    bind $w.resize <ButtonPress-1> {
        bind %W <Motion> \
            [string map [list WIDTH  [winfo width .] HEIGHT [winfo height .]] \
                 {
                     wm geometry . \
                         [expr {WIDTH+(%%X - %X)}]x[expr {HEIGHT+(%%Y - %Y)}]
                 }
	    ]
    }
    bind $w.resize <ButtonRelease-1> {
        bind %W <Motion> {}
    }

    update
    InitPrint
}

proc ReadInput {} {
    gets stdin line
    if {[regexp {^new\((.*), (.*)\)$} $line match x n]} {
	Fluid::AddFocus $x $n
    } elseif {[regexp {^remfocus\((.*)\)$} $line match x]} {
	Fluid::DelFocus $x
    } elseif {[regexp {^addfield\((.*), (.*)\)$} $line match x f]} {
	Fluid::AddField $x $f
    } elseif {[regexp {^addvalfield\((.*), (.*), (.*), (\".*\"), (.*)\)$} $line match x f t v n]} {
# match string value possibly containing ', '
	Fluid::AddValField $x $f $t $v $n
    } elseif {[regexp {^addvalfield\((.*), (.*), (.*), (.*), (.*)\)$} $line match x f t v n]} {
	Fluid::AddValField $x $f $t $v $n
    } elseif {[regexp {^delfield\((.*), (.*)\)$} $line match x f]} {
	Fluid::DelField $x $f
    } elseif {[regexp {^delvalfield\((.*), (.*)\)$} $line match x f]} {
	Fluid::DelValField $x $f
    } elseif {[regexp {^setfield\((.*), (.*), (.*)\)$} $line match x f y]} {
	Fluid::SetField $x $f $y
    } elseif {[regexp {^setfieldnew\((.*), (.*), (.*)\)$} $line match x f y]} {
	Fluid::SetFieldNew $x $f $y
    } elseif {[regexp {^setvalfield\((.*), (.*), (.*)\)$} $line match x f v]} {
	Fluid::SetValField $x $f $v
    } elseif {[regexp {^selfield\((.*), (.*), (.*)\)$} $line match x y f]} {
	Fluid::SelField $x $y $f
    } elseif {[regexp {^setfocus\((.*), (.*)\)$} $line match x y]} {
	Fluid::SetFocus $x $y
    } elseif {[regexp {^setvalfocus\((.*), (\".*\"), (.*)\)$} $line match x y n]} {
# match string value possibly containing ', '
	Fluid::SetValFocus $x $y $n
    } elseif {[regexp {^setvalfocus\((.*), (.*), (.*)\)$} $line match x y n]} {
	Fluid::SetValFocus $x $y $n
    } elseif {[regexp {^rematom\((.*)\)$} $line match n]} {
	Fluid::DelAtom $n
    } elseif {[regexp {^reset$} $line match]} {
	Fluid::Reset
	update
    } elseif {[regexp {^quit$} $line match]} {
	exit
    } elseif {[regexp {^dump$} $line match]} {
	Fluid::Dump
    } elseif {[regexp {^doupdates\((.*)\)$} $line match u]} {
	Fluid::SetUpdate $u
    } elseif {[regexp {^update$} $line match]} {
	Fluid::Update
    } else {
	puts stderr "unknown command '$line'"
	return;
    }
    puts "ack";
}

package require Fluid

# options
set fontsize 12
set basic ""
for {set i 0} {$i < $argc} {incr i} {
    set a [lindex $argv $i]
    if {$a == "-fs"} {
	incr i
	set fontsize [lindex $argv $i]
    } elseif {$a == "-b"} {
	incr i
	set basic " - [lindex $argv $i]"
    }
}

Initialize

# get rid of warning from tcldot for missing package Tkspline
set __tkgen_smooth_type true

Fluid::FontSize $fontsize
Fluid::Init

fileevent stdin readable ReadInput
