
namespace eval smnns {
    package provide smnns 0.1
    variable init 0
}

proc smnns::New {w n} {
    variable init
    variable frame
    variable reg

    if {! [winfo exists $w.smnns]} {
	set mw $w.smnns
	frame $mw -border 1 -relief raised
	label $mw.l -text "Natural Number Stacks"
	frame $mw.f
	pack $mw.l $mw.f -in $mw
	pack $mw -in $w -expand 1 -fill both
	set frame $mw.f
	set init 1
    }
    frame $frame.w$n
    label $frame.w$n.l -text "$n"
    frame $frame.w$n.f
    pack $frame.w$n.f
    scrollbar $frame.w$n.f.sb -orient vertical -width 8 -border 1 \
	-command "$frame.w$n.f.l yview"
    listbox $frame.w$n.f.l -width 5 -height 5 -border 1 \
	-yscrollcommand "$frame.w$n.f.sb set"
    pack $frame.w$n.f.sb $frame.w$n.f.l -in $frame.w$n.f -side left -expand 1 -fill both
    pack $frame.w$n.l $frame.w$n.f -in $frame.w$n -side top
    pack $frame.w$n -in $frame -side left
}

proc smnns::Push {w n a} {
    variable frame

    $frame.w$n.f.l insert 0 $a
    $frame.w$n.f.l yview 0
}

proc smnns::Pop {w n} {
    variable frame

    $frame.w$n.f.l delete 0
    $frame.w$n.f.l yview 0
}
