
package smnns;

$VERSION = "0.00";

use SMView;

sub new {
    my $type = shift;
    my $o = shift;
    my $self = {};

    SMView::Send($o, "new");
    $self->{stack} = [];
    $self->{name} = $o;
    return bless $self, $type;
}

sub topEq {
    my $self = shift;
    my $v = shift;

    $t = $#{$self->{stack}};
    if ($t < 0) {
	return 0;
    }
    if (${$self->{stack}}[$t] == $v) {
	return 1;
    } else {
	return 0;
    }
}

sub push {
    my $self = shift;
    my $v = shift;

    push @{$self->{stack}}, $v;
    SMView::Send($self->{name}, "push", $v);
    return 1;
}

sub pop {
    my $self = shift;

    if ($#{$self->{stack}} >= 0) {
	pop @{$self->{stack}};
	SMView::Send($self->{name}, "pop");
    }
    return 1;
}

sub dump {
    my $self = shift;
    my $s;

    $s = join(", ", @{$self->{stack}});
    print STDERR "stack $self->{name}: $s\n";
    return 1;
}

1;
