
namespace eval smbr {
    package provide smbr 0.1
    variable init 0
}

proc smbr::New {w n} {
    variable init
    variable frame
    variable reg

    if {! [winfo exists $w.smbr]} {
	set mw $w.smbr
	frame $mw -border 1 -relief raised
	label $mw.l -text "Boolean Registers"
	frame $mw.f
	pack $mw.l $mw.f -in $mw
	pack $mw -in $w -expand 1 -fill both
	set frame $mw.f
	set init 1
    }
    frame $frame.w$n
    label $frame.w$n.l -text "$n"
    label $frame.w$n.e -textvariable smbr::reg($n) -width 5 -relief sunken -border 1
    pack $frame.w$n.l $frame.w$n.e -in $frame.w$n -side left
    pack $frame.w$n -in $frame -anchor e
    set reg($n) false
}

proc smbr::Set {w n a} {
    variable reg

    set reg($n) $a
}
