
namespace eval semaphore {
    package provide semaphore 0.1
    variable init 0
}

proc semaphore::New {w n} {
    variable init
    variable frame
    variable sem

    if {! [winfo exists $w.sem]} {
	set mw $w.sem
	frame $mw -border 1 -relief raised
	label $mw.l -text "Semaphores"
	frame $mw.f
	pack $mw.l $mw.f -in $mw
	pack $mw -in $w -expand 1 -fill both
	set frame $mw.f
	set init 1
    }
    frame $frame.w$n
    label $frame.w$n.l -text "$n"
    label $frame.w$n.e -textvariable semaphore::sem($n) -width 8 -relief sunken -border 1
    pack $frame.w$n.l $frame.w$n.e -in $frame.w$n -side left
    pack $frame.w$n -in $frame -anchor e
    set sem($n) unlocked
}

proc semaphore::Lock {w n} {
    variable sem

    set sem($n) "locked"
}

proc semaphore::Unlock {w n} {
    variable sem

    set sem($n) "unlocked"
}
