
package semaphore;

$VERSION = "0.00";

use SMView;

sub new {
    my $type = shift;
    my $o = shift;
    my $self = {};

    SMView::Send($o, "new");
    $self->{lock} = 0;
    $self->{name} = $o;
    return bless $self, $type;
}

sub lock {
    my $self = shift;

    if ($self->{lock}) {
	return 0;
    }
    $self->{lock} = 1;
    SMView::Send($self->{name}, "lock");
    return 1;
}

sub unlock {
    my $self = shift;

    $self->{lock} = 0;
    SMView::Send($self->{name}, "unlock");
    return 1;
}

sub dump {
    my $self = shift;

    print STDERR "semaphore $self->{name}: ", $self->{lock} ? "locked" : "unlocked", " \n";
}

1;
