
set version 0.1

proc rec-ack-event { n } {
}

proc rec-terminate { n } {
    destroy .
}

proc New {} {
    global primitive
    global basic
    global program

    sendTB "snd-event(new(\"$primitive\", \"$basic\", \"$program\"))"
}

proc CoreUpdates {} {
    global coreupdates

    sendTB "snd-event(setupdate($coreupdates))"
}

frame .f -bd 0
pack .f
###
set sim .f.sim
frame $sim -bd 1 -relief raised
frame $sim.prim -bd 0
label $sim.prim.l -text "Primitive"
entry $sim.prim.e -width 16 -textvariable primitive
pack $sim.prim.l $sim.prim.e -in $sim.prim -side left
frame $sim.prog -bd 0
label $sim.prog.l -text "Program" -width 9
entry $sim.prog.e -width 16 -textvariable program
pack $sim.prog.l $sim.prog.e -in $sim.prog -side left
button $sim.new -text "New Simulator" -command { New }
pack $sim.prim $sim.prog $sim.new -in $sim -padx 2 -pady 2
###
set core .f.core
frame $core -bd 1 -relief raised
label $core.l -text "core"
button $core.dump -text "dump" -takefocus 0 -command { sendTB "snd-event(dumpcore)" }
# initialize can screw up operations on core
button $core.init -text "initialize" -takefocus 0 -command { sendTB "snd-event(initcore)" }
checkbutton $core.update -text "updates" -indicatoron 1 -takefocus 0 \
    -variable coreupdates -command { CoreUpdates }
set coreupdates 1
pack $core.l $core.dump $core.init $core.update -in $core -side left -padx 2 -pady 2
###
set quit .f.quit
frame $quit -bd 1 -relief raised
button $quit.quit -text "Quit" -command { sendTB "snd-event(quit)" }
pack $quit.quit -in $quit -padx 2 -pady 2
###
pack $sim $core $quit -in .f -fill both
#pack $sim $quit -in .f -fill both

# argc has the wrong value
set argc [llength $argv]
set primitive ""
set basic ""
set progs ""
for {set i 0} {$i < $argc} { incr i} {
    switch -exact -- [lindex $argv $i] {
	-P {
	    incr i
	    set primitive [lindex $argv $i]
	}
	-B {
	    incr i
	    set basic [lindex $argv $i]
	}
	-l {
	    incr i
	    lappend progs [lindex $argv $i]
	    incr i
	    lappend progs [lindex $argv $i]
	}
    }
}

# initialize
sendTB "snd-event(init(\"$basic\"))"

set l [llength $progs]
for {set i 0} {$i < $l} { incr i} {
    set p [lindex $progs $i]
    incr i
    set f [lindex $progs $i]
    sendTB "snd-event(new(\"$p\", \"$basic\", \"$f\"))"
}
