#include <stdio.h>
#include <string.h>

#include "transsystem.h"

static char **labels = NULL;
static unsigned int nrlabels = 0;
static unsigned int maxlabels = 0;

static unsigned int addlabel(char *s) {
    int i;

    for (i = 0; i < nrlabels; i ++) {
	if (strcmp(s, labels[i]) == 0) {
	    return i;
	}
    }
    if (nrlabels == maxlabels) {
	if (maxlabels == 0) {
	    maxlabels = 64;
	    labels = (char **) malloc(maxlabels * sizeof(char *));
	} else {
	    maxlabels *= 2;
	    labels = (char **) realloc(labels, maxlabels * sizeof(char *));
	}
    }
    labels[nrlabels] = (char *) malloc((strlen(s) + 1) * sizeof(char *));
    strcpy(labels[nrlabels], s);
    nrlabels ++;
    return i;
}

static void addtransition(TS * ts, unsigned int s1, unsigned int l, unsigned int s2) {
    int n;
    unsigned int h;

    n = ts->state[s1].nrtrans ++;
    if (n > 0 && l < ts->state[s1].label[0]) {
	h = ts->state[s1].label[0];
	ts->state[s1].label[0] = l;
	l = h;
	h = ts->state[s1].next[0];
	ts->state[s1].next[0] = s2;
	s2 = h;
    }
    ts->state[s1].label[n] = l;
    ts->state[s1].next[n] = s2;
}

void TransGetLabels(TS *ts, unsigned int s, int *n, unsigned int **l) {
    *n = ts->state[s].nrtrans;
    *l = ts->state[s].label;
}

unsigned int Transit(TS *ts, unsigned int s, unsigned int l) {
    return ts->state[s].next[l];
}

TS *TransReadAut(char * fname) {
    FILE *fp;
    TS *ts;
    int i;
    unsigned int s1, s2, ln;
    char l[32];
    int r;

    addlabel("tau");
    if ((fp = fopen(fname, "r")) == NULL) {
	fprintf(stderr, "can't open '%s'\n", fname);
	return NULL;
    }
    ts = (TS *) malloc(sizeof(TS));
    if (fscanf(fp, "des (%u, %u, %u)\n", &ts->start, &ts->nrtrans, &ts->nrstates) != 3) {
	fprintf(stderr, "scan of head failed\n");
	return NULL;
    }
    ts->state = (STATE *) malloc(ts->nrstates * sizeof(STATE));
    for (i = 0; i < ts->nrstates; i ++) {
	ts->state[i].nrtrans = 0;
	ts->state[i].label = (unsigned int *) malloc(2 * sizeof(unsigned int));
	ts->state[i].next = (unsigned int *) malloc(2 * sizeof(unsigned int));
    }
    for (i = 0; i < ts->nrtrans; i ++) {
/*
	r = fscanf(fp, "(%u, \"%[^\"]s", &s1, l);
	r += fscanf(fp, "\", %u)\n", &s2);
*/
	r = fscanf(fp, "(%u, \"%[^ ]s", &s1, l);
	l[strlen(l) - 2] = '\0';
	r += fscanf(fp, " %u)\n", &s2);
	if (r != 3) {
	    fprintf(stderr, "scan of trans %d failed\n", i);
	    return ts;
	}
	ln = addlabel(l);
	addtransition(ts, s1, ln, s2);
    }
    fclose(fp);
    return ts;
}

void TransPrint(TS *ts) {
    int i, j;

    printf("nrstates: %u  nrtrans: %u  start: %u\n", ts->nrstates, ts->nrtrans, ts->start);
    for (i = 0; i < ts->nrstates; i ++) {
	for (j = 0; j < ts->state[i].nrtrans; j ++) {
	    printf("%u  -- %s --> %u\n", i, labels[ts->state[i].label[j]], ts->state[i].next[j]);
	}
    }
}
