#include <stdio.h>

#include "transsystem.h"
#include "array.h"
#include "queue.h"

static int jump[64];
static int nrjumps;

static int branching(TS *ts, unsigned int *s, int *nrl, unsigned int **l) {
    int i;

    nrjumps = 0;
    while (*nrl == 1 && *l[0] == 0) { /* tau */
	jump[nrjumps ++] = *s;
	*s = Transit(ts, *s, 0);
	TransGetLabels(ts, *s, nrl, l);
	for (i = 0; i < nrjumps; i ++) {
	    if (jump[i] == *s)
		return 2;
	}
    }
    return 0;
}
	
static int transitionlistcmp(int n1, unsigned int *l1, int n2, unsigned int *l2) {
    int i;

    if (n1 != n2) {
	return 0;
    }
    if (n1 == 0)
	return -1;
    for (i = 0; i < n1; i ++) {
	if (l1[i] != l2[i]) {
	    return 0;
	}
    }
    return 1;
}

static int bisim(TS *ts1, unsigned int s1, TS *ts2, unsigned int s2) {
    int nrl1, nrl2;
    unsigned int *l1, *l2;
    unsigned int lab;
    int jumped1, jumped2;
    int r;
    int i;
    unsigned int ns1, ns2;

    while (QueueGet(&s1, &s2)) {
	TransGetLabels(ts1, s1, &nrl1, &l1);
	TransGetLabels(ts2, s2, &nrl2, &l2);
	jumped1 = branching(ts1, &s1, &nrl1, &l1);
	jumped2 = branching(ts2, &s2, &nrl2, &l2);
	if (jumped1 == 2 || jumped2 == 2) {
	    if (jumped1 == 2 && jumped2 == 2) {
		continue;
	    } else {
		return 0;
	    }
	}
	r = transitionlistcmp(nrl1, l1, nrl2, l2);
	if (r > 0) { /* same */
	    ArraySet(s1, s2, 1);
	    for (i = nrl1 - 1; i >= 0; i --) {
		ns1 = Transit(ts1, s1, i);
		ns2 = Transit(ts2, s2, i);
		if (! ArrayGet(ns1, ns2)) {
		    QueueAdd(ns1, ns2);
		}
	    }
	} else if (r == 0) { /* diff */
	    return 0;
	} else { /* end states */
	    continue;
	}
    }
    return 1;
}

int BisimTest(TS *ts1, TS *ts2) {
    unsigned int s1, s2;

    ArrayInit(ts1->nrstates, ts2->nrstates);

    s1 = ts1->start;
    s2 = ts2->start;
    QueueAdd(s1, s2);
    if (! bisim(ts1, s1, ts2, s2)) {
	return 0;
    }
}

void BisimReduce(TS *ts) {
    unsigned int i, j, n;

    n = ts->nrstates;
    ArrayInit(0, n);
    for (i = 0; i < n; i ++) {
	for (j = i + 1; j < n; j ++) {
	    QueueAdd(i, j);
	    bisim(ts, i, ts, j);
	}
    }
}

void BisimPrintStack() {
    int i;

}
