#include <stdio.h>
#include <stdlib.h>

#define MSIZE 1000
typedef struct statepair {
    unsigned int s1[MSIZE];
    unsigned int s2[MSIZE];
    int i;
    struct statepair *next;
} StatePair;
static StatePair *todo = NULL;
static StatePair *myfree = NULL;

static unsigned int max = 0;
static unsigned int nr = 0;

void QueueAdd(unsigned int s1, unsigned int s2) {
    StatePair *h;

    if (todo != NULL && todo->i < MSIZE - 1) {
	    todo->i ++;
    } else {
	if (myfree != NULL) {
	    h = myfree;
	    myfree = myfree->next;
	} else {
	    h = (StatePair *) malloc(sizeof(StatePair));
	    nr ++;
	    if (nr > max)
		max = nr;
	}
	h ->next = todo;
	todo = h;
	todo->i = 0;
    }
    todo->s1[todo->i] = s1;
    todo->s2[todo->i] = s2;
}

int QueueGet(unsigned int *s1, unsigned int *s2) {
    StatePair *h;

    if (todo == NULL) {
	return 0;
    }
    *s1 = todo->s1[todo->i];
    *s2 = todo->s2[todo->i];
    todo->i --;
    if (todo->i < 0) {
	h = todo;
	todo = todo->next;
	h->next = myfree;
	myfree = h;
    }
    return 1;
}

void QueueMax() {
    fprintf(stderr, "max queue: %u\n", max);
}
