#include <stdio.h>
#include <stdlib.h>

#include "transsystem.h"
#include "bisimtest.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

static void size() {
    pid_t pid;
    char s[64];
    struct stat st;
    long unsigned int n;

    pid = getpid();
    sprintf(s, "/proc/%u/as", pid);
    stat(s, &st);
    n = st.st_size / (1024 * 1024);
    fprintf(stderr, "size: %lu MB\n", n);
}

int main(int argc, char **argv) {
    TS *ts1, *ts2;
    int option_info = 0;

    while (-- argc > 0) {
	if ((* ++ argv)[0] == '-') {
	    if (strcmp(*argv, "-i") == 0) {
		option_info = 1;
	    } else {
		fprintf(stderr, "unknown option %s\n", *argv);
		exit (1);
	    }
	} else {
	    break;
	}
    }

    if (argc == 2) {
	ts1 = TransReadAut(argv[0]);
	ts2 = TransReadAut(argv[1]);
	if (ts1 == NULL || ts2 == NULL)
	    exit(1);
	if (BisimTest(ts1, ts2)) {
	    printf ("bisimulation\n");
	} else {
	    printf (" NO bisimulation\n");
	    BisimPrintStack();
	}
	if (option_info) {
	    QueueMax();
	    size();
	}
    } else {
	fprintf(stderr, "usage: bisim [-i] file1 file2\n");
	exit(1);
    }
}
