
package TransSystem;

use Exporter ();
@ISA = (Exporter);

$VERSION = "0.02";

@EXPORT = qw( AddState AddTransition Print );

sub new {
    my $class = shift;
    my $self = {};
    bless $self, $class;
    return $self;
}

my $labelmax = 0;
my %labelnr = ( tau => 0 );
my @nrlabel = ( tau );

sub addlabel {
    my $label = shift;
    my $nr;

    if (exists $labelnr{$label}) {
	$nr = $labelnr{$label};
    } else {
	$labelmax ++;
	$labelnr{$label} = $labelmax;
	$nr = $labelmax;
	$nrlabel[$nr] = $label;
    }
    return $nr;
}

sub AddState {
    my $self = shift;
    my $state = shift;
    my $list = shift;

    $list =~ s/ //g;
    $self->{state}[$state] = $list;
}

sub numerically { $a <=> $b }

sub AddTransition {
    my $self = shift;
    my $state1 = shift;
    my $state2 = shift;
    my $label = shift;
    my $nr;

    # when AddState is not used we define them just for the number of states
    if (! defined $self->{state}[$state1]) {
	$self->{state}[$state1] = 0;
    }
    if (! defined $self->{state}[$state2]) {
	$self->{state}[$state2] = 0;
    }
    $nr = addlabel($label);
    $self->{trans}[$state1]{$nr} = $state2;
    push @{$self->{trans}[$state1]{labels}}, $nr;
    # sort the labels for easy comparison with another label-list
    @{$self->{trans}[$state1]{labels}} = sort numerically @{$self->{trans}[$state1]{labels}};
}

sub Print {
    my $self = shift;

    print "states\n";
    $n = scalar @{$self->{state}};
    for ($i = 0; $i < $n; $i ++) {
	if (defined $self->{state}[$i]) {
	    $l = join(", ", @{$self->{trans}[$i]{labels}});
	    print "    $i - $l\n";
	}
    }
    print "transitions\n";
    $n = scalar @{$self->{trans}};
    for ($i = 0; $i < $n; $i ++) {
	if (defined $self->{trans}[$i]) {
#	    foreach $key (keys %{$self->{trans}[$i]}) {
	    foreach $key (@{$self->{trans}[$i]{labels}}) {
		$label = $nrlabel[$key];
		print "    $i  '$label' -> $self->{trans}[$i]{$key}\n";
	    }
	}
    }
}

sub WriteAut {
    my $self = shift;

    # count transitions
    $n = scalar @{$self->{trans}};
    $trans = 0;
    for ($i = 0; $i < $n; $i ++) {
	if (defined $self->{trans}[$i]) {
	    foreach $key (@{$self->{trans}[$i]{labels}}) {
		$trans ++;
	    }
	}
    }
    $states = scalar @{$self->{state}};
    print "des (0, $trans, $states)\n";
    for ($i = 0; $i < $n; $i ++) {
	if (defined $self->{trans}[$i]) {
#	    foreach $key (keys %{$self->{trans}[$i]}) {
	    foreach $key (@{$self->{trans}[$i]{labels}}) {
		$label = $nrlabel[$key];
		print "($i, \"$label\", $self->{trans}[$i]{$key})\n";
	    }
	}
    }
}

sub ReadAut {
    my $self = shift;
    my $file = shift;

    $ts = $self->new;
    if (open(IN, "<$file")) {
	$l = <IN>;
	if ($l =~ /^des\s*\((\d+),\s*(\d+),\s*(\d+)\)$/) {
	    $start = $1;
	    $nrtrans = $2;
	    $nrstates = $3;
	} else {
	    die "error reading $file header: $l\n";
	}
	for ($i = 0; $i < $nrtrans; $i ++) {
	    $l = <IN>;
	    if ($l =~ /^\((\d+),\s*\"(.*)\",\s*(\d+)\)$/) {
		$s1 = $1;
		$label = $2;
		$s2 = $3;
	    } else {
		die "error reading $file transition: $l\n";
	    }
	    $ts->AddTransition($s1, $s2, $label);
	}
	close IN;
	return $ts;
    } else {
	return undef;
    }
}

sub SetState {
    my $self = shift;
    my $state = shift;

    $self->{current} = $state;
}

sub Transit {
    my $self = shift;
    my $s = shift;
    my $label = shift;

    return $self->{trans}[$s]{$label};
#    return $self->{current} = $self->{trans}[$self->{current}]{$label};
}

sub GetLabels {
    my $self = shift;
    my $s = shift;

#    return keys %{$self->{trans}[$self->{current}]};
#    return \@{$self->{trans}[$self->{current}]{labels}};
    return \@{$self->{trans}[$s]{labels}};
}

sub StateInfo {
    my $self = shift;

    return $self->{state}[$self->{current}];
}

sub NrStates {
    my $self = shift;

    return $#{$self->{state}} + 1;
}

1;
